#define GC_BASE(slot)		(unsigned char *)(0x600000 + (slot << 16))
#define GC_TOP(slot)		(unsigned char *)(0x60fffc + (slot << 16))
#define GC_VREGS(slot)		(int *)(0x60ff00 + (slot << 16))
#define GC_RTB(slot)		(union rtb *)(0x60fffc + (slot << 16))
#define GC_BDVECT(slot)		(struct bd_desc *)(0x60ffec + (slot << 16))
#define GC_SAR(slot)		(int *)(0x60ff80 + (slot << 16))

/*
 *	identify code running
 */

#define GC_VER			0x20			/* gc version 2.0*/
#define GC_CODE_TTY		((GC_VER<<8)|01)	/* tty		*/
#define GC_CODE_TTM		((GC_VER<<8)|02)	/* ttm (mux tty)*/
#define GC_CODE_BSC		((GC_VER<<8)|03)	/* tty + bsc	*/
#define GC_CODE_SNA		((GC_VER<<8)|04)	/* tty + sna	*/
#define GC_CODE_MOD		((GC_VER<<8)|15)	/* model	*/

/*
 *	master to slave command groups
 */

#define GC_GC_COMMANDS		0x0000	/* gc command group		*/
#define GC_TTY_COMMANDS		0x1000	/* tty command group		*/
#define GC_LP_COMMANDS		0x2000	/* lp command group		*/
#define GC_TTM_COMMANDS		0x3000	/* ttm command group		*/
#define GC_BSC_COMMANDS		0x4000	/* bsc command group		*/
#define GC_SNA_COMMANDS		0x5000	/* sna command group		*/
#define GC_SDLC_COMMANDS	0x6000	/* sdlc command group		*/
#define GC_MOD_COMMANDS		0xf000	/* model command group		*/

struct cir_buf {
	unsigned char *	cb_hoq;
	unsigned char *	cb_eoq;
	unsigned char *	cb_base;
	unsigned char *	cb_end;
	unsigned short	cb_hi_water;
	unsigned short	cb_low_water;
	unsigned short	cb_hog_water;
	unsigned char cb_in_flag;
	unsigned char cb_out_flag;
};

struct cirbuf {
	unsigned short	flag;
	unsigned short	count;
	unsigned char *	hoq;
	unsigned char *	eoq;
	unsigned char *	base;
	unsigned char *	end;
	unsigned short	hi_water;
	unsigned short	low_water;
	unsigned short	hog_water;
};

struct gc {
	struct cir_buf 	*gc_mtos;
	struct cir_buf 	*gc_stom;
	unsigned char 	*gc_base;
	int	 	*gc_vreg;
	union rtb	*gc_rtb;
	int		*gc_tas;
	long		*gc_sar;
	int		 gc_code;
	unsigned char	 gc_flag;
	unsigned char	 gc_board;
	int 		(* gc_reset)();
};

struct gc_switch {
	unsigned short	  gcs_group;		/* command group	*/
	int		(*gcs_initialize)();	/* initialize routine	*/
	int		(*gcs_interrupt)();	/* interrupt routine	*/
	int		(*gcs_reset)();		/* reset routine	*/
};

/*  cirbuf flags */

#define BUFEMPTY	0x0100		/* buffer empty */
#define BUFFULL		0x0200		/* buffer full */

/*
	virtual registers
 */

#define GC_VR_BASE		0x3fc0	/* base of virtual registers	*/

#define GC_VR_MTOS		0	/* master to slave commands	*/
#define GC_VR_STOM		1	/* slave to master commands	*/
#define GC_VR_TAS		2	/* test and set owner		*/
#define GC_VR_CODE		3	/* code running on gcp		*/
#define GC_VR_TIME		4	/* time of day (sec)		*/
#define GC_VR_SAR		5	/* system activity counters	*/
#define GC_VR_TTY		6	/* tty control blocks		*/
#define GC_VR_LP		7	/* lp control blocks		*/
#define GC_VR_TTM		8	/* ttm control blocks		*/
#define GC_VR_BSC		9	/* bsc control blocks		*/
#define GC_VR_SNA		10	/* sna control blocks		*/
#define GC_VR_SDLC		11	/* sdlc control blocks		*/
#define GC_VR_MOD		12	/* model control blocks		*/

/*
	test and set owner
 */

#define LOCK_FREE	0	/* channel not locked */
#define LOCK_MASTER	1	/* master has channel locked */
#define LOCK_SLAVE	2	/* slave has channel locked */
#define LOCK_ERROR	3	/* channel lock error */

#define GC_ICB_MSPNDG	0x8000		/* master to slave int pending */
#define GC_ICB_SMPNDG	0x4000		/* slave to master int pending */
#define GC_ICB_OREQ(cmd)	icboreq(cmd | ICB_SMPNDG)

#define GC_INT_DEV(n) (n&0x00ff)
#define GC_INT_GRP(n) (n&0xf000)
#define GC_INT_CMD(n) (n&0xff00)
