/* @(#)file.h	6.1 */

#define FILE_H

#ifndef TYPES_H
#include "sys/types.h"
#endif TYPES_H
/*
 * One file structure is allocated for each open/creat/pipe call.
 * Main use is to hold the read/write pointer associated with
 * each open file.
 */
struct	file
{
	char	f_flag;
	char	pad[3];
	cnt_t	f_count;		/* reference count */
	char	pad1[2];
	union {
		struct inode *f_uinode;	/* pointer to inode structure */
		struct file  *f_unext;	/* next entry in freelist */
	} f_up;
	off_t	f_offset;		/* read/write character pointer */
	short	f_file_lock;
	char	pad3[2];

};

#define	f_inode		f_up.f_uinode
#define	f_next		f_up.f_unext

extern struct file file[];	/* The file table itself */
extern struct file *ffreelist;	/* Head of freelist pool */

/* flags */
#define	FOPEN	(-1)
#define	FREAD	00001
#define	FWRITE	00002
#define	FNDELAY	00004
#define	FAPPEND	00010
#define	FSYNC	00020
#define	FMASK	00377

/* open only modes */
#define	FCREAT	00400
#define	FTRUNC	01000
#define	FEXCL	02000

/* lock flags */
#define FILE_WANTED	00001
#define	FILE_LOCKED	00002

