
typedef struct hsdt {
	struct bd_desc	*bd_ptr;
	short 		slot;
	int		(* intr)();
	int		(* strt)();
}HSDT_INFO;

/* command code in disk request */

#define LREAD	1		/* logical drive read */
#define LWRITE	2		/* logical drive write */
#define PLREAD	5		/* physical drive read with spare lookup */
#define PLWRITE	6		/* physical drive write with spare lookup */

#define DISK	1		/* device type for disk requests to hs/edt */
#define TAPE	2		/* device type for archive requests */
#define TAPE9   0x82		/* device type for nine track requests */

/* mask for dktab byte of driver_queue_flag */
#define DISK_REQUEST		0xff000000
#define ARCHIVE_REQUEST		0x00ff0000
#define TRK9_REQUEST		0x0000ff00
#define RESERVE_DISK_REQUEST	0x000000ff

#define PF_WAIT  0x1d		/* power fail wait command for hs/etd */
