/*	@(#)cpu.h	3.13	*/
/* @(#)cpu.h	6.1 */
#define onek 1024

#define map_start	0x480e00
#define MMUADDRESS	0x480e00

#define map_lwords	(1*onek)
#define sys_reg		(char *)0x4a0001
#define usr_reg		(char *)0x4a0003
#define mmu_ctl_reg	(char *)0x4a000f
#define USEROFFSETADDR	0x4a0003
#define USERIDADDR	0x4a000b
#define ENBLREGADDR	0x4a000f
#define SYSIDREGADDR	0x4a0009
#define SYSOFFSETADDR   0x4a0001
#define fault_reg	(unsigned char *)0x4e0007

#define CPUSTATREG	(char *) 0x4e0001
#define CPULEDS		(char *) 0x4e0003
#define CPU20LEDS	(char *) 0x4a0004
#define PROMDISABLE	8
#define CACHEUPDATENB	0x20
#define CACHENB		0x10
#define	TAGBITSADDR	0x4c0000
#define NMI		0x40
#define NEWMAP		0x80	/* four 16M context or a single 64M context */

#define RTBTIME		0x40
#define RTBBUSERR	0x20
#define FATALMEMFLT	0x10
#define FLTDATAACESS    0x8
#define FLTCODEACCESS   0x4
#define FLTWRITEPROT	0x2
#define FLTPROCID	0x1

#define NONFATALMEM	0x0


/* bit position in cpu_ctl_reg */
#define prom_dis	0x03

#define acia_stat_port	(char *) 0x420011
#define acia_data_reg	(char *) 0x420013
#define acia_cntrl_reg	(char *) 0x420011
#define ptm_stat_reg	(char *) 0x420003
#define ptm_cnt1rd	(char *) 0x420005
#define ptm_cnt2rd	(char *) 0x420009
#define ptm_cnt3rd	(char *) 0x42000d
#define led_port	(char *) 0x4e0003
#define config_port	(char *) 0x4e0003
