/*	@(#)cons.h	3.13	*/
/*   @(#)Arete/5.0   6/30/84   /usr/src/head/sys/cons.h   */

/*
 *	x1000 console interface registers
 *
 *	hardware definitions for the motorola mc6850
 */

#define	C_DATA	0x00ff	/* data byte */

/*
 *	control register
 */

#define C_1X		0x0000	/* clock divide by 1 */
#define C_16X		0x0001	/* clock divide by 16 */
#define C_64X		0x0002	/* clock divide by 64 */
#define C_RST		0x0003	/* master reset */

#define C_7BEP2S	0x0000	/* 7 bits, even parity, 2 stop bits */
#define C_7BOP2S	0x0004	/* 7 bits, odd  parity, 2 stop bits */
#define C_7BEP1S	0x0008	/* 7 bits, even parity, 1 stop bits */
#define C_7BOP1S	0x000c	/* 7 bits, odd  parity, 1 stop bits */
#define C_8BXP2S	0x0010	/* 8 bits, no   parity, 2 stop bits */
#define C_8BXP1S	0x0014	/* 8 bits, no   parity, 1 stop bits */
#define C_8BEP1S	0x0018	/* 8 bits, even parity, 1 stop bits */
#define C_8BOP1S	0x001c	/* 8 bits, odd  parity, 1 stop bits */

#define	C_TXIE		0x0020	/* transmitter interrupt enable */
#define	C_RXIE		0x0080	/* receiver interrupt enable */

/*
 *	status register
 */

#define C_RDRF		0x0001	/* receiver data register full */
#define C_TDRE		0x0002	/* transmit data register empty */
#define C_DCD		0x0004	/* data carrier detect */
#define C_CTS		0x0008	/* clear to send */
#define C_FE		0x0010	/* framing error */
#define C_OVRN		0x0020	/* receiver overrun */
#define C_PE		0x0040	/* parity error */
#define C_IRQ		0x0080	/* interrupt request */
