struct con20 {
	struct ascc * c20_ascc[2];	/* mem map ascc pointers */
	unsigned char c20_flags[2];	/* flags */
	unsigned char c20_exst[2];	/* software copies of external stat */
	unsigned char c20_wr5;		/* software copy of ascc's WR5 */
};

#define CONSPORT	0
#define DIAGPORT	1

#define CF20_BREAK	0x01	/* break pending */
#define CF20_DCD	0x02	/* DCD on */
#define CF20_LOCKED	0x04	/* port baud rate locked */

#define SCCSTVECT 0x10
#define ASCC0A  (struct ascc *)0x500020
#define ASCC0B  (struct ascc *)0x500000

/* the below time constants assume a 4mhz source clock and x16 multiplier */
#define BDRT38K    0x0001  /* timer values for 38.4k baud */
#define BDRT19K    0x0004  /* timer values for 19.2k baud */
#define BDRT9600   0x000a  /* timer values for 9600 baud */
#define BDRT4800   0x0016  /* timer values for 4800 baud */
#define BDRT2400   0x002e  /* timer values for 2400 baud */
#define BDRT1800   0x003e  /* timer values for 1800 baud */
#define BDRT1200   0x005e  /* timer values for 1200 baud */
#define BDRT600    0x00be  /* timer values for 600 baud */
#define BDRT300    0x017e  /* timer values for 300 baud */
#define BDRT200    0x023e  /* timer values for 200 baud */
#define BDRT150    0x02fe  /* timer values for 150 baud */
#define BDRT134    0x0356  /* timer values for 134.5 baud */
#define BDRT110    0x0415  /* timer values for 110 baud */
#define BDRT75     0x05fe  /* timer values for 75 baud */
#define BDRT50     0x08fe  /* timer values for 50 baud */
