/*	@(#)buf.h	3.13	*/

#define BUF_H

#ifndef TYPES_H
#include "sys/types.h"
#endif TYPE_H
#define	paddr(X)	(paddr_t)(X->b_un.b_addr)

/* @(#)buf.h	6.1 */
/*
 * Each buffer in the pool is usually doubly linked into 2 lists:
 * the device with which it is currently associated (always)
 * and also on a list of blocks available for allocation
 * for other use (usually).
 * A buffer is on the available list, and is liable
 * to be reassigned to another disk block, if and only
 * if it is not marked BUSY.  When a buffer is busy, the
 * available-list pointers can be used for other purposes.
 * Most drivers use the forward ptr as a link in their I/O active queue.
 * A buffer header contains all the information required to perform I/O.
 * Most of the routines which manipulate these things are in bio.c.
 */
struct buf
{
	int	b_flags;		/* see defines below */
	struct	buf *b_forw;		/* headed by d_tab of conf.c */
	struct	buf *b_back;		/*  "  */
	struct	buf *av_forw;		/* position on free list, */
	struct	buf *av_back;		/*     if not BUSY*/
	dev_t	b_dev;			/* major+minor device name */
	char	b_error;		/* returned after I/O */
	char	pad;
	unsigned b_bcount;		/* transfer count */
	union {
	    caddr_t b_addr;		/* low order core address */
	    int	*b_words;		/* words for clearing */
	    struct filsys *b_filsys;	/* superblocks */
	    struct dinode *b_dino;	/* ilist */
	    daddr_t *b_daddr;		/* indirect block */
	} b_un;
	daddr_t	b_blkno;		/* block # on device */
	unsigned int b_resid;		/* words not transferred after error */
	time_t	b_start;		/* request start time */
	int	b_want_flag;		/* buf is wanted by another process */
	struct  proc  *b_proc;		/* process doing physical or swap I/O */
	int	b_driver_flags;		/* flag for non critical region info */
};

extern struct buf bfreelist;		/* head of available list */
extern struct buf pbuf[];		/* Physio header pool */
struct pfree {
	int	b_flags;
	struct	buf *av_forw;
};
extern struct pfree pfreelist;		/* head of physio pool */



/*
 * These flags are kept in b_flags for buffer io.
 */
#define	B_WRITE			0x0000	/* non-read pseudo-flag */
#define	B_READ			0x0001	/* read when I/O occurs */
#define	B_DONE			0x0002	/* transaction finished */
#define	B_ERROR			0x0004	/* transaction aborted */
#define	B_BUSY			0x0008	/* not on av_forw/back list */
#define	B_PHYS			0x0010	/* Physical IO */
#define	B_SWAP			0x0020	/* swap io is occuring */
#define	B_WANTED		0x0040	/* issue wakeup when BUSY goes off */
#define	B_AGE			0x0080	/* delayed write for correct aging */
#define	B_ASYNC			0x0100	/* don't wait for I/O completion */
#define	B_DELWRI		0x0200	/* don't write until block leaves
					   available list */
#define	B_OPEN			0x0400	/* open routine called */
#define	B_READAHEAD		0x0800	/* buffer marked busy, but can't wait
				   	   for it yet */
#define B_SKIP_DENSITY		0x2000	/* single density nine track device */
#define B_OK_TO_QUEUE_REQ	0x4000	/* ok to queue request at tail of
					   dk/nt/mt/rdktab */
#define B_STALE			0x8000  /* device closed but pending io not
					   done or b_error on io */

/* 
	These flags are kept for the bfreelist
*/
#define	BFREELIST_WANTED 0x1	/* process is waiting for the bfreelist */
#define BFREELIST_LOW	0x2	/* buffer algorithms get modified if the
				   bfreelist is close to being empty */

/*
 * Fast access to buffers in cache by hashing.
 */

#define	bhash(d,b)	((struct buf *)&hbuf[((int)d+(int)b)&v.v_hmask])

struct hbuf
{
	int	b_flags;
	struct	buf *b_forw;
	struct	buf *b_back;
};

extern struct hbuf hbuf[];
