/*		Copyright (c) 1985 AT&T		*/
/*		All Rights Reserved		*/
/*	@(#)nan.h	6.2		*/
/*	@(#)nan.h	4.2	 */
/* Handling of Not_a_Number's (only in IEEE floating-point standard) */

#define KILLFPE()	(void) kill(getpid(), 8)
#if u3b || u3b5 || m68k || M68020
#if m68k || M68020
/* NaN occurs when exp=max=0x7ff and fractional part != 0 */
#define NaN(X) \
(((union { double d; struct { unsigned :1, e:11, f1:20, f2:32; } s; } *)&X)->s.e == 0x7ff) \
&& ( \
(((union { double d; struct { unsigned :1, e:11, f1:20, f2:32; } s; } *)&X)->s.f1 != 0) \
|| \
(((union { double d; struct { unsigned :1, e:11, f1:20, f2:32; } s; } *)&X)->s.f2 != 0) \
)
#define KILLNaN(X)	if (NaN(X)) KILLFPE()
#else
#define NaN(X)	(((union { double d; struct { unsigned :1, e:11; } s; } \
			*)&X)->s.e == 0x7ff)
#define KILLNaN(X)	if (NaN(X)) KILLFPE()
#endif
#else
#define Nan(X)	0
#define KILLNaN(X)
#endif

