#define DISABLE() {\
	asm("	or.w	&0x0600,%sr");\
	asm("	add.b	&1,sys_eidi");\
}

#define DISABLE0() {\
	asm("	or.w	&0x0600,%sr");\
	asm("	mov.b	&1,sys_eidi");\
}

#define ENABLE() {\
	if (!sys_eidi || !--sys_eidi)\
		asm("	and.w	&0xf8ff,%sr");\
}

#define ENABLE0() {\
	asm("	mov.b	&0,sys_eidi");\
	asm("	and.w	&0xf8ff,%sr");\
}

#define EIDI0() {\
	asm("	mov.b	&0,sys_eidi");\
	asm("	and.w	&0xf8ff,%sr");\
	asm("	nop");\
	asm("	or.w	&0x0600,%sr");\
	asm("	mov.b	&1,sys_eidi");\
}

#define GCP_STOM_CMD(cmd) icbcmd(cmd | tp->t_device);

/*****************************************************************
 *
 *	B Y T E   O U T
 *
 *	Get a byte from a "cirbuf"
 *
 *	input parameters:
 *		1.  buffer pointer
 *		2.  the byte
 *
 *	output parameters:
 *		2.  -1 if the buffer is empty
 *
 *****************************************************************/

#define BYTEOUT(bp, c) {\
	if((bp->hoq == bp->eoq) && !bp->count)\
		c = -1;\
	else {\
		c = *bp->hoq++;\
		if (bp->hoq == bp->end)\
			bp->hoq = bp->base;\
		bp->count--;\
	}\
}

#define BYTE_OUT(bp, c) {\
	if (bp->cb_eoq == bp->cb_hoq)\
		c = -1;\
	else {\
		c = *bp->cb_hoq++;\
		if (bp->cb_hoq == bp->cb_end)\
			bp->cb_hoq = bp->cb_base;\
	}\
}

/*****************************************************************
 *
 *	B Y T E   I N
 *
 *	Place a byte into a "cirbuf"
 *
 *	input parameters:
 *
 *		1.  buffer pointer
 *		2.  the byte
 *		3.  return code
 *			1  -  if successful
 *			0  -  if buffer is full
 *
 *****************************************************************/

#define BYTEIN(bp, c, rc) {\
	if((bp->hoq == bp->eoq) && bp->count)\
		rc = 0;\
	else {\
		*bp->eoq++ = c;\
		if (bp->eoq == bp->end)\
			bp->eoq = bp->base;\
		bp->count++;\
		rc = 1;\
	}\
}

/*********************************************************
 *
 *	R A W   I N
 *
 *	get a byte from the raw queue
 *
 *	input parameters:
 *		1.  raw buffer pointer
 *		2.  the byte
 *
 *********************************************************/

#define RAWIN(bp, c) {\
	DISABLE0();\
	BYTEOUT(bp, c);\
	ENABLE0();\
	if (tp->t_state&TBLOCK)\
		txstart(tp);\
}

/*********************************************************
 *
 *	R A W   O U T
 *
 *	Put a byte into the raw queue
 *
 *	input parameters:
 *		1.  raw buffer pointer
 *		2.  the byte
 *		3.  return code
 *			1  -  if successful
 *			0  -  if buffer is full
 *
 *********************************************************/

#define RAWOUT(bp, c, rc) {\
	do {\
		DISABLE0();\
		BYTEIN(bp, c, rc);\
		ENABLE0();\
		if (rc)\
			break;\
		while (tp->t_rawq.count > tp->t_rawq.low_water) {\
			if (tp->t_canq.count)\
				delay(100);\
			else\
				canon(tp);\
		}\
	} while (1);\
}

/*********************************************************
 *
 *	F L U S H    B U F
 *
 *	flush a cirbuf
 *
 *********************************************************/

#define FLUSHBUF(cb) {\
	cb.count = 0;\
	cb.hoq = cb.eoq;\
}
