/*******************************************************************
 *
 *			G  C  I  O  C  P
 *
 *	GENERAL COMMUNICATION INPUT/OUTPUT CONTROL PROCESSOR
 *
 *******************************************************************/

#define RTC_8MEG_TC	50000		/* real time clock time constant */
#define RTC_10MEG_TC	62500		/* real time clock time constant */
#define RTC_MS		25		/* 25 mili seconds per tick */
#define RTC_TPS		1000/RTC_MS	/* rtc ticks per second */

/*******************************************************************
 *
 *	M E M O R Y    M A P P E D    I / O
 *
 *******************************************************************/

#define SCC0B		(struct scc *)		0x50000
#define SCC0A		(struct scc *)		0x50020
#define SCC1B		(struct scc *)		0x52000
#define SCC1A		(struct scc *)		0x52020
#define SCC2B		(struct scc *)		0x54000
#define SCC2A		(struct scc *)		0x54020
#define SCC3B		(struct scc *)		0x56000
#define SCC3A		(struct scc *)		0x56020
#define CIO		(struct cio *)		0x58000
#define ICB_INTERRUPT	(unsigned short *)	0x60006
#define ICB_STATUS	(unsigned short *)	0x60004
#define ICB_HISTAT	(unsigned char *)	0x60004
#define ICB_LOSTAT	(unsigned char *)	0x60005
#define GCP_IF_CTRL	(unsigned short *)	0x60004
#define MEM_FLT_CLR	(unsigned char *)	0x60002
#define FLOAT_BASE	(unsigned char *)	0x60003
#define TAS_CLR		(unsigned char *)	0x60000
#define BD_CONTROL	(unsigned char *)	0x60001
#define GCP_XMEM	(unsigned char *)	0x80000

/*******************************************************************
 *
 *	I N T E R R U P T    V E C T O R S
 *
 *******************************************************************/

#define SCC0VEC		0x30
#define SCC1VEC		0x40
#define SCC2VEC		0x50
#define SCC3VEC		0x60
#define PORTAVEC	0x70
#define PORTBVEC	0x80
#define CTCVEC		0x90

/*******************************************************************
 *
 *	B O A R D    C O N T R O L
 *
 *******************************************************************/

#define BC_IF_RESET_NOT		0x80
#define BC_MEM_CONFIG		0x40
#define BC_IOP_READY		0x20
#define BC_FLOAT_MEM_ENBL	0x10
#define BC_PARITY_ENBL		0x08
#define BC_REFRESH_ENBL_NOT	0x04
#define BC_MASK_LED		0xfc
#define BC_YELLOW_LED		0x00
#define BC_GREEN_LED		0x01
#define BC_RED_LED		0x02
#define BC_NO_LED		0x03
