/*
*************************************************************************fil**
**		 ARETE SYSTEMS CORPORATION CONFIDENTIAL AND PROPRIETARY
**	This source is the sole property of ARETE SYSTEMS CORPORATION
**	Reproduction or utilization of this source in whole or in part
**	is forbidden without the written consent of 
**	ARETE SYSTEMS CORPORATION.
******************************************************************************
**			(c) Copyright ARETE SYSTEMS CORPORATION 1988
**			    All Rights Reserved.
******************************************************************************
**	FILE NAME:	rwiscc.c
******************************************************************************
*/ 

#include "types.h"
#include "rwiscc.h"
#include "rwi.h"
#include "rwicio.h"
#include "spm.h"
#include "novram.h"
#include "misc.h"

#define	READ_MAX_THROW		150
#define BREAK_MAX_THROW		80000

#define CONSOLE_PTR SCC0A	/* don't want to test the console port */
				/* kills I/O to user. */
static  int sccintest;			/* make sure not in test mode. */
static  int scsint; 			/* show special int occured. */
static  int scrint; 			/* show receive int occured. */
static  int sceint; 			/* show external int occured. */
static  int sctint; 			/* show transmitter int occured. */
static  char rxdata;			/* buffer for receiver. */

extern  uchar  byte_throw;
extern  uchar  modem_on;

extern struct   baud baudtab[];
extern uchar	modem_baud_num;
extern uchar	console_baud_num;
extern uchar	printer_baud_num;
extern uchar	ups_baud_num;

static  struct scc *sccs[] = {
	SCC0A,
	SCC0B,
	SCC1A,
	SCC1B,
};

	/* initialization table for the SCC's */
static  struct sccinit {
	uchar portnum;
	uchar portval;
} sccivals[] = {
	11,WR11_BRGO | WR11_TCGO | WR11_RCGO, /* WR11_TRXC | */
	12,BDRT9600, 				/* baud rate (low byte) */
	13,BDRT9600 >> 8,  			/* (high byte) */
	14,WR14_ENABD | WR14_PCLK,  	/* enable baud rate gen, pclk source*/
	2,SCCSTVECT,			/* starting int vector for SCC's */
	4,WR4_1STOP | WR4_16CLOCK,  	/* one stop bit, no parity, clock x16 */
	3,WR3_RX8 | WR3_RXEN | WR3_AUTO, /* 8 bit rx chars, receiver enable */
	5,WR5_TX8 | WR5_TXEN | WR5_DTR | WR5_RTS, /* causes PU to fail.. */
	/* assert DTR, 8 bit tx char, enable transmitter, assert RTS */

	1,WR1_RXALL | WR1_TXEN,  /*ena ints for Rx chars, spec cond, and Tx*/
	0,WR0_EXINT,  /* reset possible pending external/status interrupt */
	9,WR9_MIE | WR9_VIS,  /* master int enable, vector includes status */
};


#ifdef	REMOVE
/*
******************************************************************************
*/ 

progscc(sccnum, tst, fin)	/* program a single scc as setup by init.c.. */
register sccnum;
int tst;	/* if set, use testing mode instead of running mode. */
int	fin;	/* if set, set register 5 WR5_RTS as well.. */
{
	register struct scc *s_ptr;
	register struct sccinit *i_ptr;
	register uint value;
	register i;

	if (ACRW_HERE && sccnum > 1) {
		printf ("Cannot program SCC1 on ACRW; not installed.\n");
		return;
	}

	s_ptr = sccs[sccnum]; /* real device address. */

	if(sccnum & 0x01)		/* if channel B.. */
		value = WR9_BRST;
	else
		value = WR9_ARST;	/* else channel A.. */

	s_ptr->reg[9].reg = value; /* reset appropriate channel */
	s_ptr->reg[9].reg = 0;  /* reset the reset to it... */

	i_ptr = sccivals; /* point to first table entry */

	for(i=0; i<(sizeof(sccivals)/sizeof(struct sccinit)); i++, i_ptr++) {
		value = i_ptr->portval; /* get value from table */
		switch (i_ptr->portnum) {
			case 2:
				value = ADJSCCVECT(sccnum); /* adjust interrupt vector */
				if((sccnum&0xfe) == 14) /* special for chan 14 | 15 */
					value &= 0x7f;	/* remove the +128 option..*/
				break;
			case 12:	/* baud rate generator low and high bytes. */
			case 13:
				value = BDRT9600;
				if(i_ptr->portnum & 0x01) value >>= 8; /* port 13 gets msb */
				break;
			case 5:
				if(fin)
					value |= WR5_RTS;  /* set this as well. */
		}
		s_ptr->reg[i_ptr->portnum].reg = value; /* program the register */
	}
}
#endif

#ifdef	REMOVE
/*------------------------------------------------------------------------------
 Test the scc:  This routine does several tests.. first, it does a write/read
 test on the register of the scc's.  After that passes, it switches to internal
 loopback mode, and sends a byte.  It will then pause while the byte transfers
 to the input register.  It will then switch the data and try the byte again.
 After this is done, the scc is declared good.
------------------------------------------------------------------------------*/
testsccs()
{
	register i;
	register num_scc_chan;
	register struct scc *sccptr;
	register struct scc **sccvctr = sccs;
	int	er;

	sccintest=0;	/* make sure not in test mode. */
	scsint=0; /* show special int occured. */
	scrint=0; /* show receive int occured. */
	sceint=0; /* show external int occured. */
	sctint=0; /* show transmitter int occured. */
	rxdata=0;	/* buffer for receiver. */

	initscc();

	if (ACRW_HERE)
		num_scc_chan = ACRW_NUMSCHAN;
	else
		num_scc_chan = NUMSCHAN;

	for(i=0; i<num_scc_chan; i++) 		 /* write patterns to counter registers */
	{
		sccptr = *sccvctr++;
		if(sccptr != CONSOLE_PTR)
		{	
			sccptr->reg[12].reg = 0xAA;
			sccptr->reg[13].reg = 0x55;
		}
	}
	sccvctr = sccs;

	for(i=0; i<num_scc_chan; i++) { /* verify patterns */
		sccptr = *sccvctr++;
		if(sccptr != CONSOLE_PTR)
		{
			if(sccptr->reg[12].reg != 0xAA || sccptr->reg[13].reg != 0x55)
			{
				printf("Register R/W error: SCC port# = 0x%08x  ",sccptr);
			}
			else
				printf("Test passed\n");

		}
	} 
	
	sccvctr = sccs;
	for(i=0; i<num_scc_chan; i++) 	 	/* verify interrupts */
	{
		sccptr = *sccvctr++;
		if(sccptr != CONSOLE_PTR)
		{
		sccintest=1;		/* we are testing the interrupts as well.. */
		er = sccnoint(i);	/* test this one. */
		sccintest=0;		/* no more test mode for scc's.. */
		if(er)	 			/* if an error occured.. */
			sigerr(er, i);	/* go report it. */
		}
	} 
	
	initscc();
}
#endif


#ifdef	REMOVE
sccnoint(num)	/* test an scc, internal loop back. */
int num;
{
	register int i1;
	register struct scc *sccptr;

	if (ACRW_HERE && num > 1) {
		printf ("Unable to test SCC1 on ACRW; not installed.\n");
		return(0);
	}

	progscc(num, 1, 0);	/* general program, int's on, ect. */

	sccptr = sccs[num]; /* serial device control block */

		/* now, program for internal loop back, ect.. */
	sccptr->reg[14].reg = 0x13 ; /* enable local loopback */

		/* then, make sure all garbage bytes are cleared out. */
	i1 = sccptr->reg[8].reg;			/* read a byte. */
	i1 = sccptr->reg[8].reg;			/* read a byte. */
	i1 = sccptr->reg[8].reg;			/* read a byte. */

	scrint = 0;
	sctint = 0;

	sccptr->reg[8].reg =  0xaa ;			/* send a byte..*/
	for(i1 = 0; i1< 20000; i1++)  			/* delay a bit..*/
	{
		if(scrint == 0x01) 			/* if char here..*/
			if(rxdata == 0xaa) 		/* if ok. */
				break;
			else
			{
				printf("SCC Rx data error: SCC port# = 0x%08x Expected = 0xAA Received = 0x%02x\n",sccptr,rxdata);
				return(8);					/* failed, data incorrect. */
			}
	}

	if(i1 == 20000)	
	{
		printf("SCC port# 0x%08x: timeout error\n",sccptr);
		return(9); 				/* failed, no data. */
	}

	scrint = 0;
	sctint = 0;

	sccptr->reg[8].reg =  0x55 ;			/* send a byte..*/
	for(i1 = 0; i1< 20000; i1++)  			/* delay a bit..*/
	{
		if(scrint == 0x01) 					/* if char here..*/
			if(rxdata == 0x55) 	/* if ok. */
				break;
			else
			{
				printf("SCC Rx data error: SCC port# = 0x%08x Expected = 0x55 Received = 0x%02x\n",sccptr,rxdata);
				return(8);					/* failed, data incorrect. */
			}
	}
	if(i1 == 20000)	return(9); 		/* failed no data. */

	wait_cnt(1);

	sctint = scrint = 0;			/* clear old stats. */

	i1 = sccptr->reg[8].reg;		/* read a byte. */

	sccptr->reg[8].reg =  0x55 ;	/* send a single byte..*/

	for(i1 = 0; i1< 60000; i1++)  	/* delay a bit..*/
	{
		if(sctint && scrint) 		/* if both have arrived.. */
			break; /* we have them now.. */
	}

	if(!sctint && !scrint) /* both of them failed.. */
	{
		printf("SCC port# 0x%08x failed to get a Tx and an Rx interrupt\n",sccptr);
		return(37);
	}
	
	if(!sctint)
	{	
		printf("SCC port# 0x%08x failed to get a Tx interrupt\n",sccptr);
		return(36); /* failed transmit int test. */
	}

    if(!scrint)
	{	
		printf("SCC port# 0x%08x failed to get an Rx interrupt\n",sccptr);
		return(35); /* failed transmit int test. */
	}

	return(0);	/* it's ok now. */
}
#endif


/******************************************************************************
 *
 * handle our SCC transmitter interrupts
 *
 ******************************************************************************/
txint(d0,d1,a0,a1,index)
{
	register struct scc *sccptr;

		sccptr = sccs[index];		/* fix up for powerup tests.. */
		sccptr->reg[0].reg = WR0_TXINT; /* reset trans interrupt */
		sccptr->reg[0].reg = WR0_RHIUS; /* reset high int under serv */
		sctint = 1;			/* show was here. */
		return;				/* all done with this.. */
}


/******************************************************************************
 *
 * handle our SCC receiver interrupts
 *
 ******************************************************************************/

extern struct icbcb icbcb;

rxint(d0,d1,a0,a1,index)
{
	register struct scc *sccptr; /* */

		sccptr = sccs[index];		/* give me the chan number. */
		sccptr->reg[0].reg = WR0_RHIUS; /* reset high int under serv */
		scrint = 1;			/* show was here. */
		rxdata = sccptr->reg[0].reg; 	/* read this, if needed. */
		rxdata = sccptr->reg[8].reg; 	/* save the rec data. */
		return;				/* all done with this. */
}


/******************************************************************************
 *
 * handle our SCC external/status interrupts
 *
 ******************************************************************************/

exint(d0,d1,a0,a1,index)
{
	register uchar rr0;
	register struct scc *sccptr;
	register uint	i;
	register uint   dcd_change;
	register uint	max_throw;

	sccptr = sccs[index];			

	if (index != 1) {	/*  Modem port (1) only supported int  */

		printf ("Unexpected interrupt from SCC port %d.\n", index);
		printf("Exint entered RR0 = %x\n",sccptr->reg[0].reg);
		sccptr->reg[0].reg = WR0_EXINT; /* reset ext status interrupt */
		sccptr->reg[0].reg = WR0_RHIUS; /*reset high int under service*/
		return;
	}

	/*  deal with external/status change on modem port  */ 
	
	max_throw = READ_MAX_THROW;
	while (((rr0 = sccptr->reg[0].reg) & RR0_RX) && max_throw--) {
		byte_throw = sccptr->reg[8].reg;
	}

	if ((rr0 & RR0_DCD) && (rr0 & RR0_SYNC)) {
		if (modem_on) {
			dcd_change = 0;
		}
		else {
			dcd_change = 1;
			modem_on = 1;
			NOVRAM->modem_active = 1;
			NOVRAM->shared_crc = nov_chk_sum(2);
			printf ("Modem connection detected.\n");
		}
	}
	else {
		if (!modem_on) {
			dcd_change = 0;
		}
		else {
			dcd_change = 1;
			modem_on = 0;
			NOVRAM->modem_active = 0;
			NOVRAM->shared_crc = nov_chk_sum(2);
			printf ("Modem disconnection detected.\n");
		}
	}

	if (modem_on && !dcd_change && (rr0 & RR0_BREAK)) {
		if (baudtab[++modem_baud_num].bdrate) {
			change_baud (sccptr, modem_baud_num);
		}
		else {
			change_baud (sccptr, (modem_baud_num = 0));
		}

		printf ("Modem detected break, new baud rate %d.\n",
			baudtab[modem_baud_num].bdrate);
	}

	for (i = 0; i != 0x20C00; i++);		/* about 128 msecs  */

	max_throw = BREAK_MAX_THROW;
	while ((sccptr->reg[0].reg & RR0_BREAK) && max_throw--);

#ifdef	DEBUG
	printf ("Broke from loop with max_throw = %d.\n", max_throw);
	if (sccptr->reg[0].reg & RR0_BREAK)
		printf ("Break did not go away.\n");
#endif

	max_throw = READ_MAX_THROW;
	while (((rr0 = sccptr->reg[0].reg) & RR0_RX) && max_throw--) {
		byte_throw = sccptr->reg[8].reg;
	}

	sccptr->reg[0].reg = WR0_EXINT; /* reset ext status interrupt */
	sccptr->reg[0].reg = WR0_RHIUS; /*reset high int under service*/
}


/******************************************************************************
 *
 * handle our SCC special interrupts
 *
 ******************************************************************************/

spint(d0,d1,a0,a1,index)
{
	register struct scc *sccptr;

	sccptr = sccs[index];			

	printf("Spint entered\n");

	byte_throw = sccptr->reg[1].reg;
	sccptr->reg[0].reg = WR0_ERROR; /* reset special interrupt */
	sccptr->reg[0].reg = WR0_RHIUS; /*reset high priority int un_service */
	if(sccintest)	/* if we are testing the interrupts.. */
		scsint = 1;	/* show was here. */
}



#ifdef	REMOVE
sccenoint(tnum, rnum)		/* test an scc, no ints, external loop back. */
int tnum; 					/* transmitting number.. */
int rnum; 					/* receiving number.. */
{
register int i;
register int i1;
register struct scc *scctptr;
register struct scc *sccrptr;

	scctptr = sccs[tnum]; 			/* serial device control block */
	sccrptr = sccs[rnum]; 			/* serial device control block */

		/* now, program for external loop back, ect.. */
	scctptr->reg[1].reg = 0x00;
	scctptr->reg[9].reg = WR9_VIS;	/* Disable master interrupts... */
	scctptr->reg[12].reg = 0x0a;	/* 9600 baud... */
	scctptr->reg[13].reg = 0;	
	scctptr->reg[14].reg = 0x03 ; 	/* enable external loopback, dma/dtr. */

	sccrptr->reg[1].reg = 0x00;	
	sccrptr->reg[9].reg = WR9_VIS;	/* Disable master interrupts... */
	sccrptr->reg[12].reg = 0x0a;	/* better speed this up... */
	sccrptr->reg[13].reg = 0;		/* so use next to fastest baud rate */
	sccrptr->reg[14].reg = 0x03 ; 	/* enable external loopback */

/* then, make sure all garbage bytes are cleared out. */
	for(i = 0; i < 3; i++)
	{
		i1 = scctptr->reg[8].reg;	/* read a byte. */
		i1 = sccrptr->reg[8].reg;	/* read a byte. */
	}

	sccrptr->reg[8].reg =  0xaa;	/* send a byte..*/

	for(i1 = 0; i1< 50000; i1++)  			/* delay a bit..*/
		if(scctptr->reg[0].reg & 0x01) 		/* if char here..*/
			if(scctptr->reg[8].reg == 0xaa) /* if ok. */
				break;
			else
			{
				printf("Input data error SCC address = 0x%08x\n",scctptr);
				printf("tx_reg_0 = %x rx_reg_0 = %x\n",scctptr->reg[0].reg,sccrptr->reg[0].reg);
				return(41);	/* failed, data incorrect. */
			}

		if(i1 == 50000)				 /* failed, no data. */
		{
			printf("SCC Tx = 0x%08x SCC Rx = 0x%08x Timeout  No character received\n",scctptr,sccrptr);
			return(43);
		}

	scctptr->reg[8].reg =  0x55 ;			/* send a byte..*/
	for(i1 = 0; i1< 20000; i1++)  			/* delay a bit..*/
	{
		if(sccrptr->reg[0].reg & 0x01) 		/* if char here..*/
			if(sccrptr->reg[8].reg == 0x55) /* if ok. */
				break;
			else
			{
			printf("SCC_Tx = 0x%08x SCC_Rx = 0x%08x Data error: Expected 0x55, Received 0x%02x\n",scctptr,sccrptr,sccrptr->reg[8].reg);
			return(43);
			}
	}

	if(i1 == 20000)	
	{
		printf("SCC_Rx = 0x%08x Timeout error:\n",sccrptr);
		return(43); /* failed no data. */
	}

	return(0);	/* it's ok now. */
}
#endif


#ifdef	REMOVE
sigerr(arg1,arg2)
int arg1;
int arg2;
{

	printf("sig_err: %x %x\n",arg1,arg2);

}
#endif


int
change_baud (sccptr, baud_num)
register struct scc *sccptr;
uint	 baud_num;
{

	switch ((int)sccptr) {
		case SCC0A:		/*  console port  */
			NOVRAM->console_baud_rate = baudtab[baud_num].bdrate;
			NOVRAM->shared_crc = nov_chk_sum(2);
			break;
		case SCC0B:		/*  modem   port  */
			NOVRAM->modem_baud_rate = baudtab[baud_num].bdrate;
			NOVRAM->shared_crc = nov_chk_sum(2);
			break;
		case SCC1A:		/*  printer port  */
			NOVRAM->printer_baud_rate = baudtab[baud_num].bdrate;
			NOVRAM->shared_crc = nov_chk_sum(2);
			break;
		case SCC1B:		/*  ups     port  */
			NOVRAM->ups_baud_rate = baudtab[baud_num].bdrate;
			NOVRAM->shared_crc = nov_chk_sum(2);
			break;
		default:
			printf ("Unknown SCC port address.\n");
			return(1);
	}

	/*  disable the baud rate generator  */
	sccptr -> reg[14].reg = WR14_PCLK;

	/*  setup the new baud rate  */
	sccptr -> reg[12].reg = baudtab[baud_num].bdlsb;
	sccptr -> reg[13].reg = baudtab[baud_num].bdmsb;

	/*  enable the baud rate generator  */
	sccptr -> reg[14].reg = WR14_PCLK | WR14_ENABD;

	return(0);
}



