
/*------------------------------------------------------------------------------
				rwicio.c
------------------------------------------------------------------------------*/
#include "types.h"
#include "spm.h"
#include "rwi.h"
#include "rwicio.h"
#include "novram.h"
#include "rtc.h"

static uchar prev_data0;
static uchar prev_data1;

extern struct cio *cur_cioptr;

extern uchar PortInt;
extern int timer_num; 
extern int timer_ints; /* To define who got the interrupt. */
extern int rwi_test;

extern  struct novram *novram;
extern  char *gets();

/*------------------------------------------------------------------------------
	This module initializes the CIO chips on the real world
	interface.
------------------------------------------------------------------------------*/
rwi_cio_init()
{
	struct cio *cioptr;		/* CIO port address to init */

	cioptr = CIO_0;			/* INIT CIO.0 */

	cioptr->mic = C_RESET | C_RJUST;
	cioptr->mic = 0;			/* unreset the chip. */
	cioptr->mic = C_RJUST;			/* ct vect includes status */
	cioptr->mcc = C_DISALL;			/* disable all */

	/* *  init CIO_0 port A */
	cioptr->cioport[0].pmode = P_BIT | P_OPEVM;	/* bit port */
	cioptr->cioport[0].dpdir = 0xff;		/* port A input. */
	cioptr->cioport[0].dppolar = 0x80;	/* data path polarity. */
	cioptr->pivect[0].reg = PPORTAVEC0;	/* Define the vector to use. */
	cioptr->cioport[0].patpolar = 0x00;	/* any transition. */
	cioptr->cioport[0].pattrans = 0xff;	/* any transition. */
	cioptr->cioport[0].patmask = 0x00;	/* any transition. */
	cioptr->cioport[0].spcntrl = 0x00;	/* turn off one's catcher.. */
	prev_data0 = cioptr->portdata[PORTA].reg;	/* init's value.. */

	/* 
	 * init CIO_0 port B
	 */
	cioptr->cioport[1].pmode = P_BIT | P_ORMD;	/*bit port*/
	cioptr->cioport[1].dpdir = 0x00;		/* port B output */
	cioptr->cioport[1].dppolar = 0xff;	/* data path polarity */
	cioptr->portdata[PORTB].reg = 0x00;	/* initl data for port B */
	cioptr->pivect[1].reg = PPORTBVEC;
	cioptr->cioport[1].patpolar = 0x00;	/* any transition */
	cioptr->cioport[1].pattrans = 0x00;	/* any transition */
	cioptr->cioport[1].patmask = 0x00;	/* any transition */

	/* 
	 * init CIO_0 port C
	 */
	cioptr->pcdd = 0x0f;		/* port C input */
	cioptr->pcdpp = 0x0f;		/* port C data path polarity */
	cioptr->pcsc = 0x0;		/* port C special control normal */

	/* 
	 * enable ports A & B & C
	 */
	cioptr->mcc = C_PAE | C_PBE | C_PCCT3E; 
	cioptr->mic = 0; 			/* master interrupt enable */
	cioptr->mic = C_MIE | C_RJUST; 		/* master interrupt enable */
	cioptr->portcs[0].reg = ICW_SIE; 	/* enable interrupts */

#ifdef DEBUG
printf("1.) RWI_CIO_INIT: key=%x cmd=%x\n", novram->keywas,novram->cmdwas);
#endif

	if((novram->keywas = key()) == KEY_ON)	/* If key is in 'ON' position */
		novram->cmdwas = 0;		/* Make the system turn on. */
	else 
		novram->cmdwas = -1;		/* Set this to 'DON'T CARE'. */
	novram->keywas = -1;		/* And now; force key switch change.. */

#ifdef DEBUG
printf("2.) RWI_CIO_INIT: key=%x cmd=%x\n", novram->keywas,novram->cmdwas);
#endif

	cioptr = CIO_1;				/* INIT OF CIO.1 */
	cioptr->mic = C_RESET | C_RJUST;
	cioptr->mic = 0;			/* unreset the chip. */
	cioptr->mic = C_RJUST; 			/* ct vect includes status */
	cioptr->mcc = C_DISALL; 		/* disable all */

	/* init CIO_1 port A */
	cioptr->cioport[0].pmode = P_BIT | P_ORMD; 	/* bit port */
	cioptr->cioport[0].dpdir = 0xff;		/* port A input. */
	cioptr->cioport[0].dppolar = 0x00;		/* data path polarity */
	cioptr->pivect[0].reg = PPORTAVEC1;
	cioptr->cioport[0].patpolar = 0x00;		/* any transition */
	cioptr->cioport[0].pattrans = 0x00;		/* any transition */
	cioptr->cioport[0].patmask = 0x00;		/* any transition */
	prev_data1 = cioptr->portdata[PORTA].reg;	/* init's value.. */

	/* 
	 * init CIO_1 port B
	 */
	cioptr->cioport[1].pmode = P_BIT | P_ORMD; 	/*bit port*/
	cioptr->cioport[1].dpdir = 0x00;		/* port B output */
	cioptr->cioport[1].dppolar = 0xff;		/* data path polarity */
	cioptr->portdata[PORTB].reg = 0x00;		/* initial data for port B*/
	cioptr->pivect[1].reg = PPORTBVEC;
	cioptr->cioport[1].patpolar = 0x00;		/* any transition */
	cioptr->cioport[1].pattrans = 0x00;		/* any transition */
	cioptr->cioport[1].patmask = 0x00;		/* any transition */

	/* 
	 * init CIO_1 port C 
	 */
	cioptr->pcdd = 0x00;			/* port C output */
	cioptr->pcdpp = 0x0f;			/* port C data path polarity */
	cioptr->pcsc = 0x0;			/* port C spec control normal */
	cioptr->portdata[PORTC].reg = 0x00;	/* initial data for port C */
	cioptr->mcc = C_PAE | C_PBE | C_PCCT3E; /* enable ports A & B & C */
	cioptr->portcs[0].reg = ICW_SIE; 	/* enable interrupts */
	cioptr->portcs[1].reg = ICW_SIE; 	/* enable interrupts */
	cioptr->mic = C_MIE | C_RJUST; 		/* master interrupt enable */
}

/******************************************************************************
 *
 * handle our CIO 0 port A bit interrupts
 *
 ****************************************************************************/
pportaint0(d0,d1,a0,a1,index)
{
	register struct cio *cioptr;
	register char curr_data;
	register uchar transition;
	register uchar	key_moved = 0;

	if(rwi_test == 0)		/* Are we doing diagnostics? */
	{
		cioptr = CIO_0;
		curr_data = cioptr->portdata[PORTA].reg; 
		transition = curr_data ^ prev_data0;

		switch(transition) {		/* check cause of interrupt */ 
			case PS_0_PF:
				printf("PS_0_PF Interrupt\n");
				break;
			case PS_1_PF:
				printf("PS_1_PF Interrupt\n");
				break;
			case PS_2_PF:
				printf("PS_2_PF Interrupt\n");
				break;
			case PS_3_PF:
				printf("PS_3_PF Interrupt\n");
				break;
			case PS_4_PF:
				printf("PS_4_PF Interrupt\n");
				break;
			case UPS_AC_FAIL:
				printf("UPS_AC_FAIL Interrupt\n");
				break;
			case UPS_LOW_BATTERY:
				printf("UPS_LOW_BATTERY Interrupt\n");
				break;
			case OFF_SW_COPY:
				key_moved = 1;
				break;
		}
	}
	else
		cioptr = cur_cioptr;	/* yes we are taking the current cio */

	PortInt = 'A';			/* Mark the int as from port A */
	cioptr->portcs[0].reg = ICW_CPUS;  /* clear int pend & int under serv */  
	cioptr->portcs[0].reg = ICW_CIUS;	/* reenable interrupts */
	prev_data0 = curr_data;
	
	if (key_moved)
 		check_power();	/* always check this.. */

}

/******************************************************************************
 *
 * handle our CIO 1 port A bit interrupts
 *
 ****************************************************************************/
pportaint1(d0,d1,a0,a1,index)
{
	register struct cio *cioptr;
	uchar curr_data;
	uchar transition;

	if(rwi_test == 0)		/* Are we doing diagnostics? */
	{
		cioptr = CIO_1;
		curr_data = cioptr->portdata[PORTA].reg; 
		transition = curr_data ^ prev_data1;

		switch(transition) {		/* check cause of interrupt */ 
			case FANALARM:
				if(novram->fan_stat & ENABLE_FAN_ALRM){
	 			  printf("Fan alarm interrupt detected\n");
			 	  break;
				}
		}
	}
	else
		cioptr = cur_cioptr;	/* yes we are taking the current cio */

	PortInt = 'A';			/* Mark the int as from port A */
	cioptr->portcs[0].reg = ICW_CPUS;  /* clear int pend & int under serv */  
	cioptr->portcs[0].reg = ICW_CIUS;	/* reenable interrupts */
	prev_data1 = curr_data;
}

/******************************************************************************
 *
 * handle our CIO port B bit interrupts
 *
 ******************************************************************************/
pportbint(d0,d1,a0,a1,index)
{
	register struct cio *cioptr;

	if(rwi_test == 0)	
		cioptr = CIO_0;
	else
		cioptr = cur_cioptr;

	PortInt = 'B';
	cioptr->portcs[1].reg = ICW_CPUS;	/* clear int pending & int under serv */
	cioptr->portcs[1].reg = ICW_CIUS;	/* reenable interrupts */
}

/*------------------------------------------------------------------------------
		interrupt service routine for our counter timers 
------------------------------------------------------------------------------*/
ctint()
{
	register struct cio *cio_ptr = cur_cioptr;

	timer_ints++;
	cio_ptr->ctcs[timer_num].reg = ICW_CPUS | CT_GCB; 
	cio_ptr->ctcs[timer_num].reg = ICW_SIE; 
}

/*------------------------------------------------------------------------------
		Interrupt enable, pending and service cleared.
------------------------------------------------------------------------------*/
ctinten()
{
	struct cio *cioptr = CIO_0;

	cioptr->portcs[0].reg = ICW_CPUS;  /* Clear int pend & int under serv */
	cioptr->portcs[0].reg = ICW_CIUS;	/* Clear Int under service. */
	cioptr->mic = C_MIE | C_RJUST;		/* Master interrupt enable */
}

/*----------------------------------------------------------------------------*/

check_power()
{
	
	if (key() == KEY_ON)
		do_on_pwr();

	if (key() == KEY_OFF)
		do_off_pwr();
		
	printf ("Unknown key position, or pwron/pwroff failed.\n");
}
		

/*------------------------------------------------------------------------------

	BIG TIME KLUDGE:  We have found that in some cases the RWI CIO will
			  lose its initialization, such as when pwron is
			  tried the message below is displayed even with the
			  key in the 'ON' position.  So rather than print
			  the message, try init the first time, then print
			  the second time.

	menu poweron comes to this routine.

------------------------------------------------------------------------------*/
do_on_pwr() 				/* turn on the power for sub routine. */
{
	
	if (powmain())		/* is power already on??? */
		return(1);

	if(key() == KEY_OFF) /* If key is 'OFF'. */
		rwi_cio_init(); /* initialize the cio chip */

	if(key() == KEY_ON) {	/* If key is 'ON'. */
		pwr_on();
		return(1);
	}
	else {
		printf("\nThe Key must be in the (ON) position to POWER ON.\n");
		return(0);
	}
}

/*------------------------------------------------------------------------------
	menu poweroff comes here
------------------------------------------------------------------------------*/
do_off_pwr() 				/* Turn off the power for sub routine */
{
	if (!powmain())		/* Is power on??? */
		return(1);

	pwr_off();			/* actually do the command. */
	return(0);		/* Doesn't come back, but lint is happy */
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
key()
{ 
	struct cio *cioptr = CIO_0;

	if(cioptr->portdata[PORTC].reg & ON_SW)
		return(KEY_ON);
	else
		return(KEY_OFF);
}

/*------------------------------------------------------------------------------
	pwr_on : This routine should decide if Overtemp and Spindown is 
			 active and sequentially powerup the system(s).
------------------------------------------------------------------------------*/
pwr_on()
{
	uint	cab, cnt;
	uchar	number_cabs;
	uchar	quit = 0;
	struct	cio *cioptr = CIO_0;
	uchar	periph_on = 0x01; 	/* start with SSR_0_ON */

#ifdef DEBUG
printf("1.) PWR_ON:keywas=%x cmdwas=%x\n",novram->keywas,novram->cmdwas);
#endif

/*
**	if the flag indicates checking power-up, and we are not using
**	an acrw (no adc), then check over temp
*/

	if (check_ups())
		return(1);

	if(overtmp()) {  /* If still in overtemp mode.. */
		printf("\n******>> OVERTEMP HAS BEEN DETECTED. <<******\n\007");
		printf("\n******>> ABORTING POWER-UP SEQUENCE. <<******\007\n");
		return(1); 			/* Return to monitor.  */
	}

	*WRCNTL1 = (unsigned)0x0;		/* Reset the bus. */
	cioptr->mic = C_RJUST;			/* Master interrupt disable. */

	if (ACRW_HERE) {
		number_cabs = 2;
	}
	else
		number_cabs = CAB_PER_SYS;

	for(cab = 0; cab != number_cabs; cab++) { /* All cabinets */

		if (key_off()) {
			quit = 1;
			break;
		}

		if(cab == 1) {
		cioptr->portcs[0].reg = ICW_CPUS;	/* Clear Int pending. */
		cioptr->portcs[0].reg = ICW_CIUS; /* Clear Int under service. */
		cioptr->mic = C_MIE | C_RJUST;	  /* Master interrupt enable */
		}

		cioptr->portdata[PORTB].reg |= periph_on; /* Turn on cabinet. */
		periph_on <<= 1;	/* Get ready for the next cabinet. */
		periph_on |= 0x01;	/* Keep the ones we have already done */
	}

	cioptr->portcs[0].reg = ICW_CPUS;	/* Clear Int pending.. */
	cioptr->portcs[0].reg = ICW_CIUS;	/* Clear Int under service. */
	cioptr->mic = C_MIE | C_RJUST;		/* Master interrupt enable */

	if(quit) { 
		pwr_off(); 
		return(1); 
	}

	for(cnt = 4000; --cnt ; )	/* while power is still bad.. */
		if (powmain ())
			break;

	if(!cnt) {
		printf("pwr_on:  Main power +5 volts failed.\n");
		pwr_off();		/* Ok, do this, should not return. */
		return(1);		/* skip it now; sigh. */
	}

	POWR_LED_ON;				/* Turn on the power_on led. */
	WARN_LED_OFF;
	
	NOVRAM->newpwr = 1; /* show css bus powered up, reset in pollcss.c */
	CloSwi_css();			/* go to CSS clock */
	return(0);		/* Doesn't come back, but lint is happy */
}

/*------------------------------------------------------------------------------
	pwr_off: This routine should decide it is time to power the
			 system off.
------------------------------------------------------------------------------*/
pwr_off()
{
	struct cio *cioptr = CIO_0;

#ifdef DEBUG
printf("1.) PWR_OFF: keywas=%x cmdwas=%x\n",novram->keywas,novram->cmdwas);
#endif

	printf("\nSwitching to the local clock for power off\n");
	cioptr->mic = C_RJUST;		/* Disable master interrupts. */
	cioptr->portdata[PORTB].reg = 0x00;	/* Kill the power. */

	POWR_LED_OFF;			/* Turn off power_on light. */
	WARN_LED_ON;

	wait_cnt(200);

	cioptr->portcs[0].reg = ICW_CPUS; /* Clear Int pending. */
	cioptr->portcs[0].reg = ICW_CIUS; /* Clear Int under service. */
	cioptr->mic = C_MIE | C_RJUST;	  /* Master interrupt enable */

	wait_cnt(1);

	*WRCNTL0 = (unsigned)0;		/*  Make sure these are reset  */
	*WRCNTL1 = (unsigned)0;
	CloSwi_loc();

}

int
check_ups()
{
	struct	cio *cioptr = CIO_0;
	uint	ups_pass = 0;
	char	passwd[16];

	if (cioptr->portdata[PORTA].reg & (unsigned)UPS_AC_FAIL) {
		printf ("UPS_AC_FAIL set, should not power up\n");
		printf ("To override enter password <CR>, ESC to quit\n");
		while (!ups_pass) {
			if (gets (passwd, 15) == (char *)-1)
				return(1);

			if (strcmp (passwd, "ups_ignore") != 0)
				printf ("Entered password:  %s, not correct\n",
				passwd);
			else
				ups_pass = 1;
		}
	}
	return(0);
}

key_off()
{
	uint	cnt;

	for(cnt = 0; cnt != 35000 ; cnt++) {	
		if(key() == KEY_OFF) {
			return(1);
		}
	}
	return(0);
}

pwr_should_be_off()
{
	
	uint	outer;
	uint	inner;

	printf ("\nMain power ACTIVE, LOCAL clock ACTIVE.\n");
	printf ("Power should NOT be ACTIVE -- perform poweroff  \n");
	printf ("\nPress anykey to stop poweroff.");
	
	for(outer = 0; outer < 1100; outer++) {	/* LONG time....5 seconds */
		for(inner = 0; inner < 160; inner++)
			if(con_in() != -1) { /* someone pressed something..  */
				printf("\r                                  ");
				return(0);	/* leave power alone */
			}
	}
	pwr_off();
	return(1);
}

