
/*------------------------------------------------------------------------------
	rwitest.c
------------------------------------------------------------------------------*/

#include "types.h"
#include "spm.h"
#include "rwi.h"
#include "rwicio.h"
#include "novram.h"
#include "rtc.h"
#include "global.h"

#define	DELAY	1000

#define	MARGIN_HIGH	1
#define MARGIN_LOW	2
#define	MARGIN_NORM	3

#define	RELAY_ON	1
#define	RELAY_OFF	2

#define	MS_LIMIT	10000

static struct cio *cio_0_ptr = CIO_0;
static struct cio *cio_1_ptr = CIO_1;

extern int rwi_test;
extern struct cio *cur_cioptr;
extern uchar PortInt;
extern int timer_num; 
extern int timer_ints;		/* To define who got the interrupt. */

extern char *gets ();

#ifdef	REMOVE
timer_tst(cioptr,timer) 
register struct cio *cioptr;
int timer;
{
	int k; 
	int errs=0;
	/* 
		Save these for the ISR 
	 */
	cur_cioptr = cioptr;
	timer_num = timer;
	timer_ints=0;

	cioptr->ctmode[timer].reg = 0;		  /* do not re-enable  */
	cioptr->cttc[timer].tcmsb = RTC_TC >> 8;  /* MSB of time constant */
	cioptr->cttc[timer].tclsb = RTC_TC; 	  /* LSB of time constant */
	cioptr->ctivect = CTVECT;		/* Counter timer int vector. */

	if(timer == 0) /* enable the proper counter/timer as input */
		cioptr->mcc = C_CT1E;	/* counter timer 1 enable */
	else if(timer == 1)
		cioptr->mcc = C_CT2E;	/* counter timer 2 enable */
	else if(timer == 2)
		cioptr->mcc = C_PCCT3E;	/* counter timer 3 enable */

	/* ct vect includes status, master interrupt enable */
	cioptr->mic = C_MIE | C_RJUST;

	 /* Gate, interrupt enable and trigger */
	cioptr->ctcs[timer].reg = ICW_SIE | CT_TCB | CT_GCB; 

	k = 0;
	while(k < TIME_OUT && timer_ints == 0) k++;
	if(k >= TIME_OUT) {
		printf("Timer %d at CIO address 0x%08x timed out\n",
					timer,cioptr);
		errs++;
	} 
	else {
#ifdef DEBUG
		printf("Timer %d at CIO address 0x%08x good \n",timer,cioptr);
#endif
	}
	cioptr->mcc = C_PAE | C_PBE | C_PCCT3E; /* enable ports A & B & C */
	cioptr->mic = C_MIE | C_RJUST; 		/* master interrupt enable */
	return(errs);				/* send it back; 0 for no err */
}
#endif

#ifdef	REMOVE
/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
test_rwi_cio(cioptr)
register struct cio *cioptr;
{
	register k, i, errs=0;			/* variables.. */
	cur_cioptr = cioptr;			/* save it for the ISR */

	/*
	 * Program master interrupt register reset
	 */
	cioptr->mic = C_RJUST;		/* shutoff MIE so we get good vectors */
	if (cioptr == (struct cio *)CIO_0)
		cioptr->pivect[0].reg = PPORTAVEC0;	/* cio 0 port A. */
	else
		cioptr->pivect[0].reg = PPORTAVEC1;	/* cio 1 port A. */
	cioptr->pivect[1].reg = PPORTBVEC;	/* make this vector port B. */

	/* now read them back to make sure you could program them. */
	if (cioptr == (struct cio *)CIO_0) {
		if(cioptr->pivect[0].reg != PPORTAVEC0) {	
			printf("PPORTAVEC reg R/W error. CIO port# = 0x%08x\n",
					cur_cioptr);
			printf("Expected %x Received %x\n",
				PPORTAVEC0,cioptr->pivect[0].reg);
			errs++;			/* Indicate a failure.... */
		} 
		else {
#ifdef DEBUG
			printf("PORTAVECT register good. CIO port# = 0x%08x\n",
					cur_cioptr);
			printf("Expected %x Received %x\n",
					PPORTAVEC0,cioptr->pivect[0].reg);
#endif
		}
	}
	else {
		if(cioptr->pivect[0].reg != PPORTAVEC1) {	
			printf("PPORTAVEC reg R/W error. CIO port# = 0x%08x\n",
					cur_cioptr);
			printf("Expected %x Received %x\n",
				PPORTAVEC1,cioptr->pivect[0].reg);
			errs++;			/* Indicate a failure.... */
		} 
		else {
#ifdef DEBUG
			printf("PORTAVECT register good. CIO port# = 0x%08x\n",
					cur_cioptr);
			printf("Expected %x Received %x\n",
					PPORTAVEC1,cioptr->pivect[0].reg);
#endif
		}
	}

	if(cioptr->pivect[1].reg != PPORTBVEC)
	{
		printf("PORTBVECT register R/W error. CIO port# = 0x%08x\n",
				cur_cioptr);
		printf("Expected %x Received %x\n",
				PPORTBVEC,cioptr->pivect[1].reg);
		errs++;			/* Indicate a failure.. */
	} else {
#ifdef DEBUG
		printf("PORTBVECT register good. CIO port# = 0x%08x\n",
				cur_cioptr);
		printf("Expected %x Received %x\n",
				PPORTBVEC,cioptr->pivect[1].reg);
#endif
	}

	cioptr->mcc = C_PAE | C_PBE;	/* enable interrupts on ports A & B */
	cioptr->mic = C_MIE | C_RJUST; 		/* master interrupt enable */
	cioptr->portcs[0].reg = ICW_SIE;	/* enable interrupts */
	cioptr->portcs[1].reg = ICW_SIE;	/* enable interrupts */
	for(i=0; i<2; i++) {			/* test ints on both ports */
		PortInt = 0;
		cioptr->portcs[i].reg = ICW_SIP;	/* force interrupt */ 
		for(k = 0; (k < DELAY) && (PortInt != ('A' + i)); k++);
		if(k >= DELAY) {
			printf("CIO missing interrupt: CIO port# = 0x%08x ",
					cur_cioptr);
			printf("Portint = %x\n",PortInt);
			printf("Test failed.\n");
			errs++;				/* say bad.. */
		}
		else
			printf("\rPort %c CIO port# = 0x%08x PASSED.",
					PortInt,cur_cioptr);
	}
	printf("\n");
	cioptr->mcc = C_PAE | C_PBE | C_PCCT3E;	/* enable ports A & B & C */
	cioptr->mic = C_MIE | C_RJUST;		/* master interrupt enable */
	return(errs);			/* show good, bad, indifferent. */
}
#endif

cio_in()
{
	uchar temp_data_0_A;
	uchar temp_data_0_B;
	uchar temp_data_0_C;
	uchar temp_data_1_A;
	uchar temp_data_1_B;
	uchar temp_data_1_C;

	temp_data_0_A = cio_0_ptr->portdata[PORTA].reg;
	temp_data_0_B = cio_0_ptr->portdata[PORTB].reg;
	temp_data_0_C = cio_0_ptr->portdata[PORTC].reg;
	temp_data_1_A = cio_1_ptr->portdata[PORTA].reg;
	temp_data_1_B = cio_1_ptr->portdata[PORTB].reg;
	temp_data_1_C = cio_1_ptr->portdata[PORTC].reg;

	temp_data_0_C &= 0x03;
	if (ACRW_HERE) {
		temp_data_0_A &= 0xEF;
		temp_data_0_B &= 0x83;
		temp_data_1_A &= 0x07;
		temp_data_1_B &= 0x21;
		temp_data_1_C &= 0x0C;
	}
	else
		temp_data_1_C &= 0x0F;

		/* now display the data */
	printf("CIO 0 port A  = %02x\n",temp_data_0_A);
	printf("CIO 0 port B  = %02x\n",temp_data_0_B);
	printf("CIO 0 port C  = %1x\n\n",(temp_data_0_C & 0x0F));
	printf("CIO 1 port A  = %02x\n",temp_data_1_A);
	printf("CIO 1 port B  = %02x\n",temp_data_1_B);
	printf("CIO 1 port C  = %1x\n",(temp_data_1_C & 0x0F));
}


