
#include "types.h"
#include "iom.h"
#include "spm.h"
#include "misc.h"
#include "sa_dir.h"
#include "filehdr.h"
#include "scnhdr.h"
#include "aouthdr.h"
#include "a.out.h"
#include "iopm_comm.h"
#include "boot.h"

struct fhdr {
	FILHDR filhdr;
	AOUTHDR saouthdr;
	SCNHDR sctnhdr[6];
};

extern uchar	myslot;
extern uint	int_data;

/* 
	load_icb_run(): Called by Trap1.
	This routine loads codes residing in system memory (address 0) into
	local static ram on the service module and passes control to it
	Called by mov_code.s
*/
load_icb_run()
{
	register i;
	register uint *dest, *src, start, *startp, tmp;
	register struct fhdr *fhptr;
	register struct scnhdr *scnptr;

	fhptr = (struct fhdr *)ICB_RD_ADDR;
		
	scnptr=fhptr->sctnhdr;
	startp = (unsigned *)(scnptr->s_paddr + 0x4); /* start address ptr */
	for(i=0; i<fhptr->filhdr.f_nscns; i++,scnptr++) {
		dest = (unsigned *)scnptr->s_paddr; 	/* dest addr */
		src = (unsigned *)(scnptr->s_scnptr + (unsigned)fhptr); 
		for(tmp=0; tmp<scnptr->s_size; tmp+=4,src++,dest++) 
			*dest = *src; 		/* move it into local ram */
	}
	start = *startp;		/* get the beginning address */
	_cache(0);			/* disable 68020 on-chip cache */
	(*(PFI)start)(); 		/* Pass control to loaded codes */
}

/* 
	load_iopm_run(): Called by Trap2.
	This routine loads codes residing in system memory (address 0) into
	local static ram on the service module and passes control to it
	Called by mov_iopm_code in mv_iopm_cd.s
*/
load_iopm_run()
{
	register i;
	register uint *dest, *src, start, *startp, tmp;
	register struct fhdr *fhptr;
	register struct scnhdr *scnptr;

	fhptr=(struct fhdr *)IOPM_RD_ADDR;
		
	scnptr=fhptr->sctnhdr;
	startp = (uint *)(scnptr->s_paddr + 0x4); /* start address ptr */
	for(i=0; i<fhptr->filhdr.f_nscns; i++,scnptr++) {
		dest = (uint *)scnptr->s_paddr; 	/* dest addr */
		src = (uint *)(scnptr->s_scnptr + (uint)fhptr); 
		for(tmp=0; tmp<scnptr->s_size; tmp+=4,src++,dest++) 
			*dest = *src; 		/* move it into local ram */
	}
	start = *startp;		/* get the beginning address */
	_cache(0);			/* disable 68020 on-chip cache */
	(*(PFI)start)(); 		/* Pass control to loaded codes */
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
iom_int_tbl_init(iom_slot,data)
char 	iom_slot;
uint data;
{
	register uint 	*tp;
	register uint	*start;
	register uint   *end;
	register uint   offset;
	uchar		addr;

	offset = IOM_INT_V;	/* addr of IO module interrupt vector */
	start = (uint *)CSSMAP(offset);
	end   = (uint *)(CSSMAP(offset) + INT_SIZE);
	addr  = (uchar)CSSADD(offset);
	cssmap(MAP00,iom_slot,addr);

	/* initial IOM interrupt vector table */
	for (tp = start; tp < end ; ) {
		data = data & 0xffff0000;
		data = data | ((uint)myslot << 8);
		data = data | ((uint)myslot << 12);
		data = data & 0xff00ffff; /* set level 5 interrupt */
		data = data | 0x00800000; /* set direct int bit */
		*tp = data;
		tp++; tp++;
	}
	offset = IOS_INT_V;	/* addr of IO device interrupt vector */
	start = (uint *)CSSMAP(offset);
	end   = (uint *)(CSSMAP(offset) + INT_SIZE);
	addr  = (uchar)CSSADD(offset);
	cssmap(MAP00,iom_slot,addr);

	/* initial IO device interrupt vector table */
	for (tp = start; tp < end ; ) {
		data = data & 0xffff0000;
		data = data | ((uint)myslot << 8);
		data = data | ((uint)myslot << 12);
		data = data & 0xff00ffff; /* set level 5 interrupt */
		data = data | 0x00800000; /* set direct int bit */
		*tp = data;
		tp++; tp++;
	}
}


load_ram()
{
/* was used by spm diag */
}
