
/*------------------------------------------------------------------------------
	novtst.c
------------------------------------------------------------------------------*/
#include "types.h"
#include "spm.h"
#include "novram.h"
#include "global.h"

extern ushort crctab[];
extern uchar *buff;
extern char comm_args[][MAXARGSIZE];
extern struct novram *novram;			/* Points to Base of NVRAM. */

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
nov_cpy(st, de)	/* copy out the novram into the buffer space. */
register uchar *st, *de; /* start and dest. */
{
	register uchar *st1, *de1;	/* pointer to orignal. */
	register i1,i2;			/* counter. */

	i2 = sizeof(struct novram);	/* Get size of the whole structure. */
	st1 = st;			/* save starting values. */
	de1 = de;
	for(i1 = 0; i1 < i2; i1++)	/* entire structure. */
		*de++ = *st++;								/* move across one byte. */
	if(chk_sum(st1, i2) != chk_sum(de1, i2))	/* if don't match. */
	{
		printf("Warning: destination checksum did not match CRC checksum.\n");
		return(1);									/* bad.. */
	}
	return(0);										/* passed copy.. */
}


/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
pwr_nov_tst()	/* test the novram for read/write. */
{

	if(nov_cpy(NOVRAM, buff))		/* if it failed.. */
		return;			/* it failed copy for some reason. */

	nov_tst_ram();		/* test the actual ram. */

	nov_cpy(buff, NOVRAM);	/*put it back now, don't care about errors... */
}


/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
nov_tst(comm_str, arg_cnt)	/* test the novram for read/write. */
char *comm_str;
int arg_cnt;
{
	register uchar *st = (uchar *)NOVRAM; /* original. */
	register uchar *de = (uchar *)buff; /* tmp buffer. */
	int i=0;

/* first: save all novram contents. */
	if(nov_cpy(st, de))		/* if it failed.. */
		return;			/* it failed copy for some reason. */
	if(*comm_str == 'l')	/* if told to loop. */
	{
		printf("Press ESC to exit loop\n");
		while(1)								/* looping */
		{
			nov_tst_ram();	/* test the actual ram. */
			if(ifesc()) 
				break;	/* escape loop. */
			if(i++ == 100)
			{
				printf(".");
				i = 0;
			}
		}
		printf("\n");
	}
	else
		nov_tst_ram();		/* test the actual ram. */
	nov_cpy(de, st);	/*put it back now, don't care about errors... */
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
nov_tst_ram()	/* do the actual novram test.. */
{ /* tst stolen from dram test.. thanks ron! */
	register uint *addr = (uint *)NOVRAM;
	register uint offadd;
	register uint tstpat,readback;
	register uint pat1=0x00000000;
	register uint pat2=0x55555555;
	register uint pat3=0xaaaaaaaa;
	char *msg;

	msg = "Nvram data ripple test failed.";
	/* ripple a one bit in first location */
	for(tstpat=0x00000001; tstpat != 0; tstpat = tstpat << 1) {
		*addr = tstpat;	/* ok, write test pattern. */
		readback = *addr; /* read it back now. */
		if(readback != tstpat) {
			print_err(msg,(uint)addr,tstpat,readback);
			return(1);
		}
	}
	/* ripple a zero bit through first location */
	for(tstpat=0xfffffffe; tstpat != (uint)0xffffffff; 
					tstpat=(tstpat<<1)| 0x00000001) {
		*addr = tstpat;
		readback = *addr;
		if(readback != tstpat) {
			print_err(msg,(uint)addr,tstpat,readback);
			return(1);
		}
	}

	msg = "Nvram address ripple test failed.";
	for(offadd=0x00000400; offadd >= 0x00000004 ; offadd = offadd >> 1) {
		/* initilize first pattern. */
		addr = (unsigned *)((uint)NOVRAM + (uint)offadd);
		*addr = pat1;
	}
	for(offadd=0x00000400; offadd >= 0x00000004 ; offadd = offadd >> 1) {
		addr = (unsigned *)((uint)NOVRAM + (uint)offadd);
		readback = *addr; /* verify. */
		if(readback != pat1) {
			print_err(msg,addr,pat1,readback);
			return(1);
		}
		*addr = pat2;	/* init as second pattern. */
		readback = *addr; /* verify. */
		if(readback != pat2) {
			print_err(msg,addr,pat2,readback);
			return(1);
		}
		*addr = pat3; /* init as third pattern. */
		readback = *addr; /* verify. */
		if(readback != pat3) {
			print_err(msg,addr,pat3,readback);
			return(1);
		}
	}

	msg = "Nvram content test failed.";
	for(addr=(unsigned *)NOVRAM; 
		addr < (unsigned *)((uint)NOVRAM + (uint)0x7f8) ; addr++)
		*addr = pat1;	/* init to all pat1. */
	for(addr=(unsigned *)NOVRAM; 
		addr < (unsigned *)((uint)NOVRAM + (uint)0x7f8) ; addr++)
	{  /* verify first pattern, and init to second. */
		readback = *addr;
		if(readback != pat1) {
			print_err(msg,addr,pat1,readback);
			return(1);
		}
		*addr = pat2;
		readback = *addr;
		if(readback != pat2) {
			print_err(msg,addr,pat2,readback);
			return(1);
		}
	}
	for(addr=(unsigned *)NOVRAM; 
		addr < (unsigned *)((uint)NOVRAM + (uint)0x7f8) ; addr++)
	{ /* verify second pattern, and init to third. */
		readback = *addr;
		if(readback != pat2) {
			print_err(msg,addr,pat2,readback);
			return(1);
		}
		*addr = pat3;
		readback = *addr;
		if(readback != pat3) {
			print_err(msg,addr,pat3,readback);
			return(1);
		}
	}
	return(0);
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
chk_sum(strt, len)
register unsigned char *strt;
register len;
{
	register crc=0, i;			/* temp variables. */

	for(i = 0; i < len; i++, strt++)
		crc=(crc<<8) ^ crctab[((((crc>>(8))&0x00ff) ^ (*strt&0x00ff))&0x00ff)];
	return(crc & 0x0000ffff);	/* and return to calling program. */
}

