
#include "types.h"
#include "misc.h"
#include "globl.h"
#include "spm.h"
#include "rwicio.h"
#include "iom.h"
#include "ioa0.h"
#include "disp.h"
#include "rwi.h"
#include "novram.h"
#include "icb_config.h"
#include "iosba_addr.h"

#define	IF_ESC	if (ifesc()) { cpu_idle(0,0); return; }

extern uint  iopm_present;
extern uchar bdhere[];		/* slots for CSS boards */

static uchar adapt_type;

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
try_pwr_on()	/* Called after cold powerup tests passed */
{
	struct cio *cioptr = CIO_0;

	if (key() == KEY_OFF) {	
		printf("\nPlease turn key to 'ON' position when ready to \n");
		printf("     continue, or press ESC to enter local monitor.\n");
	}

	while (!ifesc()) { 	/* loop until key on, or ESC entered. */
		if(key() == KEY_ON)   /* Is key on yet? */
			pwr_on();	/* YES - power system on */
	}
					/* go back to start local monitor */
	cioptr->portcs[0].reg = ICW_CPUS;   
	cioptr->portcs[0].reg = ICW_CIUS;	/* re-enable interrupts */
	return(0);	
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
autoboot()	
{
	register struct novram *ptr = (struct novram *)NOVRAM;
	uint i, i1;
	char  *bootstr;

	if (!ptr->autoboot) {			/* Is autoboot flag set. */ 
		printf("\nAutoboot flag is disabled.");	/* Flag not set */
		printf("\nReturning to Monitor\n");
		return;
	}

#ifdef	SPM_PROM
	if (ptr->diag_fly_by)
		bootstr = (char *)&ptr->spm_boot_disk[0]; /* spm default. */
	else
		bootstr = (char *)&ptr->diag_boot[0]; 	  /* diag default. */
#endif

#ifdef	SPM_CONFIG
	bootstr = (char *)&ptr->spm_boot_disk[0]; /* spm default. */
#endif

	printf("\r                                ");
	printf("\nAutoboot:  boot path is %s.\n", bootstr);

	printf("\rPress any key to abort autoboot.");
	for (i = 0; i < 1100; i++) {	/* loop a LONG time....5 seconds */
		for (i1 = 0; i1 < 160; i1++)
			if (con_in() != -1) { /* someone pressed something..  */
				printf("\nReturning to Monitor\n");
				ptr->autoboot = 0;	/* Turn off autoboot */
				return;			/* return to monitor */
			}
	}

	printf("\rBooting %25s                      ", bootstr);
	boot(bootstr, 0, 0);		/*  We should not return from this,
					     *  if we do, then return to the 
					     *  monitor.
					     */
	return;
}

iominit(iom_slot)	/* do boot path iom/ioa or iosba initialization */
uint	iom_slot;
{
	if (io_rst(iom_slot))
		return(1);
	iom_ioa_init(iom_slot);
	return(0);
}


iom_ioa_init(iom_slot)
uchar iom_slot;
{
	uchar addr,*cmem;
	uint       *wmem;

	cmem = (uchar *)IOM_ER_RST;	 /* IOM error reset register */
	addr = (uchar)CSSADD((uint)cmem);
	cmem = (uchar *)CSSMAP7((uint)cmem);
	cssmap(MAP07,iom_slot,addr);
	*cmem = 0x00;			/* reset IOM error */

	
	cmem = (uchar *)LNKCTL;	 /* IOM link control register */
	cmem = (uchar *)CSSMAP7((uint)cmem);
	switch (adapt_type) {
		case TYPE_IOA:
			*cmem = 0x11;	/* IOA interrupt request enable */
			break;
		case TYPE_IOSBA:
			*cmem = 0x01;	/* turns on IOM led */
			break;
		default:
			break;
	}
	cmem = (uchar *)IOMCTL;	 /* IOM control register */
	cmem = (uchar *)CSSMAP7((uint)cmem);
	*cmem = 0x20;			/* IOM interrupt enable */

	switch (adapt_type) {
		case TYPE_IOSBA:
			init_iosb_regs(iom_slot);
			init_iosba(iom_slot,0);	/* do module/interface enable */
			break;
		case TYPE_IOA:
			wmem = (uint *)IOA_CMD_REG;  /* IOA command register */
			wmem = (uint *)CSSMAP7((uint)wmem);
	
			/* IOA interrupt enable and DTB transfer enable */
			*wmem = IOA_INT_EN | DTB_EN ; /* */
	
			/* initial IO module interrupt vector table */
			iom_int_tbl_init(iom_slot,0);
			break;
		default:
			break;
	}
}

io_rst(iom_slot)
char 	iom_slot;
{
	uint 		*cmd_mem;
	uchar		*mem;
	uchar		addr;
	uint 		j;

	if ((adapt_type = test_for_adapter(iom_slot)) == NO_ADAPTER) {
		printf ("IOM in slot %x (%d) does not have an adapter.\n",
			iom_slot, iom_slot);
		return(1);
	}

	mem = (uchar *)IOMRST;	/* IO module reset register */
	addr = (uchar)CSSADD((uint)mem);
	mem = (uchar *)CSSMAP((uint)mem);
	cssmap(MAP00,iom_slot,addr);
	*mem = 0;			/* Issue IO module reset */

	if (adapt_type == TYPE_IOA) {
		cmd_mem = (uint *)IOA_CMD_REG;  /* IOA command register */
		addr  = (uchar)CSSADD((uint)cmd_mem);
		cmd_mem = (uint *)CSSMAP7((uint)cmd_mem);
		cssmap(MAP07,iom_slot,addr);
		*cmd_mem = 0x80000000;	/* set IO adaptor reset bit active */
	
		j = 0x10000;	
		while(j != 0)
			j--;
	
		*cmd_mem = 0x00000000;	/* inactive IO adaptor reset bit */
	}
	return(0);
}

start_main()
{

	init_css();		/* Initialize bus */

	init_io_struct();
	
	iopm_present = 0;

#ifdef	SPM_PROM
	prom_poll();		/* poll slots */
#endif

#ifdef	SPM_CONFIG
	config_poll(1);		/* poll slots (and build board table) */
#endif

	IF_ESC

	printf("\rInitializing the dispatcher.  	");
	sp_int_set();			/* set SPM to receive interrupt */

	IF_ESC

	if (iom_present())
#ifdef	SPM_PROM
		prom_poll_io();
#endif
#ifdef	SPM_CONFIG
		config_poll_io(1);
#endif

	if (iopm_present) {
		printf("\rChecking IOPM Board responses...   ");
		check_iopm_magic();
	}

	IF_ESC

#ifdef	SPM_CONFIG
	do_diag();

	/* re-intializing CSS, enabling slots WITHOUT re-building table */
	config_poll(0);		/* enable CSS without re-building table */
	if (iom_present())
		config_poll_io(0);	/* enable IO without re-building tab */

	IF_ESC
#endif

	printf("\rChecking system configuration.	");
	if ((ck_css_config()) == 0xFF) { 
		printf("\nBad system configuration detected.\n");
		cpu_idle(0,0);
		return;
	}

	printf("\rSetting PM(s) to idle mode.        ");
	cpu_idle(0,0);				/* Tell pm boards to idle. */

	printf("\rConfiguration check.               ");
#ifdef	SPM_PROM
	novchk();			/* Go check on nov_ram configuration. */
#endif

#ifdef	SPM_CONFIG
	printf ("\rNOVRAM configuration check (after diagnostics).\n");
	novchk();			/* Go check on nov_ram configuration. */
#endif

	autoboot();			/* Autoboot the default code. */

	return;
}

int
iom_present()
{
	uint	slot;

	for (slot = 0; slot != Sbus_Num_Slot; slot++) {
		if ((bdhere[slot] & BDTYPEMASK) == IOMTYPE) {
			if (test_for_adapter(slot) == NO_ADAPTER)
				continue;
			else
				return(1);
		}
	}

	return(0);
}
