# This file contains the following routines:
			# cmpblk
			# softreset
			# _which, which
			# Blink
			# chgint
			# PrintStr
			# Print
			# Tlerr
			# TWerr
			# TBerr
			# adelay2
			# _cache
			# dnfile, _dnfile
			# reloc_code, _reloc_code
			# mov_code, _mov_code
			# mov_iopm_code, _mov_iopm_code
			# mtinit

include(./head/top.h)

global mtinit
global which, _which
global Blink
global chgint
global PrintStr
global Print
global TLerr
global TWerr
global TBerr
global adelay2
global _cache
global  softreset
global  cmpblk
global dnfile, _dnfile
global reloc_code, _reloc_code
global mov_code, _mov_code
global mov_iopm_code, _mov_iopm_code

#	cmpblk.s  ->  compares a 512 byte block of memory with another.
#	returns either 512 if all bytes match, or 0-511, the offset of
#	the first byte that fails the match.
#		res = cmpblk(src_addr,tst_addr)

	text

cmpblk:
	mov.l	%a0,-(%sp)
	mov.l	%a1,-(%sp)
	mov.l	%d1,-(%sp)

	mov.l	16(%sp),%a0		# get the source address
	mov.l	20(%sp),%a1		# get the destination address
	mov.l	&512,%d1		# size of a sector

	clr.l	%d0
cb1:
	cmp.b	(%a0)+,(%a1)+		# do a cmpm.b command
	bne.b	cbx			# branch if fail

	add.l	&1,%d0			# keep track of who's next
	dbf		%d1,cb1		# go around again

cbx:
	mov.l	(%sp)+,%d1
	mov.l	(%sp)+,%a1
	mov.l	(%sp)+,%a0

	rts


#-------------------------------------------------------------------------------
#	The software equivalent of mashing reset
#-------------------------------------------------------------------------------
softreset:
	mov.w	&0x2700,%sr
	mov.l	&100,%d0		#do many resets
srst:
	reset
	tst.w	%d0			# Zero?
	dbra	%d0,srst
	mov.l	0,%sp
	mov.l	4,%a0
	jmp	(%a0)

_which:
which:
	mov.l	&promstart,%d0		# get my address.
	and.l	&0xffff0000,%d0 	# strip junk.
	bne.b	lwhich
	mov.l	&0, %d0
	rts
lwhich:
	mov.l	&1, %d0
	rts

#-------------------------------------------------------------------------------
# Blink leds
# %d0 = code
#-------------------------------------------------------------------------------
Blink:
	mov.b	%d0,%d1			# Save the Failure status.
	sub.b	&0x01,%d1		# Decrement the counter
blnk1:
	mov.b	&0xb2,wrcntl2		# Light LED 0.
	jsr		blnkw0		# Wait a little while.
	mov.b	&0xf2,wrcntl2		# All off.
	jsr		blnkw0		# Wait a little while.
	tst.b	%d1			# Zero?
	dbeq	%d1,blnk1 		# If zero then blink LED 1.
	mov.b	&0xda,wrcntl2		# Yes it is zero. Blink LED 1.	
	jsr		blnkw0		# Wait a little while.
	mov.b	&0xf2,wrcntl2		# All leds off.
	jsr		blnkw0		# Wait a little while.
	bra.b	Blink

#-------------------------------------------------------------------------------
blnkw0:
	mov.w	&0x0005,%d2		# Outer loop count
blnkw1:
	mov.w	&0xff00,%d3		# Inner loop count
blnkw2:
	tst.w	%d3			# Zero?
	dbeq	%d3,blnkw2 		# Skip if no
	tst.w	%d2			# Zero?
	dbeq	%d2,blnkw1		# Skip if no
	rts

#-------------------------------------------------------------------------------
# chgint : Change interrupt level to value passed on stack and return old level
#-------------------------------------------------------------------------------

chgint:
	mov.l	4(%sp),%d0		# get desired level (from stack)
	lsl.l	&8,%d0			# get level info into position
	mov.w	%sr,%d1			# get present level
	and.w	&0xf8ff,%d1		# strip out int level
	or.l	%d0,%d1			# fill in desired level
	mov.w	%sr,%d0			# get present level again (for return)
	lsr.l	&8,%d0			# shift level
	and.l	&0x7,%d0		# save interrupt level info only
	mov.w	%d1,%sr			# update status reg with desired level
	rts				# with original level in d0


#-------------------------------------------------------------------------------
# PrintStr : print a string
#
# entry: %a1 = address of null terminated string
#-------------------------------------------------------------------------------
PrintStr:
	movm.l	&D0S+D1S+D2S+A2S,-(%sp)
	mov.l	&scca,%a2
Rdchar:
	mov.b	(%a1)+,%d0
	cmp.b	%d0,&0x00
	beq.b	Prdone

Print0:
	mov.w	&0x002f,%d2		# Outer loop count
Print1:
	mov.w	&0xffff,%d1		# Inner loop count
Print2:
	btst	&2,(%a2)
	bne.b	send			# If O.K. and ready to send.
	tst.w	%d1			# Zero?
	dbeq	%d1,Print2		# Wait for timeout ot happen.
	tst.w	%d2			# Zero?
	dbeq	%d2,Print1		# Wait for timeout ot happen.
	mov.b	&0x0a,%d0		# If i got here something is wrong.
	bra		Blink		# Lamp code to flash led s0 and s1.

send:
	mov.b	%d0,(%a2,16.w)
	bra.b	Rdchar

Prdone:
	movm.l	(%sp)+,&D0R+D1R+D2R+A2R
	rts

#-------------------------------------------------------------------------------
# Print : print a byte 
#
# entry: %d0 = byte to print
#-------------------------------------------------------------------------------
Print:
	movm.l	&D1S+D2S+A2S,-(%sp)
	mov.l	&scca,%a2

Prt0:
	mov.w	&0x002f,%d2		# Outer loop count
Prt1:
	mov.w	&0xffff,%d1		# Inner loop count
Prt2:
	btst	&2,(%a2)
	bne.b	send1			# If O.K. and ready to send.
	tst.w	%d1			# Zero?
	dbeq	%d1,Prt2		# Wait for timeout ot happen.
	tst.w	%d2			# Zero?
	dbeq	%d2,Prt1		# Wait for timeout ot happen.
	mov.b	&0x0b,%d0		# If I got here something is wrong.
	bra		Blink		# Lamp code to flash led s0 and s1.

send1:
	mov.b	%d0,(%a2,16.w)
Prdn:
	movm.l	(%sp)+,&D1R+D2R+A2R
	rts
#-------------------------------------------------------------------------------
# TLerr: Print a long error
#
#	entry: %a0 = error location
#	       %d0 = expected data
#	       %d1 = actual data
#-------------------------------------------------------------------------------
TLerr:
	movm.l	&D1S,-(%sp)		# Save error data
	movm.l	&D0S,-(%sp)		# Save actual data
	movm.l	&A0S,-(%sp)		# Save error location
	lea.l	failmsg,%a1
	jsr		PrintStr
	lea.l	addmsg,%a1
	jsr		PrintStr
	movm.l	(%sp)+,&D0R	
	jsr		LongOut	
	lea.l	edmsg,%a1
	jsr		PrintStr
	movm.l	(%sp)+,&D0R
	jsr		LongOut	
	lea.l	admsg,%a1
	jsr		PrintStr
	movm.l	(%sp)+,&D0R
	jsr		LongOut	
	rts

#-------------------------------------------------------------------------------
# TWerr: Print a word error
#
#	entry: %a0 = error location
#	       %d0 = expected data
#	       %d1 = actual data
#-------------------------------------------------------------------------------
TWerr:
	movm.l	&D1S,-(%sp)		# Save error data
	movm.l	&D0S,-(%sp)		# Save actual data
	movm.l	&A0S,-(%sp)		# Save error location
	lea.l	failmsg,%a1
	jsr		PrintStr
	lea.l	addmsg,%a1
	jsr		PrintStr
	movm.l	(%sp)+,&D0R	
	jsr		LongOut	
	lea.l	edmsg,%a1
	jsr		PrintStr
	movm.l	(%sp)+,&D0R
	jsr		WordOut	
	lea.l	admsg,%a1
	jsr		PrintStr
	movm.l	(%sp)+,&D0R
	jsr		WordOut	
	rts

#-------------------------------------------------------------------------------
# TBerr: Print a byte error
#
#	entry: %a0 = error location
#	       %d0 = expected data
#	       %d1 = actual data
#-------------------------------------------------------------------------------
TBerr:
	movm.l	&D1S,-(%sp)		# Save error data
	movm.l	&D0S,-(%sp)		# Save actual data
	movm.l	&A0S,-(%sp)		# Save error location
	lea.l	failmsg,%a1
	jsr		PrintStr
	lea.l	addmsg,%a1
	jsr		PrintStr
	movm.l	(%sp)+,&D0R	
	jsr		LongOut	
	lea.l	edmsg,%a1
	jsr		PrintStr
	movm.l	(%sp)+,&D0R
	jsr		ByteOut	
	lea.l	admsg,%a1
	jsr		PrintStr
	movm.l	(%sp)+,&D0R
	jsr		ByteOut	
	rts



#***********************************
#  Function: adelay using DelCnt as loopcount
#
adelay2:
					# approx. 10 clocks/us
	mov.l	%d1,-(%sp)		# save d1
	mov.l	&DelCnt,%d1		# load count
adl1:
	nop				# (2/2/3) clocks
	tst.w	%d1			# Zero?
	dbeq	%d1,adl1		# do it DelCnt number of times (3/6/9)

	mov.l	(%sp)+,%d1	# get back d1
	rts			# (26/37/45) + (5/8/12) * cnt
				# yields b/c/w lapcounts of 47/28/18 for 26us


# _cache : enable / disable 68020 on-chip cache.
# called by cmds.c, other.c, pollcss.c, switches.c

_cache:
	mov.l	4(%sp),%d0
	and.l	&0x01,%d0
	mov.l	&0x08,%d1
	mov.l	%d1,%cacr
	mov.l	%d0,%cacr
	rts

# dnfile : called by dnld.c

_dnfile:
dnfile:
	mov.l	&dnfile2, %d0		# this code assures we are in prom.
	and.l	&0x0000ffff, %d0
	mov.l	%d0, %a0
	mov.l	4(%sp), %d0		# move argument into register.
	jmp		(%a0)
dnfile2:
	mov.l	&stack,%sp		# Setup stack pointer again.
	mov.l	0x103e000, %d4		# save entry point of download code.
	mov.l	%d0, -(%sp)  		# put %d0 on the stack.
	jsr		dnfile1		# go attempt the download.
	cmp.l	%d0, &0			# check d0 for passed download.
	beq.b   past_me
	jmp	localstart		# since failed, go to local monitor.
past_me:
	mov.l	%d4, %a0		# transfer address into register.
	jmp		(%a0)		# and start download.

# reloc_code : not used; possibly was used by diag image. load_ram 
# was defined only IFDEF DIAG_IMAGE. Currently an empty function
# declared in other.c


_reloc_code:
reloc_code:
	mov.l	&stack,%sp		# Setup stack pointer again.
	jsr	load_ram		# go attempt the download.
	jmp	localstart		# if returned, it failed.


# mov_code : called by boot.c 


_mov_code:
mov_code:
	mov.l	&stack,%sp		# Setup stack pointer again.
	jsr	load_icb_run		# go attempt the download.
	jmp	localstart		# if returned, it failed.

# mov_iopm_code : called by boot.c


_mov_iopm_code:
mov_iopm_code:
	mov.l	&stack,%sp		# Setup stack pointer again.
	jsr	load_iopm_run		# go attempt the download.
	jmp	localstart		# if returned, it failed.

#-------------------------------------------------------------------------------
#   map.s
#
#	mtinit: Put a bit of code into the main memory ram, call it.
#
#	maptest: Code that runs in memory under test.
#	It should run, print, then move itself upwards in
#	main memory and run again.  This process should continue
#	until ram is exhausted.
# 	Enter with d2=memsize/mysize.
#	Print address of execution, perhaps.
#-------------------------------------------------------------------------------

set mysize,32
set mainmem,0x80000000

mtinit:					# move the program
	movm.l	&0xe0c0,-(%sp)		# save needed registers
	mov.l	24(%sp),%d2		# laps to do
	lea.l	maptest,%a0
	mov.l	&mysize,%d0
	mov.l	&mainmem,%a1
mtilp:
	mov.b	(%a0)+,(%a1)+
	dbra	%d0,mtilp
	mov.l	&mainmem,%a0
	jsr		(%a0)
	movm.l	(%sp)+,&0x0307
	rts

printlx:
	mov.l	(%sp)+,%a0		# get back the callers address
	mov.l	(%sp)+,%d0		# get the argument
	jmp		(%a0)		# go back without doing anything

maptest:
	nop
	nop
	mov.l	%a0,%a1			# copy the base address
	mov.w	&mysize,%d0		# how big this prog is.
	mov.l	%d0,%d1			# copy it
mtlp:
	mov.b	(%a0)+,0(%d0,%a1)
	add.l	&1,%d0
	sub.l	&1,%d1
	bne.b	mtlp
	sub.l	&1,%d2			# how many times should this be done?
	bne.b	mtlpend
	rts				# return if done
mtlpend:				# trick part: fall through to a copy
					# of this
	nop
	nop
	nop

failmsg:
	byte	' ,'f,'a,'i,'l,'e,'d,'\r,'\n,NULL
addmsg:
	byte	' ,' ,'a,'d,'d,'r,'e,'s,'s,'=,' ,NULL
edmsg:
	byte	' ,' ,'e,'x,'p,'e,'c,'t,'e,'d,' ,'d,'a,'t,'a,'=,' ,NULL
admsg:
	byte	' ,' ,'a,'c,'t,'u,'a,'l,' ,'d,'a,'t,'a,'=,' ,NULL

