/*
    11/18/87 Yung Chang added io_debugger in systet
 test menu for IOSS
*/
/*  localmenu.c
 *
 *	All the local menus.
 *
 *	struct menu {
 *		char *comm_text;
 *		char *comm_opt;
 *		char *comm_desc;
 *		char comm_type;
 *		unsigned char lo_limit;
 *		unsigned char hi_limit;
 *		union {
 *			PFI procedure;
 *			struct menu *menu_p;
 *		} command;
 *      char *help;
 *	};
 *
 *	Menu.comm_text is the full text for the command name, such as 'l(ist)'.
 *	Menu.comm_opt is the description for the options in the command.
 *	Menu.comm_desc is the description for the command.
 *	Menu.comm_type is one of 'c' or 'm', defining the command to be
 *		a straight command or a pointer to another menu, respectively.
 *	Menu.lo_limit is the low limit of the number of arguments allowed for
 *		the command.
 *	Menu.hi_limit is the high limit of the number of arguments allowed for
 *		the command.
 *	Menu.command is a union containing either a pointer to a procedure or
 *		a pointer to another menu.
 *	Menu.command.procedure points to the related procedure.
 *	Menu.command.menu_p points to the related sub-menu.
 *  Menu.help is a text description of the command.
 *	Menus are terminated with a null string in the menu.comm_text field.
 */
#include "types.h"
#include "menu.h"
#include "routines.h"

extern int init_novram_config();
extern int up_nov_chksum();
extern int show_config();
extern int c_atb();		/* Change Auto Boot flag. */
extern int c_dfb();		/* Change Diag Fly By flag. */
extern int dte();		/* Print the date the code was compiled. */
extern int nov_boot_path();
extern int show_em();
extern int display_cios_status();
extern int pmmenu();
extern int local_a_d();
extern int printer();
extern int modem();
extern int chg_baud();

#ifdef SPM_CONFIG
extern int start_main();	/* diag option of the test menu */
#endif

/*
 * Menus
 *
 * The menu pointers have to be cast to PFI due to a compiler deficiency.
 * The same for the init_menu struct instead of just a menu declaration.
 */

char hlp_clk[]="[<css|bd>]  where: 'css' is CSS clock, 'bd' is local clock";

struct init_menu i_boot_level[] = {
#ifdef	SPM_PROM
	"b(oot)", "flp/|X[/Y]<mt[#]|nt[#]|d#|d#s#>file_name",
	"System Boot", 'c', 0, 1, bootme,(char *)0,

	"d(ir)", "flp/|X[/Y]<mt[#]|nt[#]|d#|d#s#>",
	"System Directory", 'c', 0, 1, bootme,(char *)0,
#endif
#ifdef	SPM_CONFIG
	"b(oot)", "X[/Y]<mt[#]|nt[#]|d#|d#s#>file_name",
	"System Boot", 'c', 0, 1, bootme,(char *)0,

	"d(ir)", "X[/Y]<mt[#]|nt[#]|d#|d#s#>",
	"System Directory", 'c', 0, 1, bootme,(char *)0,
#endif

#ifdef	SPM_PROM
	"sd(l)", "",
	"Serial Download and jmp to address",'c',0,1,dnld, (char *)0,

#ifdef	REMOVE
	"Sd(l)", "",
	"Single port serial download, jmp to address",'c',0,1,dnld, (char *)0,
#endif
	"pwron","", 
	"Turn on main power", 'c', 0, 2, do_on_pwr, (char *)0,
#endif
	"pwroff","", 
	"Turn off main power", 'c', 0, 2, do_off_pwr, (char *)0,

	"cl(ock)", "",
	"Select/Show clock source",'c',0,1,Clock, hlp_clk,

	"printer", "[<on/off>]",
	"Enable/Disable printer port",'c',0,1,printer, (char *)0,

	"modem", "[<on/off>]",
	"Enable/Disable modem port",'c',0,1,modem, (char *)0,

	"mbaud","",
	"Set the modem port baud rate",'c',0,0,chg_baud,(char *)0,

	"cbaud","",
	"Set the console port baud rate",'c',0,0,chg_baud,(char *)0,

	"pbaud","",
	"Set the printer port baud rate",'c',0,0,chg_baud,(char *)0,

	"ubaud","",
	"Set the ups port baud rate",'c',0,0,chg_baud,(char *)0,

	"s(tatus)", "",
	"System Status Menu", 'm', 0, 0, (PFI)i_system_status, (char *)0,

	"t(st)", "",
	"System Test Menu", 'm', 0, 0, (PFI)i_system_test, (char *)0,

	"","","", '\0', 0, 0, 0, (char *)0,
};

struct init_menu i_system_status [] = {
	"sy(stem)","",
	"Print system config in NV RAM",'c',0,0,show_config,(char *)0,

	"show","[<CSS|I/O|i/o>]",
	"Show CSS and I/O config",'c', 0, 1,show_em,(char *)0,

	"ti","[h [m [s [day [m [d [yr]]]]]]] ",
	"Read/Set time and date",'c',0,7,tod,(char *)0,

	"te", "",
	"Read card cage temperature",'c',0,0,temp,  (char *)0,

	"up(date)","",
	"Update system config in NV RAM",'c',0,0,init_novram_config,(char *)0,

	"cr(c)","[<0|1|2>]",
	"Update the CRC in NV RAM",'c',0,1,up_nov_chksum,(char *)0,

	"atb","",
	"Toggle Autoboot flag.",'c',0,0,c_atb,(char *)0,

	"dfb","",
	"Toggle Diagnostic Fly By flag.",'c',0,0,c_dfb,(char *)0,

	"dte","",
	"Print compile date.",'c',0,2,dte,(char *)0,
                 
        "volt", "",
	"Display voltages at local A/D",'c', 0, 0, local_a_d, (char *)0,

        "lvolt", "",
	"Looping display voltages at local A/D",'c', 0, 0, local_a_d, (char *)0,

	"nvi(nit)","[<0|1|2>]",
	"Initialize the NV RAM",'c',0,1,nvinit,(char *)0,

	"nve(dit)","",
	"Edit the NV RAM",'c',0,0,nvedit,(char *)0,

	"cpa(th)","",
	"Clear both Boot Paths",'c',0,0,nov_boot_path,(char *)0,

	"vpa(th)","",
	"View current Boot Paths",'c',0,0,nov_boot_path,(char *)0,

	"dpa(th)","",
	"Change Diag Boot Path",'c',0,0,nov_boot_path,(char *)0,

	"rpa(th)","",
	"Change Runtime Boot Path",'c',0,0,nov_boot_path,(char *)0,

	"","","", '\0', 0, 0, 0, (char *)0,
};

struct init_menu i_system_test [] = {
	"d(ebugger)","", 
	"Debugger Menu", 'm', 0, 0, (PFI)i_debugger, (char *)0,

#ifdef	SPM_PROM
	"fdi(ag)","",
	"Floppy Disk Diagnostics Menu",'m',0,0,(PFI)i_flp_diag,(char *)0,
#endif

#ifdef	SPM_CONFIG
	"diag","",
	"System Diagnostics",'c',0,0,start_main,(char *)0,
#endif

	"rwi","",
	"Real World Interface Tests Menu",'m',0,0,(PFI)rwi_tests,(char *)0, 

	"", "", "", '\0', 0, 0, 0, (char *)0,
};

/*
 * This is where we set the real menu pointers up.  This is required for the
 * menu to work.
 */
struct menu *boot_level = (struct menu *)i_boot_level;	/* top level menu */
struct menu *system_status = (struct menu *)i_system_status;
struct menu *system_test = (struct menu *)i_system_test;
