include(./head/top.h)

#
#	image.s
#		routines either used only by the loadable image, or NULL
#		routines and labels required by the common routines
#

#	NULLs or stub routines
global	st_isec, e_isec, dnfile1, migrate
global	pow_up_tst

#	image only routines
global	trap1
global	trap2
global	vbrmv

#	image startup routines
global	localstart	
global	mon_start

text

st_isec:				#  labels needed for copy_flp_code in
e_isec:					#  startup.s
	nop

dnfile1:				#  subroutine for sd called in startup.s
	rts

migrate:				#  subroutine to not move vector table 
	rts

pow_up_tst:				#  should never try to do power up tests
	jmp	got_reset		#  if it does, go to got_reset


#
#	beginning of image startup routines
#
localstart:
	lea.l	signon, %a1		# show monitor message
	jsr	PrintStr		# print it to console

mon_start:				# never called directly
#	jsr 	main			# initialize global variables
	jsr	ctinten			# re-enable interrupts

mon_start1:
	jsr	version 		# display version info (in C)
	jsr	initscc			# make sure this is init-ed
	jsr	init_monitor		# init pointers and things (in C)
	jsr	monitor			# in C
	bra	mon_start1		# shouldn't come back, but if 
					# it does return to monitor

#
#	image only routines
#
vbrmv:
	mov.l	4(%sp), %d0
	mov.l	%d0,%vbr
	rts

trap1:
	trap	&1
	rts

trap2:
	trap	&2
	rts

signon:
	byte	'\r,'\n,'E,'n,'t,'e,'r,'i,'n,'g,' ,'L,'o,'c,'a,'l
	byte	' ,'M,'o,'n,'i,'t,'o,'r,'\r,'\n,NULL


