 #various equates for the Service Processor Module 

set	prom_size,	0x1ffff		# monitor prom size is 256k
set	sram,		0x01000000	# static ram
set	data_start,	0x0103a000
set	sram_sz,	0x3ffff		
set	stack_size,	0x3fff0
set	stack,		sram+stack_size	# stack starts at top of static ram
set	novram,		0x030007f0	# test byte for non-vol ram

set	statusreg,	0x070000a0
set	wrcntl2,	0x07000040	# 8 bit register, see spec for details

set	cio,		0x02800200	# cio device
set	cioreg,		0x02800205	# cio device
set	cio1_a,		0x02800c1a	# For RWI type.
set	queue_ram,	0x0c000000
set	queue_size,	0x1000
set	clkcntl,	0x5000000
set	notIrdy,	0xbfffffff
set	setIrdy,	0x40000000
set	NULL,		0x00

set	ADC_CNTL,	0x02800102	# control port, adc.
set	ADC_ADATA,	0x02800100	# data port, adc.
set	ADC_SC,		0x0100		# start command, adc.
set	ADC_CH0,	0x0000		# measures +5v for master system
set	ADC_CH1,	0x0001		# reference voltage 4.5v must read FF
set	ADC_EOC,	0x8000		# if set, valid data in lower bits.
set	ADC_MASK,	0x00ff		# mask for valid data.
set	NOV_LO_5V_SHUT, 0x03000142	# addr of 5 volt low shutdown in NV
set	V_LOW,		0x0080		# low limit for 5 volt supply
set	V_HIGH,		0x009A		# high limit for 5 volt supply
				
set	DATA,		0x9000001	# data register 
set	MSR,		0x9000000 	# master status register (ro)
set	DelCnt,		0x060

set	CSS_CL_FLAG,	0xACE0ACE1
set	LOC_CL_FLAG,	0xDBC0BB23

set	A7S,		0x0001
set	A6S,		0x0002
set	A5S,		0x0004
set	A4S,		0x0008
set	A3S,		0x0010
set	A2S,		0x0020
set	A1S,		0x0040
set	A0S,		0x0080
set	D7S,		0x0100
set	D6S,		0x0200
set	D5S,		0x0400
set	D4S,		0x0800
set	D3S,		0x1000
set	D2S,		0x2000
set	D1S,		0x4000
set	D0S,		0x8000
set	D0R,		0x0001
set	D1R,		0x0002
set	D2R,		0x0004
set	D3R,		0x0008
set	D4R,		0x0010
set	D5R,		0x0020
set	D6R,		0x0040
set	D7R,		0x0080
set	A0R,		0x0100
set	A1R,		0x0200
set	A2R,		0x0400
set	A3R,		0x0800
set	A4R,		0x1000
set	A5R,		0x2000
set	A6R,		0x4000
set	A7R,		0x8000

 # SCC goodies
set	sccb,		0x02800800	# scc device
set	scca,		0x02800820	# scc device
set	WR0_RSTINT,	0x10		# Reset external status interrupts
set	WR0_SHL,	0x02		# Shift left mode
set	WR1_RXALL,	0x10		# Rx int on all or special condition
set	WR1_EXTEN,	0x01		# External ints enable
set	SCCSTVECT,	0x10		# Int vector
set	WR3_RX8,	0xc0		# Transmit 8 bits
set	WR3_RXEN,	0x01		# Reciever enable
set	WR4_1STOP,	0x04		# Async 1 stop bit/character
set	WR4_16CLOCK,	0x40		# x16 clock mode
set	WR5_DTR,	0x80		# Data terminal ready
set	WR5_TX8,	0x60		# 8 tx bits
set	WR5_RTS,	0x02		# Request to send
set	WR5_TXEN,	0x08		# Transmitter enable
set	WR9_HRST, 	0xc0		# Hardware reset
set	WR9_NV,	  	0x02		# No vector
set	WR9_MIE,	0x08		# Master interrupt enable
set	WR11_RCGO,	0x40		# Use baud gen for recieve clock
set	WR11_TCGO,	0x10		# Use baud gen for transmit clock
set	BDRT9600,	0x0a		# 9600 baud time constant
set	WR14_ENABD,	0x01		# Enable baud rate generator
set	WR14_PCLK,	0x02		# PCLK is source for baud generator
set	WR14_LLBK,	0x10		# Local loopback mode	
set	WR14_ECHO,	0x08		# Auto echo
set	WR15_DCDIE,	0x08		# DCD interrupt enable

set	ACRW,		0x04 		# ACRW version

