/*
*************************************************************************fil**
**		 ARETE SYSTEMS CORPORATION CONFIDENTIAL AND PROPRIETARY
**	This source is the sole property of ARETE SYSTEMS CORPORATION
**	Reproduction or utilization of this source in whole or in part
**	is forbiden whithout the written consent of 
**	ARETE SYSTEMS CORPORATION.
******************************************************************************
**
**			(c) Copyright ARETE SYSTEMS CORPORATION 1988
**			    All Rights Reserved.
******************************************************************************
**
**	FILE NAME:	rwiad.h
**	TYPE:		C header file	
**
**	DESCRIPTION:	this file contains definitions for the hardware 
**			of the RWI board 
**			Schematics (DWG.NO SD-02580-02-2B) 06/15/88
**			Specification (FS-02580-00 Rev.2B) 06/14/88
**
**
**
******************************************************************************
*/ 

/*
 * Select Type of ad converter we have in place 
 * #define MOTOROLA if we have MC1442 chip
 * #define TI 	    if we have TLC chip
 */
#define	TI


#define MAX_SENSOR_NAME 25	/* Maximum length of sensor name */

/*	mux number values */

#define MUX_VAL_1	0x00
#define REF		0x01
#define MUX_VAL_2	0x10
#define MUX_VAL_3	0x20
#define MUX_VAL_4	0x30
#define MUX_VAL_5	0x40
#define MUX_VAL_6	0x50
#define MUX_VAL_7	0x60
#define MUX_VAL_8	0x70

/*	channel number values */

#define TEMP_MUX_0	0x00
#define TEMP_MUX_1	0x02
#define TEMP_MUX_2	0x03
#define PS_MUX_0	0x04
#define PS_MUX_1	0x05
#ifdef MOTOROLA
#define PS_MUX_2	0x06
#endif
#ifdef TI
#define PS_MUX_2	0x0E
#endif

typedef	struct sensor {
	char name[MAX_SENSOR_NAME];	/* name of the sensor */
	short muxsel;			/* multiplexer */
	short adch;			/* A/D channel */
	short chtyp;			/* channel type */
	short cabinet;		/* cabinet associated with this sensor */
} SENSOR;

/*
*************************************************************************end**
**		 ARETE SYSTEMS CORPORATION CONFIDENTIAL AND PROPRIETARY
**	This source is the sole property of ARETE SYSTEMS CORPORATION
**	Reproduction or utilization of this source in whole or in part
**	is forbiden whithout the written consent of 
**	ARETE SYSTEMS CORPORATION.
******************************************************************************
*/ 
