/*******************************************************************
 *	RWI Revision ID
 *******************************************************************/

#define	REV1A	0x00
#define	REV2B	0x01
#define	ACRW	0x04

/*******************************************************************
 *	M E M O R Y    M A P P E D    I / O
 *******************************************************************/

#define SCC0B     ((struct scc *)0x02800800)
#define SCC0A     ((struct scc *)0x02800820)
#define SCC1B     ((struct scc *)0x02800900)
#define SCC1A     ((struct scc *)0x02800920)

#define CIO_0     ((struct cio *)0x02800A00)
#define CIO_1     ((struct cio *)0x02800C00)

#define ADC_DATA_PORT 	((unsigned short *) 0x02800B00)
#define ADC_CTRL_PORT 	((unsigned short *) 0x02800B02)

#define MUX_LE    ((unsigned short *) 0x02800D00)

#define NONE  1
#define TEMP  2
#define VOLTS 3
#define CURRENT 4

#define RTC_TSMS  16     /* real time clock time slice in milliseconds */
#define RTC_TC    (RTC_TSMS*200)  /* real time clock time constant */
#define RTC_RNDUP(x) ((x+(RTC_TSMS-1))/RTC_TSMS) /* round up value */
#define NUMSCCS   2      /* number of SCC's */
#define NUMSCHAN  (NUMSCCS*2) /* number of SCC channels to program */
#define ACRW_NUMSCCS   1      /* number of SCC's */
#define ACRW_NUMSCHAN  (ACRW_NUMSCCS*2) /* number of SCC channels to program */

/*******************************************************************
 *	I N T E R R U P T    V E C T O R S
 *******************************************************************/

#define SCCSTVECT 128   /* starting vector for the SCC's */
#define ADJSCCVECT(I) (SCCSTVECT + ((I & 0xfe) << 3)) /* adjust SCC vector */

#define PPORTAVEC0 160
#define PPORTAVEC1 161
#define PPORTBVEC  162
#define CTVECT     164

/*******************************************************************
 * CPU INTERRUPT PRIORITY LEVELS
 *******************************************************************/

#define PLEV7  7		/* ICB NMI    */
#define PLEV6  6 		/* WD Timer   */
#define PLEV5  5 		/* SCC - CIO  */
#define PLEV4  4 		/* DMA Parity */
#define PLEV3  3 		/* DMA Count  */
#define PLEV2  2 		/* CIB int    */
#define PLEV1  1 		/* Not used   */
#define PLEV0  0 		/* Not used   */
#define	PNULL	(char *)(0)

/*******************************************************************************
		RWI A/D converter state variable
*******************************************************************************/
#define INLET_AIR			0x10
#define	EXHAUST_AIR			0x11
#define MAIN_FIVE_VOLT			0x12
#define MAIN_TWELVE_VOLT		0x13
#define	MAIN_NEG_TWELVE_VOLT		0x14
#define	MAIN_FIVE_VOLT_CURRENT		0x15	
#define	PS_TEMP				0x16
#define CAGE_AIR			0x000f

/*******************************************************************************
		CONVERSION NUMBERS
*******************************************************************************/
#define	VOLTS_PER_BIT			176
#define	VOLTAGE_OFFSET			290
#define	VOLTS_PER_DEGREE		703
#define	FIVE_VOLTS_PER_BIT		352	
#define	TWELVE_VOLTS_PER_BIT		850	
#define HC_VOLTS_PER_AMP		33
#define SW_VOLTS_PER_AMP		160	
#define	NEG_TWELVE_ZERO			0xda
#define NEG_TWELVE_MAX			259200
#define	TEN_THOUSAND			10000
#define	ONE_THOUSAND			1000
#define	ONE_HUNDRED			100
#define	NEG_TWELVE_VOLTS_PER_BIT	1188	

/*******************************************************************************
		ANALOG MUX ADDRESSES
*******************************************************************************/
#define	LOCAL_FIVE_VOLT			0x0000
#define	AUX_FIVE_VOLT			0x0002
#define	LOCAL_TWELVE_VOLT		0x0003
#define	AUX_TWELVE_VOLT			0x0004
#define	LOCAL_NEG_TWELVE_VOLT		0x0005
#define	AUX_NEG_TWELVE_VOLT		0x000e
#define LOCAL_VREF			0x0001

