/* portable.h -- type and macro definitions for portable C */
/*   taken originally from  _Portable C and Unix system Programming_ */
/*		J.E.Lapin, Rabbit Software, Prentice-Hall	*/

/* standard types */
typedef	int		bool;	/*  >= 16 bits used as boolean  */
typedef char		flag;	/*  >= 8 bits used as boolean  */

typedef unsigned short	word;	/* >= 16 bits unsigned type */

typedef int		rchar;	/* I/O function return values  */
typedef char		*string;	/* for readability	*/

/* if void is not supported, uncomment the following line.	*/
/* typedef int		void;*/

typedef unsigned char	byte;		/* 8-bit unsigned type */

/* use this length and type for filename variables -- use
   256 on 4.2BSD since it is defined as such in dir.h		*/
#ifndef MAXPATHLEN
#define MAXPATHLEN	64
#endif
typedef char		path[MAXPATHLEN];


/* Define byte and BYTE to portably support an unsigned 8-bit data type	*/
/* If char is signed by default and unsigned keyword is
  not allowed with char, byte and BYTE are:	*/
/*#define BYTE(x)   ((x) & 0xff)  /* BYTE truncates data */
/* otherwise, use the following... */
#define BYTE(x)   (x)  			/* BYTE truncates data */

/* Standard macros  */
#define HIBYTE(x)   (((x) >> 8) & 0xff)  /* hi byte of short	*/
#define LOBYTE(x)   ((x) & 0xff)	 /* lo byte of short	*/
#define HIWORD(x)   (((x) >> 16) & 0xffffL)  /* upperhalf of long */
#define LOWORD(x)   ((x) & 0xffffL)	 /* lower half of long	*/
#define CHAR(x)     ((x) & 0x7f)	 /* truncate to 7 bits	*/
#define WORD(x)     ((x) & 0xffffL)	 /* truncate to 16 bits	*/
#define DECODE(x)   ((int) ((x)-'0'))	 /* int value of a digit */

/* long unsigned right shift */
#define LURSHIFT(n,b)  (((long)(n) >> (b)) & (0x7fffffffL >> ((b)-1)))

/* number of elements in an array a */
#define DIM(a)     (sizeof(a)/sizeof(*(a)))

/* Scope control pseudo-keywords  */
#define public				/* public is C default scope */
#define private   static		/* static really means private */

/* Standard constants  */
#define TRUE	1			/* for use with booleans */
#define FALSE	0

#define SUCCEED	0			/* for use in exit()  */
#define FAIL	(-1)			/* for exit() and error returns */

#define EOL	'\n'		/* end of line char	*/
#define EOS	'\0'		/* end of string char	*/
#define EOP	'\14'		/* end of page (ff) char*/

/* portable.h ends here */

