/*
	flp_resp.h
*/

/* 
	Status Register 0 Bits 
*/
 
#define	SR0MSK	0xc0		/* mask out all but the 2 status bits */
#define	SR0DNC	0x40		/* command sent, but did not finish */
#define	SR0INVL	0x80		/* command  invalid, never sent  */ 
#define	SR0SE	0x20		/* seek end, true */
#define	SR0EC	0x10		/* equipment check if true. */
#define	SR0HS	0x04		/* state of the head at interrupt */
#define	SR0USX	0x03		/* mask for Drive Unit Number */
#define	UNIT0	0x00		/* always unit 0 */

/* 
	Status Register 1 Bits 
*/
 
#define	SR1EN	0x80		/* End of Cylinder error */
#define	SR1DE	0x20		/* Data Error, CRC */
#define	SR1OR	0x10		/* Overrun, host let data transfer time out */
#define	SR1ND	0x04		/* No Data error. */
#define	SR1NW	0x02		/* Not Writable.  Wrote to write-protected. */
#define	SR1MA	0x01		/* Missing Address Mark */

/* 
	Status Register 2 Bits 
*/
 
#define	SR2CM	0x40		/* Control Mark; sect contains DelDataAddrMk */
#define	SR2DD	0x20		/* Data area CRC error */
#define	SR2WC	0x10		/* Wrong Cylinder; disk may have been changed */
#define	SR2SH	0x08		/* Scan Equal */
#define	SR2SN	0x04		/* Scan Not. */
#define	SR2BC	0x02		/* Bad Cylinder */
#define	SR2MD	0x01		/* Missing address mark in data field. */

/* 
	Status Register 3 bits 
*/

#define SR3WP	0x48		/* High means not write protected */
#define SR3RDY	0x20		/* always presumed high */
#define SR3TR0	0x10		/* True = track 0 */

