/******************************************************************************
                   (C)  COPYRIGHT ARIX CORPORATION 1988.
         ALL RIGHTS RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,
          REPRODUCED, OR TRANSLATED TO ANOTHER LANGUAGE WITHOUT THE PRIOR
                    WRITTEN CONSENT OF ARIX CORPORATION.
*******************************************************************************
*
*  PGNAME:  afifo.h  (header filename)
*
*  PURPOSE:
*    Header file defining the Associative FIFO Read/Write Register 
*    addresses assignments 
*
*  METHOD:	N/A
*
*  INPUT: 	N/A
*
*  OUTPUT:	N/A 
*
*  REVISION:	A
*
*  LAST MODIFIED:
*    07/27/89(grw)    Initial creation
*
* 	The Associative FIFO is a proprietary integrated circuit containing
*	a 45 bit wide 8 word synchronous FIFO, and internal bypass register,
*	parity generators and checkers, match detectors and a control/status
*	port.
*
*	The functional blocks for this chip are:
*		1) 47 bit input register (45 input_data, 2 load control)
*		2) 8-45 bit registers made up into a fifo
*		3) Next FIFO input ring counter
*		4) Current FIFO output ring counter
*		5) Valid Bit ( the fifo location has valid data )
*		6) Bypass register
*		7) Match Detector
*		8) Bit Masking Registers
*		9) Main output
*		10) Aux Output = byte 4 of FIFO or Bypass register
*		11) Parity Generators
*		12) Parity Checkers
*		13) Control Port
*******************************************************************************
*/


/********** fifo registers ****************************************************
*/

#define	FIFO_OUT_READBACK_0	0x08	/* current FIFO output readback	      */
#define	FIFO_OUT_READBACK_1	0x09	/*				      */
#define	FIFO_OUT_READBACK_2	0x0a	/*				      */
#define	FIFO_OUT_READBACK_3	0x0b	/*				      */
#define	FIFO_OUT_READBACK_4	0x0c	/*				      */
#define	FIFO_OUT_PARITY		0x0d	/* FIFO output readback parity byte   */
#define FULL_A				0x80	/* FULL_A pin read back       */
#define FULL_B				0x40	/* FULL_B pin read back       */
#define MATCH				0x20	/* Match pin read back	      */
/*	bit 4	= parity from byte 4
	bit 3	= parity from byte 3
	bit 2	= parity from byte 2
	bit 1	= parity from byte 1
	bit 0	= parity from byte 0
*/

#define	FIFO_COPY_BYPASS	0x10	/* copy bypass reg to next fifo input */
					/* location			      */


#define FIFO_AUX_OUT_DATA	0x18	/* pins 7 through 0 read back	      */
/*	truth table
	Aux_out		bypass		oldest_fifo	AUX_OUTPUT
	enable				entry
	----------------------------------------------------------
	 High	  |	don't care   |	don't care   ||	Tri-state
	 Low	  |	Low	     |	don't care   ||	Bypass Register byte 4
	 Low	  |	High	     |	High         ||	Next FIFO output byte 4
	 Low	  |	High	     |	Low	     ||	Curr FIFO output byte 4
*/

#define	FIFO_NXT_INPUT_CNTR_BIT	0x19	/* slave 1 next input counter bits    */
#define	FIFO_NXT_INP_RING_CNTR	0x1a	/* next input ring counter	      */
#define FIFO_READ_OUT_CNTR	0x1c	/* read out cntr bits 8 - 1	      */
#define	FIFO_LOC_VALID_BIT	0x1e	/* FIFO location valid bits	      */

#define	FIFO_DATA_OUT_0		0x30	/* data output pin read back byte 0   */
#define	FIFO_DATA_OUT_1		0x31	/* data output pin read back byte 1   */
#define	FIFO_DATA_OUT_2		0x32	/* data output pin read back byte 2   */
#define	FIFO_DATA_OUT_3		0x33	/* data output pin read back byte 3   */
#define	FIFO_DATA_OUT_4		0x34	/* data output pin read back byte 4   */

#define	FIFO_DATA_OUT_PARITY	0x35	/* data output parity byte	      */
#define	RDY_A				0x80	/* RDY_A pin read back        */
#define	RDY_B				0x40	/* RDY_B pin read back        */
#define INPUT_ERR			0x20	/* INPUT_ERROR pin read back  */
/*	bit 4	= parity from byte 4
	bit 3	= parity from byte 3
	bit 2	= parity from byte 2
	bit 1	= parity from byte 1
	bit 0	= parity from byte 0
*/

#define	FIFO_BYPASS_DATA_0	0x60	/* Bypass register data byte          */
#define	FIFO_BYPASS_DATA_1	0x61	/* Bypass register data byte 1        */
#define	FIFO_BYPASS_DATA_2	0x62	/* Bypass register data byte 2        */
#define	FIFO_BYPASS_DATA_3	0x63	/* Bypass register data byte 3        */
#define	FIFO_BYPASS_DATA_4	0x64	/* Bypass register data byte 4        */


#define	FIFO_BYPASS_REG_PAR	0x65	/* Bypass register parity byte	      */
/*	bit 7 = AUX_OUTPUT_PARITY pin read back
	bit 6 = BYPASS_PENDING pin read back
	bit 5 = Bypass register valid bit read back
	bit 4 = parity from byte 4
	bit 3 = parity from byte 3
	bit 2 = parity from byte 2
	bit 1 = parity from byte 1
	bit 0 = parity from byte 0
*/

#define	FIFO_IN_PAR_GEN_ODD	0x95	/* input parity generate control reg  */
#define GEN_ODD_INP_PAR4		0x10	/* generate  odd input        */
#define GEN_ODD_INP_PAR3		0x08	/* parity in byte X           */
#define GEN_ODD_INP_PAR2		0x04	/*                            */
#define GEN_ODD_INP_PAR1		0x02	/*                            */
#define GEN_ODD_INP_PAR0		0x01	/*                            */

#define	FIFO_IN_PAR_CK_ODD	0x96	/* input parity check odd control reg */
#define CHK_ODD_INP_PAR3		0x08	/* check odd input parity     */
#define CHK_ODD_INP_PAR2		0x04	/* in byte X                  */
#define CHK_ODD_INP_PAR1		0x02	/*                            */
#define CHK_ODD_INP_PAR0		0x01	/*                            */

#define	FIFO_READ_WRITE		0x97	/* read/write flags, cleared by reset */
#define IN_PAR_GEN_DIS			0x80	/* input parity gen disabled  */
#define	FRZ_IN_CNTR			0x20	/* freeze input counter	      */
#define FRZ_OUT_CNTR			0x10	/* freeze output counter      */
#define FLAG_HI_Z			0x04	/* high impedance output      */
#define READYAB_SYNC			0x02	/*                            */
#define FULLAB_SYNC			0x01	/* enable second sync stage   */

#define FIFO_MATCH_MASK_3	0x9e	/* match mask bits for byte 3         */
#define FIFO_MATCH_MASK_4	0x9f	/* match mask bits for byte 4         */

#define	FIFO_ADV_OUT_CNRT	0xc8	/* advance output counter	      */
#define	FIFO_RESET_CNTR		0xc0	/* reset the output counter	      */
#define	FIFO_VERSION		0xff	/* version code   should be 0	      */
