
#include "types.h"
#include "disp.h"
#include "spm.h"
#include "novram.h"
#include "globl.h"

extern uchar bdhere[];		/* slots for CSS board's... */
/*------------------------------------------------------------------------------
	ck_css_config : Check to see minimum and maximum configuration has
					been met.

			returns number of IOM boards in system for success
			returns 0xFF for failure.
------------------------------------------------------------------------------*/
ck_css_config()
{
	uchar i;
	uchar iobd = 0;
	uchar membd = 0;
	uchar iopbd = 0;

#ifdef	SPM_CONFIG
	uchar spmbd = 0;
	uchar pmbd = 0;
#endif

	for (i = 0; i != Sbus_Num_Slot; i++) {	/* loop through all slots. */
		/* if SOMETHING is here.. */
		if(bdhere[i] != NOBOARD) {
			switch(bdhere[i]& BDTYPEMASK)	{
				case IOMTYPE: 
					iobd++; 
					break;
				case IOPTYPE: 
					iopbd++; 
					break;
				case MEMTYPE: 
					membd++; 
					break;

#ifdef	SPM_CONFIG
				case SPMTYPE:
					spmbd++;
					break;
				case CPUTYPE:
					pmbd++;
					break;
				case DPMTYPE:
					pmbd+=2;
					break;
#endif
				default: 
					break;
			}
		}
	}

#ifdef DEBUG
	printf("\niobd = %x  iopbd = %x  membd = %x\n", iobd, iopbd, membd);
#endif

	if(membd == 0) {
		printf("\nNo memory board in the system\n");
		return(0xFF);
	}
	if(membd > 8) {
		printf("\nToo many memory boards in the system\n");
		return(0xFF);
	}
	if((iobd == 0) && (iopbd == 0)){
		printf("\nNo I/O board in the system\n");
		return(0xFF);
	}
	if(iobd > IOM_PER_SYS) {
		printf("\nToo many IOM boards in the system\n");
		return(0xFF);
	}

#ifdef	SPM_CONFIG
	if(spmbd != 1) {
		printf("\nToo many SPM boards in the system\n");
		return(0xFF);
	}
	if(pmbd == 0) {
		printf("\nNo PM board in the system\n");
		return(0xFF);
	}
	if(pmbd > 8) {
		printf("\nToo many PM boards in the system\n");
		return(0xFF);
	}
#endif

	return(iobd);
}

