# flp_xfer.s  does only xfers.
# Arete' floppy driver
# copyright 1987, Arete' Systems Inc.
#
#  890201       P. Lee, L. Lam, G. Ringel optimized xfer routines
#		to use polling for 1.2M.
#
#**********************************************************************

include(./head/top.h)

#	FLOPPY BASE VALUES 
# included for fdc's xfer.s
set FDBITS,0x7000022		# PAL lines, contrl reg. */

# Master Status Register Bits 
 
set	MSRMSK,0xc0
set	MSREXM,0x20		# Execution Mode. Low=result phase */
set	MSRCB,0x10		# FDC busy doing a READ/WRITE */
set	MSRDXB,0x0f		# FDD 0-3 busy, LSB=0. */
set	MSRcmd ,0x80		# command phase, need data from cpu */
set	MSRresp,0xc0		# response phase, data ready */
set	MSRrd,0xe0		# ready with read data */
set	MSRwr,0xa0		# ready for write data */

set	FD_SIS,0x08

set	EXM_LIMIT,0x1000
#
global st_isec
global e_isec
global rd_flp
global wr_flp
global expect_sk_int
global expect_rd_int
global expect_wr_int
global expect_fresult
global res_flp_int

text				# beginning

st_isec:			# label used for sizing floppy code
#
#	Subroutine rd_flp -- expects the global variables flp_buf
#			     and xfer_size to define the the xfer
#			     parameters.  Returns 0x00 for success
#			     and 0xFFFFFFFF for failure.
#
rd_flp:
	mov.l	%d0,-(%sp)
	mov.l	%a0,-(%sp)
#	mov.l	&0x00010000,flp_error	# DEBUG
	mov.l	flp_buf,%a0
	mov.b	DATA,(%a0)+
	mov.l	xfer_size,%d0
	sub.w	&1,%d0

# Read the MSR.  If bit 5 is low, execution has terminated and
# error data ( result data ) will probably follow.
rloop2:
#	mov.l	&0x00020000,flp_error	# DEBUG
	mov.b	MSR,%d1
	btst	&5,%d1			# test for executing bit. 
	beq.b	Rfail			# bit was low, not executing. Jump.
	bpl.b	rloop2			# check bit 7 (sign bit) this relies
					# on the mov above, do not add code
					# which will affect the N flag
# else still OK, now transfer the data

	mov.b	DATA,(%a0)+		# move the byte to memory
#	mov.l	%d0,flp_error		# DEBUG
	sub.w	&1,%d0			# decrement transfer counter
	beq.b	Rdone			# was what was moved a zero? (finished?)
	bra.b	rloop2			# go back to read data loop.

# Here, we're through with the transfer.
#  raise and lower TC so chip knows we're done.
Rdone:
#	mov.l	&0x00000000,flp_error	# DEBUG
	or.l	&0xFFFF0000,flp_int	# set flp_int and return
	mov.b	&0x30,FDBITS		# keep motor on and raise TC, lower DACK
	mov.l	%vbr,%a0
	mov.l	&fresult,0x78(%a0)
	jsr	delay3			# wait enough for the chip to see TC
	mov.b	&0x60,FDBITS		# Remove TC,DACK but leave the motor on.
	mov.l	(%sp)+,%a0
	mov.l	(%sp)+,%d0
	rte				# Passing exit

# to get here, must have gotten an interrupt during read but without
# the execute bit #5 set.  Therefore, data to follow is an error result.
Rfail:
#	lsl.l	&8,%d1			# DEBUG
#	lsl.l	&8,%d1			# DEBUG
#	lsl.l	&8,%d1			# DEBUG
#	or.l	flp_error, %d1		# DEBUG
#	mov.l	%d1,flp_error		# DEBUG
	or.l	&0xFFFF0000,flp_int	# set flp_int and return
	or.l	&0xFFFF0000,flp_err	# set flp_err and return
	mov.l	(%sp)+,%a0
	mov.l	(%sp)+,%d0
	rte				# Failing exit 


#
#	Subroutine wr_flp -- expects the global variables flp_buf
#			     and xfer_size to define the the xfer
#			     parameters.  Returns 0x00 for success
#			     and 0xFFFFFFFF for failure.
#
wr_flp:
	mov.l	%d0,-(%sp)
	mov.l	%a0,-(%sp)
#	mov.l	&0x00010000,flp_error	# DEBUG
	mov.l	flp_buf,%a0
	mov.b	(%a0)+,DATA
	mov.l	xfer_size,%d0
	sub.w	&1,%d0

# Read the MSR.  If bit 5 is low, execution has terminated and
# error data ( result data ) will probably follow.
wloop2:
#	mov.l	&0x00020000,flp_error	# DEBUG
	mov.b	MSR,%d1
	btst	&5,%d1			# test for executing bit. 
	beq.b	Wfail			# bit was low, not executing. Jump.
	bpl.b	wloop2			# check bit 7 (sign bit) this relies
					# on the mov above, do not add code
					# which will affect the N flag
# else still OK, now transfer the data

	mov.b	(%a0)+,DATA		# move the byte to memory
#	mov.l	%d0,flp_error		# DEBUG
	sub.w	&1,%d0			# decrement transfer counter
	beq.b	Wdone			# was what was moved a zero? (finished?)
	bra.b	wloop2			# go back to read data loop.

# Here, we're through with the transfer.
#  raise and lower TC so chip knows we're done.
Wdone:
#	mov.l	&0x00000000,flp_error	# DEBUG
	or.l	&0xFFFF0000,flp_int	# set flp_int and return
	mov.b	&0x30,FDBITS		# keep motor on and raise TC, lower DACK
	mov.l	%vbr,%a0
	mov.l	&fresult,0x78(%a0)
	jsr	delay3			# wait enough for the chip to see TC
	mov.b	&0x60,FDBITS		# Remove TC,DACK but leave the motor on.
	mov.l	(%sp)+,%a0
	mov.l	(%sp)+,%d0
	rte				# Passing exit

# to get here, must have gotten an interrupt during read but without
# the execute bit #5 set.  Therefore, data to follow is an error result.
Wfail:
#	lsl.l	&8,%d1			# DEBUG
#	lsl.l	&8,%d1			# DEBUG
#	lsl.l	&8,%d1			# DEBUG
#	or.l	flp_error, %d1		# DEBUG
#	mov.l	%d1,flp_error		# DEBUG
	or.l	&0xFFFF0000,flp_int	# set flp_int and return
	or.l	&0xFFFF0000,flp_err	# set flp_err and return
	mov.l	(%sp)+,%a0
	mov.l	(%sp)+,%d0
	rte				# Failing exit 

#  This delay forces execution since it won't fit in the pipe.
# a more elegant solution would be to make a memory access.
delay3:
	nop			# (2/2/3) clocks
	nop			# (2/2/3) clocks
	nop			# (2/2/3) clocks
	nop			# (2/2/3) clocks
	nop			# (2/2/3) clocks
	nop			# (2/2/3) clocks
	nop			# (2/2/3) clocks
	nop			# (2/2/3) clocks
	nop			# (2/2/3) clocks
	nop			# (2/2/3) clocks
	nop			# (2/2/3) clocks
	nop			# (2/2/3) clocks
	nop			# (2/2/3) clocks
	nop			# (2/2/3) clocks
	nop			# (2/2/3) clocks
	rts

expect_sk_int:
	mov.l	%vbr,%a0
	mov.l	&skint,0x78(%a0)
	rts

expect_rd_int:
	mov.l	%vbr,%a0
	mov.l	&rd_flp,0x78(%a0)
	rts

expect_wr_int:
	mov.l	%vbr,%a0
	mov.l	&wr_flp,0x78(%a0)
	rts

expect_fresult:
	mov.l	%vbr,%a0
	mov.l	&fresult,0x78(%a0)
	rts

res_flp_int:
	mov.l	%vbr,%a0
	mov.l	&jerror,0x78(%a0)
	rts

skint:					# expected interrupt
	mov.l	%d0,-(%sp)
	jsr	bdelay2
	mov.b	MSR,%d0			# read the Master Status Reg
	jsr	bdelay2
	mov.b	&FD_SIS,DATA		# Write SIS command
	jsr	bdelay2
	jsr	flp_cmd_complete
	tst.l	%d0
	bne.w	sk_res_fail
	or.l	&0xFFFF0000,flp_int	# set flp_int and return
	jsr	res_flp_int
	mov.l	(%sp)+,%d0
	rte

sk_res_fail:
	or.l	&0xFFFF0000,flp_int	# set flp_int and return
	or.l	&0xFFFF0000,flp_err	# show error and return
	jsr	res_flp_int
	mov.l	(%sp)+,%d0
	rte

fresult:
	mov.l	%d0,-(%sp)
	jsr	bdelay2
	jsr	flp_cmd_complete
	tst.l	%d0
	bne.w	res_fail
	or.l	&0x0000FFFF,flp_int
	jsr	res_flp_int
	mov.l	(%sp)+,%d0
	rte

res_fail:
	or.l	&0x0000FFFF,flp_err
	or.l	&0x0000FFFF,flp_int
	jsr	res_flp_int
	mov.l	(%sp)+,%d0
	rte

#***********************************
#  Function: adelay using DelCnt as loopcount
#
global bdelay2
bdelay2:
					# approx. 10 clocks/us
	mov.l	%d1,-(%sp)		# save d1
	mov.l	&DelCnt,%d1		# load count
adl1:
	nop				# (2/2/3) clocks
	tst.w	%d1			# Zero?
	dbeq	%d1,adl1		# do it DelCnt number of times (3/6/9)

	mov.l	(%sp)+,%d1	# get back d1
	rts			# (26/37/45) + (5/8/12) * cnt
				# yields b/c/w lapcounts of 47/28/18 for 26us


e_isec:					# label used for sizing floppy code
	bra	e_isec
