

/*
 * file: flp_result.c
 *		This file is responsible for processing the command. In the 
 *		case of rdsec, rdtrack, and wrsec this includes the actual
 *		data transfer.  At the completion of the execution phase,
 *		routines in this file will fill the flp_res structure
 *
 *  890819  Redo floppy driver 
 *
 *	flp.c		--  User interface
 *	flp_exec.c	--  Floppy command start
 *	flp_result.c	--  Process floppy command
 *	flp_check.c	--  Analyze floppy response
 *	flp_test.c	--  Floppy tests -- from i_flop_test menu
 *	head/flp.h	--  General defines used by all
 *	head/flp_chk.h  --  Floppy result checking include
 */

#include "types.h"
#include "flp.h"			/* definition of floppy command block */

extern	struct	flp_cmd	 flp_cmd;
extern	union	flp_res	 flp_res;
extern	uint flp_errors[];		/* error array */

extern	uchar	*flp_buf;		/* address used by read and write
					   commands.			*/

extern	uchar	flp_status;		/* Status returned by a sense drive
					   status command		*/

extern	uint	res_cnt;			/* number of bytes in the result
					   block.			*/

static	char	*recal_str = "RECAL";
static	char	*seek_str = "SEEK";

int	flp_cmd_complete();
/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
int
flp_cmd_complete()
{
	uint	timer = (uint)RES_TIMEOUT;
	uchar	*flp_resp = (uchar *)(&flp_res);
	uint	res_count = 0;
	
#ifdef	DEBUG
	printf ("flp_cmd_complete:  res_cnt:  %d; res_count:  %d.\n", 
			res_cnt, res_count);
#endif
	while ((res_count < res_cnt) && --timer) {

		if ((*MSR & MSRMSK) == MSRresp) {
			wait_cnt(10);
			flp_resp[res_count] = *DATA;
#ifdef	DEBUG
	printf ("flp_cmd_complete:  resp byte is %x.\n", flp_resp[res_count]);
#endif
			res_count++;
			timer  = RES_TIMEOUT;
		}
		else  {
			wait_cnt(10);
		}
	}

	if (!timer) {
		printf ("flp_cmd_complete:  Time-out waiting for results.\n");
		return(FLP_TIME);
	}

	return(0);
}


