
#include "icb.h"
#include "spm.h"
#include "devcmd.h"
#include "types.h"
#include "vreg.h"
#include "icb_config.h"
#include "rtb.h"
#include "misc.h"
#include "disp.h"


extern  char	lastblk;

static	struct	devq	devqq;
   
dtreq(dtreq_ptr)
struct	dtreq_call	*dtreq_ptr;
{
	uint memaddr;
	uint stat = 0;		/* used for status returns. */

	if (dtreq_ptr->memaddr & 0xf) {
		printf("Memory address: %x not on 16 byte boundary\n",
			dtreq_ptr->memaddr);
		return(0xff);
	}

	memaddr = (((unsigned)dtreq_ptr->mem_slot << 28) | 
					(dtreq_ptr->memaddr >> 4));

	devqq.q_devtype = dtreq_ptr->type;
	devqq.q_devnum = dtreq_ptr->drive;
	devqq.q_cmd = dtreq_ptr->command;
	devqq.q_count = dtreq_ptr->count;
	devqq.q_devun.block = dtreq_ptr->block;
	devqq.q_mem = memaddr;
	devqq.q_mmu = (struct mmu *)0;
	devqq.q_extdtb = XDDFLT;		/* use default dma */
	devqq.q_resrv[0] = 0;	/* clear all these out. */
	devqq.q_resrv[1] = 0;	/* clear all these out. */
	devqq.q_resrv[2] = 0;	/* clear all these out. */
	devqq.q_intrn[0] = 0;	/* clear all these out. */
	devqq.q_intrn[1] = 0;	/* clear all these out. */
	devqq.rc1 = 0;
	devqq.rc2 = 0;
	devqq.q_priority = 0;
	devqq.q_key = 0;
	devqq.q_flag = 0;

	
	if(dev_req(dtreq_ptr->icbp,&devqq) < 0) { /*  failed  */
		printf("%s drive:%2x",dtreq_ptr->type == DTDISK ? "Disk":"Tape",
			dtreq_ptr->drive); 
		return(-1); /* send back status. */
	}

	if(devqq.rc1 || devqq.rc2) { /* if either failed.. */
		stat = devqq.rc1 << 8;
		stat |= devqq.rc2;
		if((dtreq_ptr->type != DTTAPE) || !lastblk) { 
			printf("%s %2x access status: ",
				dtreq_ptr->type==DTDISK ? "Disk":"Tape", 
				dtreq_ptr->drive);
			prdtstat(&devqq.rc1);
		}
		return(stat &= 0xffff);	/* and return code. */
	}
	return(0);
}


char *dtstat[] = {
	"",				
	"bad system sector",
	"illegal command",
	"invalid sector number",
	"disk not formatted",
	"invalid system sector information",
	"drive not ready",
	"device check error",
	"no such logical drive",
	"drive out of range",
	"invalid device type",
	"illegal byte count",
	"skip track table full",
	"skip track error",
	"double alternate sector",
	"too many sectors",
	"alternate sector",
	"CRC error",
	"seek error",
	"drive ready change",
	"can't rezero",
	"not on cylinder",
	"header id error",
	"",
	"data overrun",
	"",
	"not writeable",
	"memory not long word boundary",
	"header search",
	"disk timeout",
	"bad gap length",
	"abnormal termination",
	"cartridge not in place",
	"drive not ready",
	"write protected",
	"end of media",
	"data error",
	"file mark detected",
	"no data",
	"8 retry",
	"beginning of media",
	"tape hangup",
	"drive was reset",
	"not on-line",
	"data overrun",
	"corrected error",
	"illegal archive command",
	"invalid io interface",
	"request aborted, due to ups",
	"no 9 track tape",
	"no burst id",
	"invalid density selection",
	"invalid speed selection",
	"invalid mode selection",
	"tape is busy with w/r",
	"invalid memory address",
	"invalid byte count",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"recover error",
	"medium error",
	"hardware error",
	"illegal request",
	"command aborted",
	"volume overflow",
	"miscmpr",
	"invalid length of request",
	"request past the end of disk",
	"failure of a scsi channel",
	"",
	"",
	"",
	"",
	"",
	"",
};
	
prdtstat(ptr)
uchar *ptr;
{
	register i;

	for(i = 0; i < 2; i++, ptr++) {
		if ((*ptr >= (sizeof(dtstat)/sizeof(char *))) || 
						(*dtstat[*ptr] == 0)) {
 			if(*ptr) 
				printf("rc%d = $2x   ",i+1,*ptr);
			continue;
		}
		printf("%s   ",dtstat[*ptr]);
	}
	putchar('\n');
}

