#include "spm.h"
#include "global.h"
#include "types.h"
#include "ascc.h"
#include "misc.h"
#include "filehdr.h"
#include "scnhdr.h"
#include "aouthdr.h"
#include "a.out.h"
/*
 * 	RECEIVE
 *		an xmodem protocol receiver program. Only gets a file
 *		in binary format, CRC.
 *		19.2K buad rate and 1K data block
*/


#define TRUE            1               
#define FALSE           0
#define CNT_Z		0x1A	/* continue the download process */
#define CNT_D		0x04	/* Exit from download and back to monitor */
#define CNT_Q		0x04	/* Enable transmission from host computer */
#define CNT_S		0x11	/* Stop transmission from host computer */
#define CNT_C		0x03
#define SOH             001
#define EOT             004
#define ACK             006
#define LF              012     /* Unix LF/NL */
#define CR              015
#define NAK             025
#define CAN             030
#define TIMEOUT         -1
#define ERRORMAX        10      /* maximum errors tolerated */
#define RETRYMAX        10      /* maximum retries to be made */
#define BBUFSIZ         1024     /* buffer size -- do not change! */
#define BITMASK		0xff	/* removes extra bits from int */
#define iqsize		1024

/*  UMODEM Constants  */
#define		 CRCCHR		'C'	/* CRC request character */
/*
** CRC-16 constants:
*/
/* the CRC polynomial. */
#define P	0x1021
/* number of bits in CRC */
#define W	16
/* number of bits per char */
#define B	8

#define BUFPOINT 0x103e000

extern uchar *buff;
extern ushort crctab[];		/* crctab as calculated by initcrctab() */
extern char comm_args[][MAXARGSIZE];

static char 	*tail, *head;
static char	input_q[iqsize];
static char	newdnld;
static int	delay = 3;

#define loadpoint	0x1000000
#define oloadpoint	0x100ff08

struct fhdr {
	FILHDR filhdr;
	AOUTHDR saouthdr;
	SCNHDR sctnhdr[6];
};


dnfile1(singdnld)	/* this does the download. */
int singdnld;
{
	unsigned long *ptr; /* clear memory, before downloading. */

/* Here, we can clear all of memory, since if it fails, it will return
   and start the monitor over again (which re-initilizes memory).  Needed
   by the OS group.
*/
	for(ptr = (unsigned long *)0x1000000; ptr < (unsigned long *)0x103a000;)
		*ptr++ = 0;	/* clear's all of the bss stuff. */
	if(rfile((char *)0, singdnld))	/* sigh.. it failed downloads. */
	{
		if(!singdnld)
			printf("Download failed.\n\r");
		return(1); /* returns to local monitor only. */
	}
	if(!singdnld)
		printf("\rDownload complete.\n\r");
	return(0);	 /* tell program ok to execute. */
}


/**  receive a file  **/
rfile(bufferadd, singdnld)
uchar *bufferadd;
int singdnld;
{
	uchar *mem=bufferadd;	/* pointer to memory on char array */
	register struct scnhdr *scnptr;
	register struct fhdr *fhptr;
	int j, firstchar, sectnum=0, sectcurr;
	int sectcomp, errors=0, errorflag;
	register int bufctr, checksum;
	register int c, firstsec=0;
	int fatalerror=FALSE, inchecksum;
	int             cnt;

	sendbyte(CRCCHR, singdnld);	/* CRC startup, in place of NAK. */
	do
	{   
		errorflag = FALSE;	/* clear errors. */
		do {
			firstchar = readbyte(6, singdnld); /* wait for char. */
		} while ((firstchar != SOH) && (firstchar != EOT)
				&& (firstchar != TIMEOUT));
		if (firstchar == TIMEOUT)	/* timed out.. next loop.*/
			errorflag = TRUE;

		if (firstchar == SOH)	/* if char was SOH byte, start block. */
		{
			sectcurr = readbyte(delay, singdnld); /* get blk # */
			sectcomp = readbyte(delay, singdnld); /*inverse blk # */

			if ((sectcurr + sectcomp) == BITMASK) /* BYTE Addition*/
			{ /* now check that this is the block you wish..*/
			      if (sectcurr == (((sectnum + 1) % 256) & BITMASK))
				{
					checksum = 0;
					bufctr = 0;
					for (j = 0; j < BBUFSIZ; j++)
					{
						c = readbyte(delay, singdnld);
						buff[bufctr] = (char)c;
checksum = (checksum<<8) ^ crctab[((((checksum>>(8))&0x00ff) ^ (c & 0x00ff))&0x00ff)];
						bufctr++;
					}
					checksum &= 0xffff;	/* strip it.*/
					inchecksum = readbyte(3, singdnld);
					/* get 16 bit CRC */
					inchecksum = ((inchecksum<<8) | readbyte(3, singdnld)) & 0xffff;
					if (checksum == inchecksum)  
					/* good checksum */
					{
						errors = 0;
						sectnum = sectcurr;  /* update sector counter */
						if(!firstsec && !mem) 
						/* if the first sector */
						{
							firstsec++;	/* never go here twice. */
							fhptr = (struct fhdr *)buff; /* always here now.*/
							if(fhptr->filhdr.f_magic == A68020MAGIC)
							{
								scnptr=fhptr->sctnhdr;
								cnt = scnptr->s_scnptr;	/* set buffer point. */
								if(!mem) /* it's null,so get from file */
									mem = (unsigned char *)scnptr->s_paddr;
							}
							else
								cnt = 0;
							for(; cnt < BBUFSIZ; cnt++)
								*mem++ = buff[cnt];	/* put it in memory..*/
						}
						else
							for(cnt = 0; cnt < BBUFSIZ; cnt++)
								*mem++ = buff[cnt];	/* put it in memory..*/
						*mem = 0; /* make sure it's cleared out for getmac */
						if(!singdnld)
							putline("\r%03d", sectcurr); /* */
						sendbyte(ACK, singdnld);	/* got a good block now. */
						signal(sectnum);
					}
					else
					{
						errorflag = TRUE; /* checksum failed.. bad block. */
 					}
				}
				else
				{ /* if this is the same block we got a second ago, it's ok.*/
				    if (sectcurr == ((sectnum % 256) & BITMASK))
					{	/* wait until end of block, then just ack it. */
						while(readbyte(3, singdnld) != TIMEOUT);
						if(!singdnld) /*no printf's in dnld.*/
							putline("duplicate sector.\n\r");
						sendbyte(ACK, singdnld); /* note: we just dump the data. */
					}
					else /*if not previous block, not this block, then bad.*/
					{
						if(!singdnld) /*no printf's in dnld.*/
							putline("Fatal error \n\r"); /*no prints in dnld.*/
						errorflag = TRUE;
						fatalerror = TRUE;	/* abort transfer. */
						sendbyte(CAN, singdnld);	/* show sender we died. */
					}
				}
			}
			else /* block number and inverse block number bad. */
			{ /* set error to ignore the block. */
				errorflag = TRUE;
			}
		}
		if (errorflag == TRUE)
		{
			errors++;	/* show we had an error. */
			while (readbyte(3, singdnld) != TIMEOUT);	/* wait until bytes stop. */
			sendbyte(NAK, singdnld);	/* tell sender we failed block read. */
		}
	} while ((firstchar != EOT) && (errors != ERRORMAX) && !fatalerror);
	sendbyte(ACK, singdnld);
	if ((firstchar == EOT) && (errors < ERRORMAX))
		return(0);	/* ok. If here, we are all done!  */
	else /* errors were to much for us, then give up and return to the monitor*/
		return(1);
}

/* get a byte from channel 1 -- timeout if "seconds" elapses */
/*      NOTE, however, that this function returns an INT, not a BYTE!!!  */
readbyte(seconds, singdnld)
unsigned        seconds;
int	singdnld;
{
	int     count,c;
	register struct ascc *sccbptr;

	if(singdnld)
		sccbptr = AUXASCC0A;
	else
		sccbptr = AUXASCC0B;
	count = seconds * 0x10000;
	while(1)	{
		if(sccbptr->reg[0].reg & RR0_RX) { 	/* data available */
			c = sccbptr->reg[8].reg; 	/* read it */
			break;
		}
		else	{
			if (count) {
				count--;
			}
			else
				break;
		}
	}
	if (count == 0)
		return(TIMEOUT);
	else
		return(c & BITMASK);  		/* return data, 8 bits. */
}


/* send a byte to channel 1 */
sendbyte(data, singdnld)
char    data;
int	singdnld;
{
	char    dataout;
	register struct ascc *sccbptr;

	if(singdnld) /* using chan a instead. */
		sccbptr = AUXASCC0A;
	else /* normal channel for download. */
		sccbptr = AUXASCC0B;
	dataout = data & BITMASK;	/* only send one byte. */
	while(!(sccbptr->reg[0].reg & RR0_TX) )
		;
	sccbptr->reg[8].reg = dataout; /* sent one byte */
	return;
}

dnld(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	unsigned *ptr = (unsigned *)0x103e000; /* point to buffer. */
	unsigned char *ovptr;
	unsigned char *addr; /* point to buffer. */
	int singdnld=0;

	if(*(comm_str) == 'o') /* if this is "newboot" command. */
	{
		newdnld=0; /* show doing old one. */
		comm_str++;	/* and don't blow the rest of compares. */
	}
	else
		newdnld = 1;	/* make sure it's new stuff. */

	if(*(comm_str) == 'S') /* if this is a SINGLE download. */
		singdnld = 1;	/* now, do single port download. */
	else
		singdnld = 0;	/* do double port download. */

	if(arg_cnt)
		if(newdnld)
			*ptr = (unsigned)atox(comm_args[1]); /* user jump point. */
		else
			addr = (unsigned char *)atox(comm_args[1]); /* user jump point. */
	else
		if(newdnld)
			*ptr = (unsigned)0x1000400;	/* normal jump point. */
		else
			addr = (unsigned char *)0x1010400; /* normal jump point. */

	if(newdnld)
		ovptr = (unsigned char	*)(loadpoint);
	else
		ovptr = (unsigned char	*)(oloadpoint);

	head = tail = input_q;
	if (singdnld || connect())	/* if request is complete: */
	{
		if(newdnld)	/* if using new stuff. */
			dnfile(singdnld); /* do the download (in prom), never comes back. */
		else
		{
			if(!rfile(ovptr, singdnld)) /* it passed.. */
			{
				printf("\rDownload completed.\n");
				if(load_sections(ovptr)) /* failed magic #. */
					return; 
				(*(PFI)addr)(); /* go jump to program. */
			}
			else
				printf("Download failed.\n");
		}
	}
}

/*
	Set up connection with host computer 
*/
connect()
{
	int     c;

	while (1) {
		if (( c = keyin(0) ) != -1)
		{
			if ( c == CNT_C ) 	/* abort it */
				return(0);
			if ( c == CNT_Z )	/* continue download */
				return(1);
			keyout(c,1);
		}
		if (( c = keyin(1) ) != -1)
		{
			keyout(c,0);
		}
	}
}

signal(num)
unsigned num;
{
	if(num & 1)
		*WRCNTL2 = *WRCNTL2 & ~WR2_GRNLED; 
	else
		*WRCNTL2 = *WRCNTL2 | WR2_GRNLED;
}
	

keyin(port)
char        port;
{
	int     c;
	register struct ascc *sccaptr = AUXASCC0A;

	if ( port == 0 )	{
		if(sccaptr->reg[0].reg & RR0_RX) { 	/* data available */
			c = sccaptr->reg[8].reg; 	/* read it */
			return(c & BITMASK);  		/* return data 8 bits */
		}
		else	{
			return(-1);
		}
	}
	if ( port == 1 )	{
		ringin();
		if (head != tail)	{
			c = (*head++);
			if ( head == &input_q[sizeof input_q])
				head = input_q;
			return(c & BITMASK);
		}
		else	{
			return(-1);
		}
	}
}

/* send one byte data to a port */
keyout(data,port)
char        port;
int    data;
{
	char    dataout;
	register struct ascc *sccaptr = AUXASCC0A;
	register struct ascc *sccbptr = AUXASCC0B;

	dataout = (char)data & BITMASK;	/* only send one byte. */
	if ( port == 0 )	{
		while(!(sccaptr->reg[0].reg & RR0_TX) )
			ringin();
		sccaptr->reg[8].reg = dataout; /* sent one byte to channel 0 */
	}
	if ( port == 1 )	{
		while(!(sccbptr->reg[0].reg & RR0_TX) )
			;
		sccbptr->reg[8].reg = dataout; /* sent one byte to channel 1 */
	}
		return;
}

ringin()
{
	char	c;
	register struct ascc *sccbptr = AUXASCC0B;

	if(sccbptr->reg[0].reg & RR0_RX) { 
		c = sccbptr->reg[8].reg; 
		*tail++ = c;
		if ( tail == &input_q[sizeof input_q])
			tail = input_q;
	}
}

load_sections(object_ptr) /* old code, to insure boot still works for now. */
unsigned char *object_ptr;
{
	register struct scnhdr *scnptr;
	register struct fhdr *fhptr;
	char *loadptr,*fptr;
	register i,ssize;

	fhptr = (struct fhdr *)object_ptr;
	if(fhptr->filhdr.f_magic != A68020MAGIC)
	{
		printf("Invalid magic number: %4x\n",fhptr->filhdr.f_magic);
		return(1);
	}
	scnptr=fhptr->sctnhdr;
	for(i=0; i<fhptr->filhdr.f_nscns; i++,scnptr++)
	{
		loadptr = (char *)scnptr->s_paddr;
		fptr = (char *)((uint)scnptr->s_scnptr + (uint)object_ptr);
		for(ssize=0; ssize<scnptr->s_size; ssize++,loadptr++,fptr++) 
			*loadptr = *fptr;
	}
	return(0);
}

putline(fmt, args) /* print a line, without using ram other than stack. */
char *fmt;
int args;
{
	printf (fmt, args);
}

