# vector.s
# exception vector routines

include(./head/top.h)

text

global	AutoVec1
global	AutoVec2
global	AutoVec3
global	AutoVec4
global	AutoVec5
global	AutoVec6
global	AutoVec7
global	AutoVec
global	AVx
global	LCIOerr
global	LCIOt3int
global	LCIOt2int
global	LCIOt1int
global	BusError
global	wr_emulate
global	size1
global	size2
global	size3
global	rd_emulate
global	r_size1
global	r_size2
global	r_size3
global	back
global	more_berr
global	return
global	BE
global	BadInst
global	BI
global	ZeroDivide
global	ZD
global	PrivError
global	PE
global	AddressError
global	AE
global	FormatError
global	FE
global	BadExcept
global	Chkinstru
global	Trapv
global	Line1010em
global	Line1111em
global	Unasint
global	Cproviol
global	Uninitint
global	Unassign
global	Spurint
global	TraceIn
global	Trap0
global	Trap3
global	Trap4
global	Trap5
global	Trap7
global	Trap8
global	Trap9
global	Trap10
global	Trap11
global	Trap12
global	Trap13
global	Trap15
global	FPCP_bosu
global	FPCP_inex
global	FPCP_zdiv
global	FPCP_uflow
global	FPCP_operr
global	FPCP_ovflw
global	FPCP_snan
global	PMMU_conf
global	PMMU_illop 
global	PMMU_aviol
global	Userdef
global	BEX
global	Xtx0a%
global	Xtx0b%
global	Xtx1a%
global	Xtx1b%
global	transint%
global	Xrx0a%
global	Xrx0b%
global	Xrx1a%
global	Xrx1b%
global	recvint%
global	Xex0a%
global	Xex0b%
global	Xex1a%
global	Xex1b%
global	exstint%
global	Xsp0a%
global	Xsp0b%
global	Xsp1a%
global	Xsp1b%
global	specint%
global	Xporta0%
global	Xporta1%
global	Xporta2%
global	Xporta3%
global	Xporta4%
global	Xporta5%
global	Xporta6%
global	Xporta7%
global	portaint0%
global	portaint1%
global	Xportb0%
global	Xportb1%
global	Xportb2%
global	Xportb3%
global	Xportb4%
global	Xportb5%
global	Xportb6%
global	Xportb7%
global	portbint%
global	Xctcerr%
global	Xctc1%
global	Xctc2%
global	Xctc3%
global	ctint%
global	Trap1
global	Trap2
global	Trap6
global	Trap14
global jerror


#-------------------------------------------------------------------------------
#
# 		Interrupt Routines 
#
#-------------------------------------------------------------------------------

AutoVec1:
	mov.l	&1,-(%sp)
	bra.b	AutoVec

AutoVec2:
	mov.l	&2,-(%sp)
	bra.b	AutoVec

AutoVec3:
	mov.l	&3,-(%sp)
	bra.b	AutoVec

AutoVec4:
	mov.l	&4,-(%sp)
	bra.b	AutoVec

AutoVec5:
	mov.l	&5,-(%sp)
	bra.b	AutoVec

AutoVec6:
	mov.l	&6,-(%sp)
	bra.b	AutoVec

AutoVec7:
	mov.l	&7,-(%sp)

AutoVec:
	movm.l	&A0S+A1S+D0S+D1S,-(%sp)	# Save the scratch registers
	jsr	autoint			# go high level
	movm.l	(%sp)+,&A0R+A1R+D0R+D1R	# Restore them
	addq.l	&4,%sp			# Throw away int number
	rte
AVx:
	addq.l	&4,%sp			# Adjust stack
	jmp	mon_start

LCIOerr:
	movm.l	&A0S+A1S+D0S+D1S,-(%sp)	# Save the scratch registers
	jsr	LCIO_err
	movm.l	(%sp)+,&A0R+A1R+D0R+D1R	# Restore them
	rte
LCIOt3int:
	bra	BadExcept
LCIOt2int:
	bra	BadExcept
LCIOt1int:
	movm.l	&A0S+A1S+D0S+D1S,-(%sp)	# Save the scratch registers
	jsr	LCIOt1_int	
	movm.l	(%sp)+,&A0R+A1R+D0R+D1R	# Restore them
	rte

#-------------------------------------------------------------------------------
# Bus error interrupts vector to here 
#-------------------------------------------------------------------------------
BusError:
	mov.b	&0x1,got_berr		# Got it...
	tst.b	emulate			# Do we want to emulate bus error ?
	beq.w	more_berr
	subq.l	&4,%sp
	mov.l	%a0,(%sp)		# Save a0
	subq.l	&4,%sp
	mov.l	%d0,(%sp)		# Save d0
	subq.l	&4,%sp
	mov.l	%d1,(%sp)		# Save d1
	mov.w	(0x16.w,%sp),%d0	# Get the ssw
	and.w	0x0040,%d0		# check for read/write bus error
	beq.w	rd_emulate
wr_emulate:
	mov.l	(0x1c.w,%sp),%d0	# Get access address
	lea.l	buff,%a0		# fake address
	mov.l	(0x24.w,%sp),%d0	# Get data from data output buffer
	mov.w	(0x16.w,%sp),%d1	# Get the ssw to check size
	and.w	&0x0030,%d1		# mask off size
	cmp.w	%d1,&0x0000		# long word
	bne.b	size1			# check the rest size
	mov.l	%d0,(%a0)		# write long word to fake address
	bra	back
size1:
	cmp.w	%d1,&0x0030		# 3 byte
	bne.b	size2			# check the rest size
	mov.l	%d0,(%a0)		# write long word to fake address
	bra	back
size2:
	cmp.w	%d1,&0x0020		# word
	bne.b	size3			# check the rest size
	mov.w	%d0,(%a0)		# write word to fake address
	bra	back
size3:
	mov.b 	%d0,(%a0)		# write byte to fake address
	bra	back
rd_emulate:
	mov.l	(0x1c.w,%sp),%d0	# Get access address
	lea.l	buff,%a0		# fake address
	mov.w	(0x16.w,%sp),%d1	# Get the ssw to check size
	and.w	&0x0030,%d1		# mask off size
	cmp.w	%d1,&0x0000		# long word
	bne.b	r_size1			# check the rest size
	mov.l	(%a0),%d0		# read from fake address
	mov.l	%d0,(0x38.w,%sp)	# Put fake data into data input buffer
	bra	back
r_size1:
	cmp.w	%d1,&0x0030		# 3 byte
	bne.b	r_size2			# check the rest size
	mov.l	(%a0),%d0		# read from fake address
	mov.l	%d0,(0x38.w,%sp)	# Put fake data into data input buffer
	bra	back
r_size2:
	cmp.w	%d1,&0x0020		# word
	bne.b	r_size3			# check the rest size
	mov.w	(%a0),%d0		# read from fake address
	mov.w	%d0,(0x38.w,%sp)	# Put fake data into data input buffer
	bra	back
r_size3:
	mov.b	(%a0),%d0		# read from fake address
	mov.b	%d0,(0x38.w,%sp)	# Put fake data into data input buffer
	bra	back
back:
	mov.w	(0x16.w,%sp),%d0	# Get the ssw again
	and.w	&0xfeff,%d0		# clear re-run flag in ssw
	mov.w	%d0,(0x16.w,%sp)	# Replace the ssw
	mov.l	(%sp),%d1		# Restore d1
	addq.l	&4,%sp
	mov.l	(%sp),%d0		# Restore d0
	addq.l	&4,%sp
	mov.l	(%sp),%a0		# Restore a0
	addq.l	&4,%sp
	bra	return
more_berr:
	subq.l	&2,%sp			# Align stack so C understands this
	movm.l	&0xffff,-(%sp)		# Move all registers onto stack
	jsr	buserr
	cmp.b	%d0,&0x00		# Go to monitor if buserr return 
					# non-zero else repeat buserr
	movm.l	(%sp)+,&0xffff		# Restore
	bne.b	BE			# Skip if enter monitor
	addq.l	&2,%sp			# Adjust stack
return:
	rte		
BE:
	addq.l	&2,%sp			# Adjust stack
	jmp	mon_start



#-------------------------------------------------------------------------------
# Bad instruction error interrupts vector to here 
#-------------------------------------------------------------------------------
BadInst:
	subq.l	&2,%sp			# Make the pushed SR a long for "C" jsr 
	movm.l	&0xffff,-(%sp)		# To print all the regs
	jsr	badinst			# Go high level
	cmp.b	%d0,&0x00		# Go to monitor if non-zero 
	movm.l	(%sp)+,&0xffff		# Restore
	bne.b	BI			# Skip if enter monitor
	addq.l	&2,%sp			# Adjust stack
	rte		
BI:
	addq.l	&2,%sp			# Adjust stack
	jmp	mon_start

#-------------------------------------------------------------------------------
# Zero divide error interrupts vector to here 
#-------------------------------------------------------------------------------
ZeroDivide:
	subq.l	&2,%sp			# Make the pushed SR a long for "C" jsr 
	movm.l	&0xffff,-(%sp)		# To print all the regs
	jsr	zerodivide		# Go high level
	cmp.b	%d0,&0x00		# Go to monitor if non-zero 
	movm.l	(%sp)+,&0xffff		# Restore
	bne.b	ZD			# Skip if enter monitor
	addq.l	&2,%sp			# Adjust stack
	rte		
ZD:
	addq.l	&2,%sp			# Adjust stack
	jmp	mon_start


#-------------------------------------------------------------------------------
# Privilege violation error interrupts vector to here 
#-------------------------------------------------------------------------------
PrivError:
	subq.l	&2,%sp			# Make the pushed SR a long for "C" jsr 
	movm.l	&0xffff,-(%sp)		# To print all the regs
	jsr	priverror		# Go high level
	cmp.b	%d0,&0x00		# Go to monitor if non-zero 
	movm.l	(%sp)+,&0xffff		# Restore
	bne.b	PE			# Skip if enter monitor
	addq.l	&2,%sp			# Adjust stack
	rte		
PE:
	addq.l	&2,%sp			# Adjust stack
	jmp	mon_start

#-------------------------------------------------------------------------------
# Address error interrupts vector to here 
#-------------------------------------------------------------------------------
AddressError:
	subq.l	&2,%sp			# Make the pushed SR a long for "C" jsr 
	movm.l	&0xffff,-(%sp)		# To print all the regs
	jsr	addresserror		# Go high level
	cmp.b	%d0,&0x00		# Go to monitor if non-zero 
	movm.l	(%sp)+,&0xffff		# Restore
	bne.b	AE			# Skip if enter monitor
	addq.l	&2,%sp			# Adjust stack
	rte		
AE:
	addq.l	&2,%sp			# Adjust stack
	jmp	mon_start

#-------------------------------------------------------------------------------
# format error interrupts vector to here 
#-------------------------------------------------------------------------------
FormatError:
	subq.l	&2,%sp			# Make the pushed SR a long for "C" jsr 
	movm.l	&0xffff,-(%sp)		# To print all the regs
	jsr	formaterror		# Go high level
	cmp.b	%d0,&0x00		# Go to monitor if non-zero 
	movm.l	(%sp)+,&0xffff		# Restore
	bne.b	AE			# Skip if enter monitor
	addq.l	&2,%sp			# Adjust stack
	rte		
FE:
	addq.l	&2,%sp			# Adjust stack
	jmp	mon_start

#-------------------------------------------------------------------------------
# Bad exception interrupts vector to here 
#-------------------------------------------------------------------------------
BadExcept:
Chkinstru:
Trapv:
Line1010em:
Line1111em:
Unasint:
Cproviol:
Uninitint:
Unassign:
Spurint:
TraceIn:
Trap0:
Trap3:
Trap4:
Trap5:
Trap7:
Trap8:
Trap9:
Trap10:
Trap11:
Trap12:
Trap13:
Trap15:
FPCP_bosu:
FPCP_inex:
FPCP_zdiv:
FPCP_uflow:
FPCP_operr:
FPCP_ovflw:
FPCP_snan:
PMMU_conf:
PMMU_illop: 
PMMU_aviol:
Userdef:
	subq.l	&2,%sp			# Make the pushed SR a long for "C" jsr 
	movm.l	&0xffff,-(%sp)		# To print all the regs
	jsr	badexcept		# Go high level
	cmp.b	%d0,&0x00		# Go to monitor if non-zero 
	movm.l	(%sp)+,&0xffff		# Restore
	bne.b	BEX			# Skip if enter monitor
	addq.l	&2,%sp			# Adjust stack
	rte		
BEX:
	addq.l	&2,%sp			# Adjust stack
	jmp	mon_start

#-------------------------------------------------------------------------
#handle our scc transmitter interrupt vectors
#save registers a0, a1, d0, d1, and jump to C code
#-------------------------------------------------------------------------

Xtx0a%:
	mov.l	&0,-(%sp)
	bra.b	transint%
Xtx0b%:
	mov.l	&1,-(%sp)
	bra.b	transint%
Xtx1a%:
	mov.l	&2,-(%sp)
	bra.b	transint%
Xtx1b%:
	mov.l	&3,-(%sp)
transint%:
	movm.l	&0xc0c0,-(%sp)	#save some registers
	jsr	txint
	movm.l	(%sp)+,&0x0303	#restore our registers
	addq.l	&4,%sp		#throw away interrupt number
	rte

#handle our scc receiver interrupt vectors
#save registers a0, a1, d0, d1, and jump to C code

Xrx0a%:
	mov.l	&0,-(%sp)
	bra.b	recvint%
Xrx0b%:
	mov.l	&1,-(%sp)
	bra.b	recvint%
Xrx1a%:
	mov.l	&2,-(%sp)
	bra.b	recvint%
Xrx1b%:
	mov.l	&3,-(%sp)
recvint%:
	movm.l	&0xc0c0,-(%sp)	#save some registers
	jsr	rxint
	movm.l	(%sp)+,&0x0303	#restore our registers
	addq.l	&4,%sp		#throw away interrupt number
	rte

#handle our scc external/status interrupt vectors
#save registers a0, a1, d0, d1, and jump to C code

Xex0a%:
	mov.l	&0,-(%sp)
	bra.b	exstint%
Xex0b%:
	mov.l	&1,-(%sp)
	bra.b	exstint%
Xex1a%:
	mov.l	&2,-(%sp)
	bra.b	exstint%
Xex1b%:
	mov.l	&3,-(%sp)
exstint%:
	movm.l	&0xc0c0,-(%sp)	#save some registers
	jsr	exint
	movm.l	(%sp)+,&0x0303	#restore our registers
	addq.l	&4,%sp		#throw away interrupt number
	rte

#handle our scc special interrupt vectors
#save registers a0, a1, d0, d1, and jump to C code

Xsp0a%:
	mov.l	&0,-(%sp)
	bra.b	specint%
Xsp0b%:
	mov.l	&1,-(%sp)
	bra.b	specint%
Xsp1a%:
	mov.l	&2,-(%sp)
	bra.b	specint%
Xsp1b%:
	mov.l	&3,-(%sp)
specint%:
	movm.l	&0xc0c0,-(%sp)	#save some registers
	jsr	spint
	movm.l	(%sp)+,&0x0303	#restore our registers
	addq.l	&4,%sp		#throw away interrupt number
	rte

#-------------------------------------------------------------------------
#handle our cio port A bit interrupt vectors
#save registers a0, a1, d0, d1, and jump to C code
#-------------------------------------------------------------------------
Xporta0%:
	mov.l	&0,-(%sp)
	bra.b	portaint0%
Xporta1%:
	mov.l	&1,-(%sp)
	bra.b	portaint1%
Xporta2%:
	mov.l	&2,-(%sp)
	bra.b	portaint0%
Xporta3%:
	mov.l	&3,-(%sp)
	bra.b	portaint0%
Xporta4%:
	mov.l	&4,-(%sp)
	bra.b	portaint0%
Xporta5%:
	mov.l	&5,-(%sp)
	bra.b	portaint0%
Xporta6%:
	mov.l	&6,-(%sp)
	bra.b	portaint0%
Xporta7%:
	mov.l	&7,-(%sp)

portaint0%:
	movm.l	&0xc0c0,-(%sp)	#save some registers
	jsr	pportaint0
	movm.l	(%sp)+,&0x0303	#restore our registers
	addq.l	&4,%sp		#throw away interrupt number
	rte

portaint1%:
	movm.l	&0xc0c0,-(%sp)	#save some registers
	jsr	pportaint1
	movm.l	(%sp)+,&0x0303	#restore our registers
	addq.l	&4,%sp		#throw away interrupt number
	rte

#handle our cio port B bit interrupt vectors
#save registers a0, a1, d0, d1, and jump to C code

Xportb0%:
	mov.l	&0,-(%sp)
	bra.b	portbint%
Xportb1%:
	mov.l	&1,-(%sp)
	bra.b	portbint%
Xportb2%:
	mov.l	&2,-(%sp)
	bra.b	portbint%
Xportb3%:
	mov.l	&3,-(%sp)
	bra.b	portbint%
Xportb4%:
	mov.l	&4,-(%sp)
	bra.b	portbint%
Xportb5%:
	mov.l	&5,-(%sp)
	bra.b	portbint%
Xportb6%:
	mov.l	&6,-(%sp)
	bra.b	portbint%
Xportb7%:
	mov.l	&7,-(%sp)
portbint%:
	movm.l	&0xc0c0,-(%sp)	#save some registers
	jsr	pportbint
	movm.l	(%sp)+,&0x0303	#restore our registers
	addq.l	&4,%sp		#throw away interrupt number
	rte

#handle our cio timer interrupt vectors
#save registers a0, a1, d0, d1, and jump to C code
#note: funnel all vectors to one routine - read vector register for status

Xctcerr%:
#	movl	#0,sp@-
#	bras	ctint
Xctc1%:
#	movl	#1,sp@-
#	bras	ctint
Xctc2%:
#	movl	#2,sp@-
#	bras	ctint
Xctc3%:
#	movl	#3,sp@-
ctint%:
	movm.l	&0xc0c0,-(%sp)	#save some registers
	jsr	ctint
	movm.l	(%sp)+,&0x0303	#restore our registers
#	addql	#4,sp		#throw away interrupt number
	rte

Trap1:
	jsr		load_icb_run	# Do the relocation and execute. (never return)
	jsr		promstart	# Restart prom code if we are here.
	rte
Trap2:
	jsr		load_iopm_run	# Do the relocation and execute. (never return)
	jsr		promstart	# Restart prom code if we are here.
	rte
Trap6:
	jsr		PrintStr
	rte
	
# used to return to system state from user
Trap14:
	or.w	&0x2000,(%sp)		# System flag 
	rte

# Remember: if you read DATA when none's available, you have to do
# a MSR,DATA pair until bit 6 of MSR goes low.
jerror:
	movm.l	&D0S+D1S,-(%sp)	# save some registers
	mov.l	&0x20,%d1	# load a count.
	jsr		adelay2		# TP kludge
	mov.b	MSR,%d0		# read the status. Must do one lap to clear int.
jerr1:
	jsr		adelay2		# wait for a bit
	mov.b	DATA,%d0		# get the data.
	jsr		adelay2		# wait for a bit
	sub.l	&1,%d1			# decrement the count
	beq.b	jerrxit			# leave if exhausted
	btst	&6,MSR			# is there data to be read?
 	bne.b	jerr1			# yes, read the data. Go back again.
jerrxit:
	movm.l	(%sp)+,&D0R+D1R		# get back the saved registers
	rte

