
/*------------------------------------------------------------------------------
		switches.c
------------------------------------------------------------------------------*/

#include "types.h"
#include "spm.h"
#include "global.h"
#include "misc.h"
#include "version.h"
#include "rwi.h"
#include "rwicio.h"
#include "novram.h"

extern	char	comm_args[][MAXARGSIZE];
extern	uchar	MemSimFlag;
extern	uint	to_css;	/* if set to a value, used for clock switching status */
extern	uchar	printer_on;
extern	uchar	modem_on;

/*	MUST match values in head/top.h   */
#define	CSS_CL_FLAG	0xACE0ACE1
#define	LOC_CL_FLAG	0xDBC0BB23
/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
mem_simulate()
{
	if(!strcmp (comm_args[1], "on")) {
		MemSimFlag = TRUE;
		*WRCNTL1 &= ~WR1_DIAG_ANY_TYPE;
		*WRCNTL1 &= ~WR1_CSSRD_MASK;
		*WRCNTL1 |= WR1_RD32;
		printf ("Memory simulation is on.\n");
	}
	else if(!strcmp (comm_args[1], "off")) {
		MemSimFlag = FALSE;
		*WRCNTL1 |= WR1_DIAG_ANY_TYPE;
		*WRCNTL1 &= ~WR1_CSSRD_MASK;
		*WRCNTL1 |= WR1_4BYTE_RD;
		printf ("Memory simulation is off.\n");
	}
	else {
		printf("Illegal argument '%s', \n", comm_args[1]);
		printf("legal options are 'on' and 'off'.\n");
	}
	return(0);
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
cache020()
{
	if(!strcmp (comm_args[1], "on")) {
		_cache(1);
		cacheflag = 1;
	}
	else if(!strcmp (comm_args[1], "off")) {
		_cache(0);
		cacheflag = 0;
	}
	else
		printf("Illegal argument.\n",comm_args[1]);
	printf("Cache is now %s.\n",(cacheflag) ? "on" : "off");
	return(0);
}
	
/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
Clock(comm_str, argc)
char *comm_str;
int argc;
{
	if(!argc) {			/* if we just want status.. */
		if(powmain() && (!(*STATUSREG &0x20000000))) /* CSS clock */
			printf("\n*CSS clock active ");
		else
			printf("\n*Local clock active ");

#ifdef	SPM_PROM
		printf("(PROM Version %d.%d.%d).\n", 
			RELEASE, VERSION, PRE_REL);
#endif

#ifdef	SPM_CONFIG
		printf("(DIAG Image Version %d.%d.%d).\n", 
			RELEASE, VERSION, PRE_REL);
#endif
		return(0);
	}
	
	if (!strcmp(comm_args[1], "css") ||  !strcmp(comm_args[1], "CSS")) {
		if(!powmain()) {
			printf("\nUnable to switch to CSS clock.");
			printf("\nMain power must be active.\n");
			return(0);
		}
		CloSwi_css();
	}
	else {
		if(!strcmp(comm_args[1], "bd") || !strcmp(comm_args[1], "BD"))
			CloSwi_loc();
		else
			printf("Illegal argument, options are 'css/CSS' or 'bd/BD'.\n");
 	}	

	return(0);
}

/*------------------------------------------------------------------------------
	Switch to css clock
------------------------------------------------------------------------------*/
CloSwi_css()
{
	to_css = (unsigned)CSS_CL_FLAG;
	*WRCNTL1 &= ~(WR1_RRDY|WR1_ID_RST); /* assert cpu.res.ready,
						      disp.res*/
	*WRCNTL1 |= (WR1_DREQ);		/* deassert cpu.disp.req */
	*CLKCNTL = 0x00000001;		/* switch clocks.. eh? */
					/* causes a reset      */	
	while(1);			/* reset will happen */ 
}

/*------------------------------------------------------------------------------
	Switch to local clock
------------------------------------------------------------------------------*/
CloSwi_loc()
{
	to_css = (unsigned)LOC_CL_FLAG;
	*WRCNTL1 &= ~(WR1_RRDY|WR1_ID_RST); /* assert cpu.res.ready,
						      disp.res*/
	*WRCNTL1 |= (WR1_DREQ);		/* deassert cpu.disp.req */
	*CLKCNTL = 0x00000000;		/* switch clocks.. eh? */

	while(1);			/* reset will happen */
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
printer(comm_str, argc)
char *comm_str;
int argc;
{
	if(argc) { 			/* if we just want status.. */
		if (!strcmp (comm_args[1], "on")) {
			if (ACRW_HERE) {
				printf ("Printer not supported with ACRW.\n");
			}
			else {
				printer_on = 1;
				NOVRAM->printer_active = 1;
				NOVRAM->shared_crc = nov_chk_sum(2);
			}
		}
		else {
			printer_on = 0;
			NOVRAM->printer_active = 0;
			NOVRAM->shared_crc = nov_chk_sum(2);
		}
	}

	printf ("The printer is currently %sABLED at Baud:  %d.\n", 
	(printer_on ? "EN" : "DIS"), NOVRAM->printer_baud_rate);

}	


/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
modem(comm_str, argc)
char *comm_str;
int argc;
{
	if(argc) { 			/* if we just want status.. */
		if (!strcmp (comm_args[1], "on")) {
			modem_on = 1;
			NOVRAM->modem_active = 1;
			NOVRAM->shared_crc = nov_chk_sum(2);
		}
		else {
			modem_on = 0;
			NOVRAM->modem_active = 0;
			NOVRAM->shared_crc = nov_chk_sum(2);
		}
	}
	printf ("The MODEM PORT is currently %sABLED at Baud:  %d.\n",
		(modem_on ? "EN" : "DIS"), NOVRAM->modem_baud_rate);
}	

