
include(./head/top.h)

global promstart
global which_clk
global tst_pass
global cp_flp_code
global got_reset


	text

promstart:
	mov.w	&0x2700,%sr		# Set the interrupt mask
	mov.b	wrcntl2, %d6		# get current wrcntl2 values and save
	mov.b	&0xfa,wrcntl2		# Stop reset, set at 0 for 27512 proms
	mov.b	MSR,%d0			# Stop floppy interrupt, read fdc MSR
	mov.l	&promstart,%d0		# get my address.
	and.l	&0xffff0000,%d0 	# strip junk.
	mov.l	%d0,%d1 		# save for ram configuration.
	mov.l	%d0,%vbr		# Point to prom base (at 0)
	mov.l	&0x08,%d0
	mov.l	%d0,%cacr		# Clear the instruction cache
	mov.l	&0x01,%d0
	mov.l	%d0,%cacr		# Enable on-chip cache	
	mov.l	&stack,%d0		# Stack address
	mov.l	%d0,%usp		# Set user stack pointer
	mov.l	%d0,%msp		# Set master stack pointer
	mov.l	%d0,%isp		# Set interrupt stack pointer
#-------------------------------------------------------------------------------
rwi_check:
	lea.l	cio1_a, %a0		# load the CIO1_PORTA address.
	clr.l	%d7
	mov.b	(%a0), %d7		# Read this port.
	cmp.b	%d7,&0xFF		# Is there an RWI
	beq.b	no_rwi
	jmp	rwi_present
no_rwi:
	mov.b	&0x08,%d0		# Nothing present stop and blink.
	jmp		Blink		# and never return
rwi_present:
#-------------------------------------------------------------------------------
#	d6 contains info from write control register 2
#-------------------------------------------------------------------------------
	btst	&7, %d6			# Check status of bit 7 (bd.reset bit)
	bne.w	got_reset		# If 1 - a reset, else cold power.
cold_pwr:
	jsr	cold_pwr_init
	jsr	initscc			# WARNING we are using stack before
					# testing.....THIS is temporary
	jmp	pow_up_tst		# go do powerup tests: The stack and
					# all of static ram is set to 0.
tst_pass:				# If power up tests pass, return here
	mov.l	&LOC_CL_FLAG, to_css
	jsr 	cp_flp_code		# copy floppy code into ram and return
	jsr	rwi_cio_init		# initialize this part once
	jsr	init_stuff		# initialize scc and cio 
	jsr	try_pwr_on		# turn on main power, attempt to
					# switch clocks: causes a reset, and
					# should never return, if it does...
	jmp	local_clk_ok		# start local monitor (key is off)

got_reset:
	jsr	powmain			# check main power
	tst.l	%d0			# returns 0 for off, 1 for on
	beq.b	local_clk_ok		# power is off, go to monitor
	jsr	which_clk		# power is on, check which clock
	tst.l	%d0			# returns 0 for CSS, 1 for local
	beq.b   css_clk_ok		# on CSS: keep going
 	jsr 	switch_tried		# has clock switch been tried?
	tst.l	%d0			# returns 0 for no, 1 for yes
	bne.b	bad_clock		# tried to switch, switch failed
	jsr	init_stuff		# init cio and scc
	jsr	pwr_should_be_off	# in this situation, the user has 
					# manually powered the system, and 
					# hasn't switched clocks
	jmp	local_clk_ok		# start monitor

#
#	The three exits from startup are:
#		clock is bad:	poweroff...init...monitor
#		clock is css:	adc chk...init...poll...boot...monitor
#		clock is loc:	init...monitor
bad_clock:
	jsr 	cp_flp_code		# copy floppy code into ram and return
	jsr 	pwr_off			# power system off,
	lea.l	noswitch, %a0		# print an error message,
	jsr	PrintStr
	jsr	init_stuff		# init cio and scc
	jsr	main
	jmp	localstart		# and go to monitor

local_clk_ok:
	jsr 	cp_flp_code		# copy floppy code into ram and return
	jsr	init_stuff
	jsr	main
	jmp	localstart

css_clk_ok:
	jsr 	cp_flp_code		# copy floppy code into ram and return
	jsr	chk_local_adc		# check ADC power supplies
	tst.l	%d0			# returns 0 OK, or number of errors
	beq.l	pwr_sup_pass
	jsr	pwr_off			# This should cause a reset and not ret
dead_end:	
	bra	dead_end

pwr_sup_pass:
	jsr	init_stuff		# initialize scc, cio 
#	jsr	init_css
#	jsr	iready
	jsr	main
	jsr	css_bus_init		# power up bus
	jsr	start_main		# poll, init, boot if flag set
	jmp	mon_start		# go to monitor

#
#	startup subroutines
#
cp_flp_code:
	mov.l	&edata,%a0		# copy the floppy driver section to 
	mov.l	&data_start,%a1		# static ram using the map labels
	mov.l   &e_isec,%d0
	mov.l   &st_isec,%d1
	sub.l   %d1,%d0
#	lsr.l	&0x02,%d0,
#	mov.l	&0x0100,%d0		# FIX THIS, this is only an estimate,
					# do this better!!! number longs to move
more_bytes:
	mov.b	(%a0)+,(%a1)+		# move 4 bytes
	dbra	%d0,more_bytes
	rts

which_clk:
	btst	&5,statusreg	# check status register bit 5
	beq	on_css		# if 0, on CSS clock
	mov.l	&1,%d0		# put 1 in d0 to show on local clock
	rts
on_css:
	mov.l	&0,%d0		
	rts

switch_tried:
	mov.l	to_css,%d0	# find out what to_css is
	cmp.l	%d0,&CSS_CL_FLAG
	bne.b	no_switch	# if 0, haven't tried to switch to CSS
s_tried:
	mov.l	&1,%d0		# put a 1 in d0 to show switch tried
	rts			
no_switch:
	mov.l	&0,%d0		# put a 0 in d0 to show no clock switch
	rts			# has been tried

#
#	startup messages
#
noswitch:
	byte	'\r,'\n,'C,'o,'u,'l,'d,' ,'n,'o,'t,' ,'s,'w,'i,'t,'c,'h,' 
	byte	't,'o,' ,'C,'S,'S,' ,'c,'l,'o,'c,'k,'.,'\r,'\n  
	byte	'P,'e,'r,'f,'o,'r,'m,'i,'n,'g,' ,'P,'o,'w,'e,'r,'-,'O,'f,'f,' 
	byte	'S,'e,'q,'u,'e,'n,'c,'e,'.,'\r,'\n 
	byte	'E,'n,'t,'e,'r,'i,'n,'g,' ,'l,'o,'c,'a,'l,' 
	byte	'm,'o,'n,'i,'t,'o,'r,'.,'\r,'\n,NULL
