
#include "types.h"
#include "spm.h"
#include "novram.h"
#include "local_ad.h"

int  chk_local_adc();

static struct ad_control  ad_str[] = {
/*
**	FIX THE SCALE FACTOR FOR THE REFERENCE
*/
	(ushort)0x0101, (ushort)1, (ushort)1, (ushort)'+', (uint)178, 
	"Reference Voltage", "Volts",

	(ushort)0x0102, (ushort)2, (ushort)1, (ushort)'+', (uint)352, 
	"Local +5V supply", "Volts",

	(ushort)0x0100, (ushort)0, (ushort)1, (ushort)'+', (uint)352, 
	"Main +5V supply", "Volts",

	(ushort)0x0104, (ushort)4, (ushort)1, (ushort)'+', (uint)850, 
	"Local +12V supply", "Volts",

	(ushort)0x0103, (ushort)3, (ushort)1, (ushort)'+', (uint)850, 
	"Main +12V supply", "Volts",

	(ushort)0x0106, (ushort)6, (ushort)0, (ushort)'-', (uint)1188, 
	"Local -12V supply", "Volts",

	(ushort)0x0105, (ushort)5, (ushort)0, (ushort)'-', (uint)1188, 
	"Main -12V supply", "Volts",

	(ushort)0, (ushort)0, (ushort)0, (ushort)0, (uint)0, "", "",
};

static struct adc_test  local_ad_tst[] = {

	(ushort)0x0101, (ushort)1, (uchar *)0, (uchar *)0, 
	"Reference Voltage",

	(ushort)0x0102, (ushort)2, (uchar *)&(NOVRAM->five_volt_low_shutdown),
	(uchar *)&(NOVRAM->five_volt_high_shutdown), "Local +5 Volts",

	(ushort)0x0100, (ushort)1, (uchar *)&(NOVRAM->five_volt_low_shutdown),
	(uchar *)&(NOVRAM->five_volt_high_shutdown), "Main +5 Volts",

	(ushort)0, (ushort)0, (uchar *)0, 
	(uchar *)0, "",

};


local_a_d(comm_str, arg_cnt)
char	*comm_str;
int	arg_cnt;
{
	ushort volts;
	uint	calc_volts;
	register uint int_part;
	register uint flt_tens;
	register uint flt_ones;
	register uint cnt;
	register uint looping = 0;

	if (*comm_str == 'l')
		looping = 1;

	do {
		clscrn(25);
		for (cnt = 0; ad_str[cnt].ctl; cnt++) {
			if (get_local_adc (ad_str[cnt].ctl, &volts, 
							ad_str[cnt].chan))
				continue;
			
			volts &= 0xFF;
			if (ad_str[cnt].positive) {
				calc_volts = (volts * ad_str[cnt].sc1);
			} 
			else {
				if(volts >= 0xda)
					calc_volts = 0;
				else
					calc_volts = 259200 - 
						(ad_str[cnt].sc1 * volts);
			}
			int_part = calc_volts / 10000;
			flt_tens = calc_volts % 10000;
			flt_ones = flt_tens % 1000;
			flt_tens = flt_tens / 1000;
			flt_ones = flt_ones / 100;

			if (!cnt) {
				printf("\n%s is %s.\n",
				ad_str[cnt].id_str, 
				(volts == 0x00FF) ? "OK":"BAD");
			}
			else {
				printf("\n%s = %c%02d.%d%d %s\n", 
				ad_str[cnt].id_str, ad_str[cnt].pol, int_part, 
				flt_tens, flt_ones, ad_str[cnt].units); 
			}
		}

	if (ifesc())		/* do we quit? */
		looping = 0;

	wait_cnt (4000);   /* Wait a moment, allow user time to read values */

	} while (looping);
}


get_local_adc (chan, volt, adc_chan)
ushort	chan;
ushort	*volt;
uint	adc_chan;
{
	uint	adc_timer = 0x1000;

	*ADC_CNTL = chan;

	do {
		*volt = *ADC_ADATA;
		if(*volt & ADC_EOC)
			break;
	} while (adc_timer--);

	if(!adc_timer) 
		printf("\nBad SPM A/D conversion, chan %d.\n", adc_chan);
	
	return(adc_timer?0:1);
}

int
chk_local_adc()
{
	
	uint	error = 0;
	ushort volts;
	register uint cnt;

	for (cnt = 0; local_ad_tst[cnt].ctl; cnt++) {
		if (get_local_adc (local_ad_tst[cnt].ctl, &volts, 
							local_ad_tst[cnt].chan))
			continue;
			
		volts &= 0xFF;

		if (!cnt) {	/* reference voltage is element 0 */
			if ((uchar)volts != 0xFF) {
				printf ("SPM ADC detects %s bad.\n", 
					local_ad_tst[cnt].desc);
				error++;
				continue;
			}
		}
		else { 		/* 5 volts are elements 1 and 2 */
			if ((uchar)volts < *(uchar *)(local_ad_tst[cnt].min)) {
				printf ("SPM ADC detects %s too low.\n", 
					local_ad_tst[cnt].desc);
				error++;
				continue;
			} 
	
			if ((uchar)volts > *(uchar *)(local_ad_tst[cnt].max)) {
				printf ("SPM ADC detects %s too high.\n", 
					local_ad_tst[cnt].desc);
				error++;
				continue;
			} 
		}
	}
	return(error);
}


/*
**	powmain - checks the main +5volts to make sure it is larger than
**		  the +5volt low shutdown in NOVRAM.  Returns 1 if higher,
**		  (ie. power on), returns 0 if lower (ie. power off).
*/
powmain()
{
	ushort volts;

	/* Element 2 is the main +5 volts, return 0 if conversion fails */
	if (get_local_adc (local_ad_tst[2].ctl, &volts, local_ad_tst[2].chan))
		return(0);
			
	volts &= 0xFF;

	if ((uchar)volts < (uchar)(NOVRAM->five_volt_low_shutdown))
		return(0);

	return(1);
}
