include(./head/top.h)
# pwr_on calls mon_start1 if start_main ever returns; and mon_start1

global localstart	
global mon_start
global init_stuff
global migrate

localstart:
	lea.l	signon, %a1		# show monitor message
	jsr	PrintStr		# print it to console

mon_start:				# never called directly
#	jsr 	main			# initialize global variables
	jsr	ctinten			# re-enable interrupts

mon_start1:
	jsr	version 		# display version info (in C)
	jsr	initscc			# make sure this is init-ed
	jsr	init_monitor		# init pointers and things (in C)
	jsr	monitor			# in C
	bra	mon_start1		# shouldn't come back, but if 
					# it does return to monitor
init_stuff:
	jsr	initscc 		# in C
	jsr	initcio			# in C
	rts

#-------------------------------------------------------------------------------
# move prom vector table to ram at newloc
#-------------------------------------------------------------------------------
migrate:
	movm.l	&D0S+A0S+A1S,-(%sp)	# save some registers
	mov.l	%vbr,%a0		# aim at base of old vector table
	mov.l	&0x1000000,%a1		# load new base address
	clr.l	%d0		
	mov.w	&0x3ff,%d0		# size of vector table in bytes - 1
mi2:
	mov.b	(%a0)+,(%a1)+		# Start moving the code. 
	dbf		%d0,mi2		# See if end of code size.

	mov.l	&0x1000000,%a0		# load new vector address
	mov.l	%a0,%vbr		# aim at new table.
	movm.l	(%sp)+,&D0R+A0R+A1R	# get back the saved registers
	rts

signon:
	byte	'\r,'\n,'E,'n,'t,'e,'r,'i,'n,'g,' ,'L,'o,'c,'a,'l
	byte	' ,'M,'o,'n,'i,'t,'o,'r,'\r,'\n,NULL

