include(./head/top.h)

global pow_up_tst

# Power up tests 
#-------------------------------------------------------------------------------
# EPROM checksum
#-------------------------------------------------------------------------------
pow_up_tst:
	mov.l	&promstart,%d0		# get my address.
	and.l	&0xffff0000,%d0 	# strip junk.
	mov.l	%d0,%a0 		# strip junk.
	clr.l	%d0			# Clear the sum register
	mov.l	%a0,%a1
	add.l	&prom_size+1,%a1	# End of EPROM
T1:
	add.b	(%a0)+,%d0		# Add a prom byte
	cmp.l	%a0,%a1			# Last byte?
	bne.b	T1			# Skip if no
	cmp.b	%d0,&0x00		# Checksum ok?
	beq.b	Test2			# Skip if yes
T1err:
	mov.b	&0x01,%d0		# Led 0 on
	jmp	Blink
#	bra.b	T1err			# This used to be a deadend loop,
					# it may be dangerous to go to
					# Blink since the EPROM failed, but
					# why not????
	
#-------------------------------------------------------------------------------
# Static ram data ripple test
#
# The first location of static ram is written with a rippling 1 bit then
# a zero is rippled through
#-------------------------------------------------------------------------------
Test2:
	lea.l	pwrup2,%a1		# "Static ram data ripple test."
	jsr		PrintStr	# Tell the user what we are doing.

	mov.l	&sram,%a0		# Static ram base
	mov.b	&0x01,%d0		# Ripple data
T2:
	mov.b	%d0,(%a0)		# Write the pattern
	cmp.b	%d0,(%a0)		# Compare?
	bne.b	T2error			# Skip if no
	rol.b	&1,%d0			# Shift the bit
	bcc.b	T2			# Skip if not done

# now ripple a zero
	mov.b	&0xfe,%d0		# Ripple data
T22:
	mov.b	%d0,(%a0)		# Write the pattern
	cmp.b	%d0,(%a0)		# Compare?
	bne.b	T2error			# Skip if no
	rol.b	&1,%d0			# Shift the bit
	bcs.b	T22
	bra.b	Test3
T2error:	
	mov.b	&0x02,%d0		# Lamp code to flash led s0 
	jmp	Blink
	
#-------------------------------------------------------------------------------
# Static ram address ripple test
#
# A one bit is rippled through the 13 address lines, then a zero is rippled
# through.
#-------------------------------------------------------------------------------
 
Test3:
	lea.l	pwrup3,%a1		# "Static ram address ripple test."
	jsr		PrintStr	#  Tell the user what we are doing.

	mov.b	&0x55,%d0		# Test data
	mov.l	&sram,%d1		# Base address
	mov.l	&0x00010000,%d2		# Address offset

T3:
	mov.l	%d1,%a0			# The address
	add.l	%d2,%a0			# Add in the offset
	mov.b	%d0,(%a0)		# Write the test pattern
	cmp.b	%d0,(%a0)		# Test the address location
	bne.b	T3error			# Skip if error
	not.b	%d0			# Invert the data
	mov.b	%d0,(%a0)		# Write the test pattern
	cmp.b	%d0,(%a0)		# Compare?
	bne.b	T3error			# Skip if error
	not.b	%d0			# Back to original
	lsr.l	&1,%d2			# Shift the address index
	bcc.b	T3			# Loop for next location

# second part

	mov.l	&0x0000ffff,%d2		# Address offset

T33:
	mov.l	%d1,%a0			# The address
	add.l	%d2,%a0			# Add in the offset
	mov.b	%d0,(%a0)		# Write the test pattern
	cmp.b	%d0,(%a0)		# Test the address location
	bne.b	T3error			# Skip if error
	not.b	%d0			# Invert the data
	mov.b	%d0,(%a0)		# Write the test pattern
	cmp.b	%d0,(%a0)		# Compare?
	bne.b	T3error			# Skip if error
	not.b	%d0			# Back to original
	lsr.l	&1,%d2			# Shift the address index
	bcc.b	Test4
	or.l	&0x10000,%d2		# Add a one bit
	bra.b	T33	
	
T3error:
	mov.b	&0x03,%d0		# Lamp code to flash led s1
	jmp	Blink

#-------------------------------------------------------------------------------
# Static ram content test
#
#-------------------------------------------------------------------------------
Test4:
	lea.l	pwrup4,%a1		# "Static ram content test."
	jsr		PrintStr	# tgm 01-12-89 Tell the user what we are doing.

	mov.b	&0x55,%d0		# Test data
	mov.l	&sram,%a0		# Address register
T4_55:
	mov.b	%d0,(%a0)		# Write the test pattern
	cmp.b	%d0,(%a0)+		# Compare?
	bne.b	T4error			# Skip if error
	cmp.l	%a0,&sram+sram_sz
	ble	T4_55

	mov.b	&0xaa,%d2		# Test data
	mov.l	&sram,%a0		# Address register
T4_aa:
	cmp.b	%d0,(%a0)		# Previous contents ok?
	bne.b	T4error			# Skip if no
	mov.b	%d2,(%a0)		# Write the test pattern
	cmp.b	%d2,(%a0)+		# Compare?
	bne.b	T4error			# Skip if error
	cmp.l	%a0,&sram+sram_sz
	ble	T4_aa

	mov.l	&sram,%a0		# Address register
T4_00:
	cmp.b	%d2,(%a0)		# Previous contents ok?
	bne.b	T4error			# Skip if no
	mov.b	&0x00,(%a0)+		# Write the test pattern
	cmp.l	%a0,&sram+sram_sz
	ble		T4_00

	bra.b	Test5			# Go write the interrupt vectors

T4error:
	mov.b	&0x04,%d0		# Lamp code to flash led s0 and s1 
	jmp	Blink

#-------------------------------------------------------------------------------
# SCC test
#-------------------------------------------------------------------------------
Test5:
	lea.l	pwrup5,%a1		# "SCC test."
	jsr		PrintStr	#  Tell the user what we are doing.

	mov.l	&scca,%a2

	mov.b	&0x55,(%a2,4.w)		# Write interrupt vector register ch A
	cmp.b	(%a2,4.w),&0x55		# Compare vector from channel A 
	bne		T5error		# Skip if error
	mov.b	&0xaa,(%a2,4.w)
	cmp.b	(%a2,4.w),&0xaa
	bne		T5error
	mov.b	&0x00,(%a2,4.w)
	bra.b	Test6

T5error:
	mov.b	&0x05,%d0
	jmp	Blink

#-------------------------------------------------------------------------------
# NOVRAM test	read/write novram to make sure it works.
#-------------------------------------------------------------------------------
Test6:
	jsr		initscc		# Reinitialize the scc just in case.
	lea.l	pwrup6,%a1		# "NOVRAM Read/Write test."
	jsr		PrintStr	# Tell the user what we are doing.

	lea.l	novram, %a0		# save data register.
	lea.l	novram+1, %a1		# save data register.
	mov.b	&0x55, %d0		# data pattern.
	mov.b	&0xAA, %d2		# data pattern.

	mov.b	%d0, (%a0)		# save it.
	mov.b	%d2, (%a1)		# save compliment
	mov.b	(%a0), %d1
	cmp.b	%d1, %d0		# if not same, bad.
	bne.b	T6error

	mov.b	%d2, (%a0)		# save complement
	mov.b	%d0, (%a1)		# save it.
	mov.b	(%a0), %d1
	cmp.b	%d1, %d2		# if not same, bad.
	bne.b	T6error

	mov.b	&0x00, %d0		# data pattern.
	mov.b	&0xff, %d2		# data pattern.
	mov.b	%d0, (%a0)		# save it.
	mov.b	%d2, (%a1)		# save it.
	mov.b	(%a0), %d1
	cmp.b	%d1, %d0		# if not same, bad.
	beq.b	Test7

T6error:
	mov.b	&0x06,%d0
	jmp	Blink

#-------------------------------------------------------------------------------
# Local CIO test	read/write cio to make sure it's here.
#-------------------------------------------------------------------------------
Test7:
	lea.l	pwrup7,%a1		# "Static ram content test."
	jsr		PrintStr	# Tell the user what we are doing.

	lea.l	cio, %a0		# Let's remove reset from cio chip.
	mov.b	&0x00, %d0
	mov.b	%d0, (%a0)		# clears reset..
	lea.l	cioreg, %a0		# save data register.
	mov.b	&0x55, %d0		# data pattern.
	mov.b	%d0, (%a0)		# save it.
	mov.b	(%a0), %d1
	cmp.b	%d1, %d0		# if not same, bad.
	bne.b	T7error
	mov.b	&0xAA, %d0		# data pattern.
	mov.b	%d0, (%a0)		# save it.
	mov.b	(%a0), %d1
	cmp.b	%d1, %d0		# if not same, bad.
	bne.b	T7error
	mov.b	&0x00, %d0		# data pattern.
	mov.b	%d0, (%a0)		# save it.
	mov.b	(%a0), %d1
	cmp.b	%d1, %d0		# if not same, bad.
	bne.b	T7error
	bra.b	Test8

T7error:
	mov.b	&0x07,%d0
	jmp	Blink

#-------------------------------------------------------------------------------
# Clear static ram
#-------------------------------------------------------------------------------
Test8:
	lea.l	pwrup8,%a1		# "Sram cleared"
	jsr		PrintStr	# Tell the user what we are doing.

	mov.l	&sram,%a0		# Static ram base
	mov.l	&0xffff,%d1		# Size of ram = 64k
T8:
	clr.l	(%a0)+			# clear it
	dbra	%d1,T8			 

Testsdone:
	jmp 	tst_pass		# return to startup.s

pwrup2:
	byte	'\r,'S,'r,'a,'m,' ,'d,'a,'t,'a,' ,'r,'i,'p,'p,'l,'e
	byte	' ,'t,'e,'s,'t,'.,NULL

pwrup3:
	byte	'\r,'S,'r,'a,'m,' ,'a,'d,'d,'r,'e,'s,'s,' ,'r,'i,'p,'p,'l,'e
	byte	' ,'t,'e,'s,'t,'.,NULL

pwrup4:
	byte	'\r,'S,'r,'a,'m,' ,'c,'o,'n,'t,'e,'n,'t,' ,'t,'e,'s,'t,'.
	byte	' ,' ,' ,' ,' ,' ,' ,' ,' ,NULL

pwrup5:
	byte	'\r,'S,'C,'C,' ,'W,'/,'R,' ,'t,'e,'s,'t,'.,' ,' ,' ,' ,' ,NULL

pwrup6:
	byte	'\r,'N,'O,'V,'R,'A,'M,' ,'R,'/,'W
	byte	' ,'t,'e,'s,'t,'.,NULL

pwrup7:
	byte	'\r,'L,'o,'c,'a,'l,' ,'C,'I,'O,' ,'R,'/,'W
	byte	' ,'t,'e,'s,'t,'.,NULL

pwrup8:
	byte	'\r,'S,'r,'a,'m,' ,'c,'l,'e,'a,'r,'e,'d
	byte	' ,' ,' ,' ,' ,' ,' ,' ,' ,' ,' ,' ,' ,' ,' ,' ,' ,' ,NULL

