/*----------------------------------------------------------------------------
	pollio.c

	used by "prom_pollio.c" and "confi_pollio.c".
	In the future this file will be included (and modified) in the
	two other files, and will be removed.
-----------------------------------------------------------------------------*/


#include "types.h"
#include "icb.h"
#include "vreg.h"
#include "mac.h"
#include "icb_config.h"
#include "spm.h"
#include "ioa0.h"
#include "iom.h"

#include "disp.h"
#include "vac.h"
#include "menu.h"
#include "novram.h"
#include "iosba_addr.h"

#define Sbus_Num_Slot		16		/* Max Sbus Slot. */

extern char got_berr;			/* */
extern char emulate;			/* */
extern uchar bdhere[];			/* css slots */
extern char ignore_it;			/* ignore CSS bus errors. */

extern struct icb_config  io_conf[][MAXSLOTS];
extern struct iosb_config ios_conf[][MAX_CSS_SLOT];

static uchar   dtbid;
static uchar 	xdtbid;

uchar 	scsiflag;		/* this global variable is left here */
				/* because this file is going to be removed */
				/* and this variable becoming local to the */
				/* other modules */

/*------------------------------------------------------------------------------
-----------------------------------------------------------------------------*/
init_io_struct()
{
	uint	iom_num;
	uint	s_slot;

	for(iom_num = 0; iom_num != MAX_SSIO; iom_num++) {
		for(s_slot = 0; s_slot != MAX_IO_SLOT; s_slot++) {
			io_conf[iom_num][s_slot].iomslot = NOBOARD;
			io_conf[iom_num][s_slot].icb_slot_id = NOBOARD;
			io_conf[iom_num][s_slot].bdptr = 
				(struct bd_desc *)0;
			io_conf[iom_num][s_slot].iop_base = 
				(struct icb *)0;
			ios_conf[iom_num][s_slot].iomslot = NOBOARD;
			ios_conf[iom_num][s_slot].slot_id = NOBOARD;
		}
	}
	scsiflag = 0;
}	


/*------------------------------------------------------------------------------
-----------------------------------------------------------------------------*/
poll_io_slot(flg)	/* poll the io subsytem slots */
char flg;
{
	uchar	iom_num;
	uint	c_slot;
	uint	s_slot;
	char	emulate_save = emulate;
	char	ignore_save = ignore_it;

	emulate = 1;	/* set quiet buserror stuff. */
	ignore_it = 1;	/* enable bus error ignore */

	iom_num = 0;
	for(c_slot = 0; c_slot != Sbus_Num_Slot; c_slot++) {	
		if((bdhere[c_slot] & BDTYPEMASK) == IOMTYPE) {
			switch ((uchar)test_for_adapter(c_slot)) {	
				case TYPE_IOSBA:
					ios_poll(flg, c_slot, iom_num);
					break;
				case TYPE_IOA:
					icb_poll(flg, c_slot, iom_num);
					break;
				default:
					io_conf[iom_num][0].iomslot = c_slot;
					break;
			}
			iom_num++;
		}
	}
	emulate = emulate_save;	/* set quiet buserror stuff. */
	ignore_it = ignore_save;	/* enable bus error ignore */
}

int
icb_poll(flg, c_slot, iom_num)
uint	flg;
uint	c_slot;
uint	iom_num;
{
	uchar	icb_slot;
	uchar	id;
	uint	nm;
	uint	id_byte;
	struct icb	*icbadd;
	struct mac	*macptr;
	char	emulate_save = emulate;
	char	ignore_save = ignore_it;

	ios_conf[iom_num][0].iomslot = NOBOARD;

	dtbid = 4;
	xdtbid = 0x10;

	cssmap(MAP00, (unsigned char)c_slot, 0x00);
	for(icb_slot = 0; icb_slot != MAX_IO_SLOT; icb_slot++) { /* all slots */
		emulate = 1;	/* set quiet buserror stuff. */
		ignore_it = 1;	/* enable ignoring of bus errors..*/
		io_conf[iom_num][icb_slot].iomslot = c_slot;
		got_berr = 0;	/*  clear bus error flag */
		nm = icb_slot + (SLOTSTART >> SLOTSHFT);
		icbadd = (struct icb *) ((nm << SLOTSHFT) | 0x80000000);
		id = icbadd->bdtypreg;
		if(got_berr)	{ /* if bus error, no board */
			continue;	/* skip this slot */
		}
		emulate = emulate_save;
		ignore_it = ignore_save;
		id = id & 0x1f;	/* board id */
		switch (flg)	/* check board id */
		{
		case 0:
			switch (id)	/* check board id */
			{
			case VACBDTYP:	/* vac board */
			       	vacinit(id,c_slot,icb_slot,icbadd,iom_num);
				break;
			case EDT:	/* edt board */
			case HSDT:	/* high speed edt */
				break;
			case SCSI:	/* SCSI board */
				scsiflag = 1;  
				break;
			case GCP:	/* gc board */
			case EGCP:	/* gc16 board */
				icbadd->intreg = 0x2040 | icb_slot;
				break;
			case MAC:	/* mac board */
				macptr = (struct mac *)icbadd;
				macptr->rstreg = MACRESET;
				break;
			default:
				printf("Unknown board slot:%x \n",icb_slot);
				break;
			}
			break;
		case 1:
			switch (id)	/* check board id */
			{
			case EDT:	/* edt board */
			case SCSI:	/* SCSI board */
			case HSDT:	/* high speed edt */
			case GCP:	/* gc board */
			case EGCP:	/* gc16 board */
				init_desc(id,c_slot,icb_slot,icbadd,iom_num);
				break;
			case MAC:	/* mac board */
				macptr = (struct mac *)icbadd;
				macptr->rstreg = 0;
				macptr->intreg = MACINTPRI;
				iobd_info(id,c_slot,icb_slot,icbadd,iom_num);
				break;
			default:
				break;
			}
			break;
		}
	}
}

iobd_info(bdid,io_sys,io_slot,icbadd,iom_num)
char	io_sys;
short	io_slot;
uchar bdid,iom_num;
struct icb	*icbadd;
{
	struct		icb_config	*icbp;

/* Store the board information in io_config */
	icbp = &io_conf[iom_num][io_slot];
	icbp->iomslot = (char)io_sys;		/* IO module slot */
	icbp->icb_slot_id = bdid;	/* Board id info */
	icbp->iop_base = icbadd;		/* ICB base address */
}

init_desc(bdid,io_sys,io_slot,icbadd,iom_num)
char	io_sys;
short	io_slot;
unsigned char bdid,iom_num;
struct icb	*icbadd;
{
	struct		icb_config	*icbp;
	struct		bd_desc		*bdp;
	uint		*header;
	struct	 	icb	*icbbase;

/* Use map 0 to address ICB base address from service module */
/* Set ICB base address for the board */
	icbbase = icbadd;
	header = (uint *)((uint)icbadd + BDVECT);
	/* Get board descriptor pointer */
	bdp = (struct bd_desc *)(((*header&LWWORD)+(io_slot*IO_OFST))|IO_MAP0);

	if (bdid != SCSI) {
		if(!time(4000,&icbbase->tasreg,TASBIT,0))
		{
resetslot:
/*
* halt the board
*/
			icbbase->intreg = HLTIOP;
			switch (bdid)	{	/* check board id */
		   		case EDT:	/* edt board */
					printf("EDT ");
					break;
		   		case HSDT:	/* high speed edt */
					printf("HSDT ");
					break;
		   		case GCP:	/* gc board */
					printf("GCP ");
					break;
		   		case EGCP:	/* gc16 board */
					printf("EGCP ");
					break;
		   		case MAC:	/* mac board */
					printf("MAC ");
					break;
				default:
					printf("Unknown board ");
					break;
				}
			printf("in ICB slot %x IOM in CSS slot %x does not respond...\n",io_slot,io_sys);
			return;
		}
	}
	bdp->bd_slot = io_slot;
	bdp->bd_icbint = 1;
	if((bdid == EDT) || (bdid == HSDT) || (bdid == SCSI)) {
		bdp->bd_dtbid = dtbid++;
		bdp->bd_xdtbid = xdtbid++;
	}
	if (bdid != SCSI) {
		icbbase->tasreg = 1; /* clear TAS */
		if ((bdid == EDT) || (bdid == HSDT))
			bdp->bd_opt = S90;   /* set up S90 flag into board */
		if(!ivrupdt(icbbase)) 
			goto resetslot;
	}
	else {
		icbbase->tasreg = 1; /* clear TAS */
		bdp->bd_opt = S90;   /* set up S90 flag into SCSI board */
	}

/* Store the board information into io_config */
	icbp = &io_conf[iom_num][io_slot];
	icbp->iomslot = (char)io_sys;		/* IO module slot */
	icbp->icb_slot_id = bdid;	/* Board id info */
	icbp->bdptr = bdp;			/* Board descriptor pointer */
	icbp->iop_base = icbbase;		/* ICB base address */
}

/*
	Changed the routine to use the info in the io_conf structures,
	previosly, the io subsystem was polled twice, now poll_io_slot
	does the polling and this uses that data.
*/
scsiwait()	/* poll the io subsytem slots */
{
	uchar	iom_num;
	uchar	icb;
	struct icb	*icbadd;
	uint	*header;
	struct	bd_desc	*bdp;
	uint    delay;
	uchar   slot;

	scsiflag = 0;	/* 08/16/88 alan */

	/*	All io_conf structures 	*/
	for (iom_num = 0; iom_num != IOM_PER_SYS; iom_num++) {


		for (icb = 0; icb != MAX_IO_SLOT; icb++) {
			
			/*	if SCSI do this stuff, else next structure */
			if (io_conf[iom_num][icb].icb_slot_id == SCSI) {

				slot = (uchar)io_conf[iom_num][icb].iomslot;
				cssmap(MAP00, (unsigned char)slot, 0x00);
				icbadd = io_conf[iom_num][icb].iop_base;
				bdp = io_conf[iom_num][icb].bdptr;

				header = (unsigned int *)
					((unsigned)icbadd + BDVECT);

				if(!time(2000,&icbadd->tasreg,TASBIT,0)) {
resetslot:
					icbadd->intreg = HLTIOP;
					printf("\nI/O subsytem in CSS slot %x SCSI in ICB slot %x does not respond...\n",io_conf[iom_num][icb].iomslot,icb);
					return;
				}

/*	delay = 2000000; will be modified before last release: halan */
				delay = 3000000; /* */
				while (delay--) {
					if (!delay) {
						printf("SCSI powerup test time-out\n");
						goto resetslot;
					}

					if (bdp->bd_stst == STCMPLT) {
						bdp->bd_opt = S90; 	/* in S90 system , extra*/
						break;
					}
				}
				icbadd->tasreg = 1; /* clear TAS */
				if(!ivrupdt(icbadd))
					goto resetslot;
			}
		}				
	}
}

ivrupdt(icbbase) 
struct	 icb	*icbbase;
{
    register	status;


    icbbase->intreg = (IVRUPDT | INTIOP);
    if(!time(500,&icbbase->bdtypreg,IOPIPND,IOPIPND))
        status = 0;
    else    
	status = icbbase->intreg; /* clear the interrupt */
    return(status);
}


time(howlong,location,mask,value) 
uchar *location, mask, value; 
{
    int i, j;

    for(i=0; i != howlong; i++) {
        for(j=0; j != 50; j++) {
            if((*location & mask) == value)
                return(1);
        }
    }
    return(0);
}


iotbl(comm_str,arg_cnt)	/* show icb configurations */
char *comm_str;
int arg_cnt;
{
	short		i,j;
	unsigned char	id,iom_num;
	struct		icb_config	*icbp;

	iom_num = 0;
	for(i = 0; i != Sbus_Num_Slot; i++) {	/* find IO module */
		if((bdhere[i] & BDTYPEMASK) == IOMTYPE) {
			if (ios_conf[iom_num][0].iomslot == i) {
				ios_show(i, iom_num);
			}
			else {
				if (io_conf[iom_num][0].iomslot == i) {
					icb_show(i, iom_num);
				}
				else {
					printf ("Could not find array for ");
					printf ("%d IOM in slot %x (%d).\n",
						iom_num, i, i);
				}
			}
		iom_num++;
		}
	}
}


int
icb_show(c_slot, iom_num)
uint	c_slot;
uint	iom_num;
{
	short		j;
	unsigned char	id;
	struct		icb_config	*icbp;

	for(j = 0; j != MAX_IO_SLOT; j++) { /* check io slot */
		icbp = &io_conf[iom_num][j];
		id = icbp->icb_slot_id;	/* Board id info */
		switch (id)	{	/* check board id */
			case VACBDTYP:	/* vac board */
				printf("VAC    ");
				break;
	   		case EDT:	/* edt board */
				printf("EDT    ");
				break;
	   		case SCSI:	/* SCSI board */
				printf("SCSI   ");
				break;
	   		case HSDT:	/* high speed dt */
				printf("HSDT   ");
				break;
	   		case EGCP:	/* gc16 board */
	   		case GCP:	/* gc board */
				printf("GC     ");
				break;
	   		case MAC:	/* mac board */
				printf("MAC    ");
				break;
			default:
				continue;
				break;
		}
		printf("module, IOM 0x%x CSS slot 0x%x (%d) ICB slot 0x%x (%d)\n",
			iom_num, c_slot, c_slot, j, j);
	}
}


int
ios_show(c_slot, iom_num)
uint	c_slot;
uint	iom_num;
{
	short		j;
	unsigned char	id;
	struct		icb_config	*icbp;

	for(j = 0; j != MAX_CSS_SLOT; j++) { /* check io slot */
		id = ios_conf[iom_num][j].slot_id;
		switch (id)	{	/* check board id */
			case IOPHERE:	/* iopm board */
				printf("IOPM   ");
				break;
			case IOPM_CONSOLE:	/* iopm board in console mode */
				printf("IOPM CONSOLE ");
				break;
			case VAMHERE:
				printf("VAM    ");
				break;
			case IOSBAHERE:
				printf("IOSBA  ");
				break;
			default:
				continue;
				break;
		}
		printf("module, IOM 0x%x CSS slot 0x%x (%d) I/O slot 0x%x (%d)\n",
			iom_num, c_slot, c_slot, j, j);
	}
}


vacinit(id,i,j,icbadd,iom_num)
char	i;
short	j;
unsigned char id,iom_num;
struct icb	*icbadd;
{
	int temp;
	struct vac 	*vacptr;
	struct icb_config 	*icbp;

	icbp=&io_conf[iom_num][j];
	icbp->iomslot = (char)i;
	icbp->icb_slot_id = id;
	icbp->iop_base = icbadd;
	vacptr = (struct vac *)icbadd;
	/* reset vac & set yellow led */
	vacptr->vac_reset_id = VAC_SRST;
	/* read stat reg is SYSOK set */
	temp = vacptr->vac_icb_stat;	
	if(!(temp & VAC_SYS_OK)) {
		/* if SYSOK then unreset vac */
		/* turn off yellow led and turn on green led */
		vacptr->vac_reset_id = 0;	
		temp = (VAC_RUN_LED |VAC_NRM_LED| 90X);
		vacptr->vac_reset_id = temp;	
	}	
	else {
		printf(" ERR - SYSOK not set on VAC \n ");
	}
}

/*---[tgm]----------------------------------------------------------------------
	logiom: Logical IOM number. This will return the logical IOM number
			given the PHYSICAL IOM slot location.
------------------------------------------------------------------------------*/
logiom(c_slot)
register char c_slot;
{
	char slot = 0;
	char  iom_num = 0;

	if ((bdhere[c_slot] & BDTYPEMASK) != IOMTYPE) {/* Is an IOM in slot */
		printf ("No IOM in slot %x\n", c_slot);
		return (NOBOARD);
	}

	for(slot = 0; slot != c_slot; slot++) { /* All Slots. */
		if((bdhere[slot] & BDTYPEMASK) == IOMTYPE) 
			iom_num++;
	}

	return(iom_num);
}
