

/*------------------------------------------------------------------------------
	poll.c 

	contains the routines to poll the CSS bus at PROM level
	for now used by prom_poll.c and config_poll.c
	In the future different version will be included in those two
	files and this file will be removed.
------------------------------------------------------------------------------*/
#include "types.h"
#include "global.h"
#include "disp.h"
#include "spm.h"
#include "dev.h"
#include "novram.h"
#include "sbus_mm.h"
#include "icb.h"
#include "icb_config.h"
#include "iosba_addr.h"

extern uchar bdhere[];		/* slots for CSS board's */
extern uchar myslot;
extern char got_berr;		/* Bus error flag */
extern char emulate;		/* Bus error emulation flag */
extern char ignore_it;			/* If set, ignore CSS bus errors. */
extern uint iopm_present;               /* flag for IOPM */
extern char validmap;			/* show a poll slots has been done. */
extern struct slotst sf;
extern char *MEM_TYPE[];
extern struct icb_config  io_conf[][MAXSLOTS];
extern  struct  iosb_config ios_conf[][MAX_CSS_SLOT];

#define		MEM_TYPE_MASK	7

/*------------------------------------------------------------------------------
	slotson : Enable only slots valid in current table.
------------------------------------------------------------------------------*/
slotson()	/* enable only slots valid in current table. */
{
	register uint  slot;
	char	emulate_save = emulate;
	char	ignore_save = ignore_it;

	if(!validmap) {				/* If not valid, poll css */
		printf ("Current map not valid executing pollslot\n");
		pollslot(0);			/* go enable them all */
	}

	for (slot = 0; slot != Sbus_Num_Slot; slot++) {
		if (bdhere[slot] == NOBOARD)
			continue;

		cssmap(MAP00, (uchar)slot, 0x0f);
		ifenable(slot, 0);		/* enable i/f and module */
	}

	pollslot(1);		/* Enable existing slots */

	if (iom_present()) {
#ifdef	SPM_PROM
		prom_poll_io();
#endif
#ifdef	SPM_CONFIG
		config_poll_io(1);
#endif
	}
	putchar('\n');
	return(0);
}

/*------------------------------------------------------------------------------
	pollslot : Poll the css slots for boards.
------------------------------------------------------------------------------*/
pollslot(phase)
uint phase;		/* defines which pass of the complete poll this is */ 
{
	char	emulate_save = emulate;
	char	ignore_save = ignore_it;

	emulate = 1;		/* set 68020 buserror flag */
	ignore_it = 1;   	/* ignore bus errors */
	switch (phase) {
		case 0:		/* first pass, build table */
			build_table();
			validmap = 1;		/* show it's valid now. */
			break;
		case 1:		/* second pass, enable boards in table */
			enable_table();
			break;

		case 2:		/* third pass, verify enabled boards ok */
			verify_table();
			break;
		default:	/* tim fucked up */
			printf ("pollslot error, unknown phase.\n");
			break;
	}

	emulate = emulate_save;
	ignore_it = ignore_save;
	return(0);
}

/*
**	This routine is should enable i/f then get board ID, BUT the 
**	IOM and PM20 have problems which force enabling i/f AND module
**	before the ID can be read.  This potentially will cause problems
**	with boards like the IOPM.  But to get around the PM20 and IOM
**	I have no choice.
*/

build_table()
{
	register uint	slot;
	register uint	id;
	register uint	*bdstat = (uint *)0x8ffffffc;

	got_berr = 0;		
	for (slot = 0; slot != Sbus_Num_Slot; slot++) {	/* enable each slot */
		sf.on[slot] = 0;
		if (slot == myslot) {
			bdhere[slot] = SPMHERE;
			continue;
		}

		cssmap(MAP00, (uchar)slot, 0x0f);

		ifenable(slot, 0);		/* enable i/f and module */
		if (NOVRAM->newpwr) {  /* new power, must cycle    */
			ifdisable(slot, 0); /* reset on the PM20 bds */
			ifenable(slot, 0);   /* enable i/f & module */
			ifdisable(slot, 0); /* reset on the PM20 bds */
			ifenable(slot, 0);   /* enable i/f & module */
			ifdisable(slot, 0); /* reset on the PM20 bds */
			ifenable(slot, 0);   /* enable i/f & module */
		}

		wait_cnt(50);

		id = *bdstat; /* read board id */
		bdhere[slot] = (uchar)(id & 0xFF);	/* read board id */

		if (got_berr) {		/* if bus error, try MOD enable */
			got_berr = 0;
			ifdisable(slot, 0); /* reset on the PM20 bds */
			sf.on[slot] = 0;	/* Init slot flag */
			bdhere[slot] = NOBOARD;
			ifdisable(slot, 0);  /* disable i/f & module */
		}
	}
	NOVRAM->newpwr = 0;
}

enable_table()
{
	register  uint	slot;
	uint	  iom_num = 0;

	for(slot = 0; slot != Sbus_Num_Slot; slot++) {	/* enable each slot */
		if(slot == myslot) 
			continue;
		
		cssmap(MAP00, (uchar)slot, 0x0f);

		switch(bdhere[slot] & BDTYPEMASK) {
			case SPMTYPE:
			case CPUTYPE:
			case DPMTYPE:
			case VAMTYPE:
			case NOBOARDTYPE:
				break;
			case MEMTYPE:
				mm_init(slot,1);
				break;
			case IOPTYPE:
				ifdisable(slot, 0);
				ifenable(slot, 2);
				if (iopm_init(slot, NO_SUB_SLOT)) {
					ifdisable(slot, 0);
					bdhere[slot] = NOBOARD;
					sf.on[slot] = 0;
					break;
				}
				ifenable(slot, 1);
				iopm_present++;
				break;
			case IOMTYPE:
				io_conf[iom_num][0].iomslot = slot;
				ios_conf[iom_num][0].iomslot = slot;
				iominit(slot);
				iom_num++;
				break;
			default:
				printf ("Unknown module in slot %x (%d).\n",
				slot, slot);
				break;
		}
	}
}


verify_table()
{
	uint	slot;

	for(slot = 0; slot != Sbus_Num_Slot; slot++) {	/* enable each slot */
		if(slot == myslot) 
			continue;
		
		cssmap(MAP00, (uchar)slot, 0x0f);

		switch(bdhere[slot] & BDTYPEMASK) {
			case IOPTYPE:
				if (iopm_magic_bad(slot, NO_SUB_SLOT)) {
					ifdisable(slot, 0);
					bdhere[slot] = NOBOARD;
					sf.on[slot] = 0;
				}
				break;
			case CPUTYPE:
			case DPMTYPE:
				if (cpu_id_bad(slot, bdhere[slot])) {
					ifdisable(slot, 0);
					bdhere[slot] = NOBOARD;
					sf.on[slot] = 0;
				}
				break;
			default:
				break;
		}
	}
}

iopm_magic_bad()
{
	return(0);
}

cpu_id_bad()
{
	return(0);
}

show_css_table ()
{
	int	i, arg;
	int	mem_type;
	char	opt_string[16];

	for(i = 0; i < Sbus_Num_Slot; i++) {	/* loop all slots. */
		opt_string[0] = '\0';
		switch(bdhere[i] & BDTYPEMASK) {
			case SPMTYPE: 
				printf("SPM    ");
				break;
			case MEMTYPE: 
				printf("MM     ");
				/* read id, and move it down */
				arg = bdidsl(i); 
				mem_type = 
					(get_mem_size(arg, 0) & MEM_TYPE_MASK);
				strcpy (opt_string, MEM_TYPE[mem_type]);
				break;
			case CPUTYPE: 
				printf("PM     ");
				break;
			case DPMTYPE: 
				printf("DPM    ");
				break;
			case IOMTYPE: 
				printf("IOM    ");
				break;
			case IOPTYPE: 
				printf("IOPM   ");
				break;
			case VAMTYPE: 
				printf("VAM    ");
				break;
			case NOBOARDTYPE:
				continue;
				break;
			default: printf("UNKNOWN"); break;
		}
		printf(" module in slot 0x%x (%d) %s\n", i, i, opt_string);
	}
}

int
get_mem_size(arg, ret_flag)
uint	arg;
uint	ret_flag;	/* if 0 returns offset in MEM_TYPE array, log2( size) */
			/* if 1 returns size in MEG's		  */
{
	uint size;
	uint ret_val;
	
	if (arg & MM_4MBIT_RAM)
		size = 128;
	else	
		size = 32;

	switch (arg & MM_STUFFING_MASK) {
		case MM_FULLY_STUFFED:
			break;
		case MM_HALF_STUFFED:
			size = size / 2;
			break;
		case MM_QUARTER_STUFFED:
			size = size / 4;
			break;
		case MM_EIGTH_STUFFED:
			size = size / 8;
			break;
		case MM_SIXTEENTH_STUFFED:
			size = size / 16;
			break;
		default:
			size = 0;
			break;
	}
	if (ret_flag)
		return(size);

	ret_val = 0;
	while (size > 1) {
		size = size / 2;
		ret_val++;
	}

	return(ret_val);
}

/*------------------------------------------------------------------------------
	bdidsl : Read the board id, but don't disturb map ram.
------------------------------------------------------------------------------*/
bdidsl(slot)
int slot;
{
	uint *ptr1 = (uint *)0x8ffffffc;	/* board id pointer. */
	uchar was;
	uint id;

	was = cssmap_save(MAP00);
	cssmap (MAP00, (uchar)slot, 0x0f);
	id = *ptr1;					/* Get data. */
	cssmap_restore (MAP00, was);
	return(id);					/* And send it back. */
}

/*------------------------------------------------------------------------------
	findmem : Find first mem board slot number.
------------------------------------------------------------------------------*/
findmem(prt)
int prt;
{
	int i;

	if(!validmap)   /* if not valid make a table */
		pollslot(0);

	for(i = 0; i < Sbus_Num_Slot; i++)		/* All slots */
		if(bdhere[i] == MEMHERE) /* Found one.. */
			return(i);			/* Send it back. */

	if(prt)
		printf("Could not find RAM card.\n");
	return(18);					/* Return bad status. */
}

/*
show_em
*/
int
show_em (comm_str, arg_cnt)
char *comm_str;
int arg_cnt;
{

	if (arg_cnt == 0) { /* show both for default */
		show_css_table ();
		iotbl ();
		return(0);
	}

	/* show CSS stuff */
	if ((strcmp (comm_args[1], "css") == 0) || 
					(strcmp (comm_args[1], "CSS") == 0)) {
		show_css_table ();
		return(0);
	}

	/* show I/O stuff */
	if ((strcmp (comm_args[1], "I/O") == 0) || 
					(strcmp (comm_args[1], "i/o") == 0)) {
		iotbl ();
		return(0);
	}

	printf ("Illegal %s option <%s>, <css>/<i/o> allowed.\n", 
		comm_args[0], comm_args[1]); 
	return(1);
}

