/*----------------------------------------------------------------------------
	pm20_test.c

	used only in SPM_CONFIG product for PM test purposes
-----------------------------------------------------------------------------*/

#include "types.h"
#include "misc.h"
#include "globl.h"
#include "spm.h"
#include "rwicio.h"
#include "iom.h"
#include "ioa0.h"
#include "disp.h"
#include "rwi.h"
#include "novram.h"
#include "ipcc.h"

extern struct	slotst	sf;	/* boards enable/disable */
extern uchar	bdhere[];	/* slots for CSS board's... */
extern char	got_berr;	/* added by YVC at 2/1/88 for testing IOM */
extern char	emulate;	/* added by YVC at 2/1/88 for testing IOM */
extern char	tsterrs;	/* this is set to zero when we want to. */
extern char	ignore_it;	/* If set, ignore CSS bus errors. */
extern char	cpuack;		/* set if we want to only print out junk. */
extern char	ipcctest;	/* set ipcc flag to handle spy test. */
extern uchar	myslot;		/* This is where I am. */
extern char	cputest2;	/* cpu board stage 2 test flag . */

static uint	mailstat;	/* data from id mail byte. */
static char	ram_sl;		/* set to first valid ram slot */

#define	IF_ESC	if (ifesc()) { cpu_idle(0,0); return; }
#define	IF_ESC1	if (ifesc()) { cpu_idle(0,0); return(1); }
#define	MAILBOX	0xdffffffc

/*------------------------------------------------------------------------------
	The error codes returned by PM after PM tests.
------------------------------------------------------------------------------*/
static char *pmerr1[]={
	"",					/* 00 */
	"Data Store",				/* 01 */
	"CTAG",					/* 02 */
	"BTAG",					/* 03 */
	"TLB",					/* 04 */
	"MTAG",					/* 05 */
	"FLUSH Function",			/* 06 */
	"ROOT pointers",			/* 07 */
	"INTERRUPT request",			/* 08 */
	"BUS parity",				/* 09 */
	"RCV Funnel",				/* 10 */
	"MOVML",				/* 11 */
	"R-perm",				/* 12 */
	"W-perm",				/* 13 */
	"X-perm",				/* 14 */
	"PAGE fault",				/* 15 */
	"NAK",					/* 16 */
	"TIMEOUT",				/* 17 */
	"BAD I/O",				/* 18 */
	"TABLE WALK",				/* 19 */
	"CACHE Read_Hit",			/* 20 */
	"CACHE Read_Miss",			/* 21 */
	"CACHE Write Through",			/* 22 */
	"CACHE Write Miss",			/* 23 */
	"",					/* 24 */
	"",					/* 25 */
	"SPY",					/* 26 */
	"W-Space Exception",			/* 27 */
	"Fault Reg. : Wrong Space",		/* 28 */
	"Fault Reg. : BERROR",			/* 29 */
	"Fault Reg. : SINCE",			/* 30 */
	"Fault Reg. : Wrong Co-proc",		/* 31 */
	"Fault Reg. : Busy",			/* 32 */
	"Fault Reg. : Cmd-Pending",		/* 33 */
	"MMU Power-Up",				/* 34 */
	"Unknown Error code."
};

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
cputest(tst)	/* do first stage cpu test for all cpu's. */
int tst;	/* what test numbers to start. */
{
	int pm_slot;
	int err;

	cputest2 = 1;
	for (pm_slot = 0; pm_slot != Sbus_Num_Slot; pm_slot++) {  /* all cpu */
		if (bdhere[pm_slot] != CPUHERE) 	/* if it's not here.. */
			continue;		/* Continue to next slot.. */

		switch (tst) {
			case 1:
				err = test1cpu(pm_slot);
				break;
			case 2:
				err = test2cpu(pm_slot);
				break;
			case 3:
				err = test3cpu(pm_slot);
				break;
			default:
				printf("\nProgrammer error. (%d)\n", tst);
				cputest2 = 0;
				return(1);
		}

		if (err) {			/* it failed the test... */
			/*
			**	print error mesage
			**	disable cpu
			**	remove from bdhere
			**	set sf struct to 0
			*/

			printf("\nPM in slot %d failed Stage%d\n", pm_slot,tst);
			bdhere[pm_slot] = NOBOARD;
			sf.on[pm_slot] = 0;
		}
	}
	cputest2 = 0;
	return(err);	/* go back giving error status. */
}


/*------------------------------------------------------------------------------
	readmail : Monitors the status byte from the PM(s).
			   Changes have been implemented for the SPEC change.
------------------------------------------------------------------------------*/
readmail()	/* read in a mail byte. */
{
	register uint *ptr = (uint *)MAILBOX;  /* pointer to read from. */
	register uint ar[3];		/* three times; for fun. */
	register i, i1=0;			/* counters. */

	while (1) {				/* loop. */

		for (i = 0; i < 3; i++)			/* fill in array.. */
			ar[i] = *ptr & 0x0000ff00;	/* get and save data. */

		if (got_berr) {		
			if (++i1 == 20)		/* If really bad */
				return(1);			

			got_berr = 0;		/* clear bus error flag. */
			continue;		/* loop back... */
		}
		if (ar[0] != ar[1] || ar[0] != ar[2]) { /* some didn't match. */
		
			if (++i1 == 20) 
				return(1);

			i1 = 0;			/* give it a try again.. */
			continue;
		}
		break;			/* it's ok, so break out of loop. */
	}

	mailstat = ar[0];		/* ok, write it out. */
	return(0);
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
test1cpu(slot) /* do phase 1 tests for a single cpu. */
int slot;
{
	int err_code;

	emulate = 1;				/* skip all bus errors.. */
	got_berr = 0;				/* clear this. */

	cssmap(MAP05, (uchar)slot, (uchar)0xf);

	if (readmail()) {		/* read in the mail byte from array. */
		emulate = 0;		/* clear this. */
		return(1);		/* failed id read, so it's bad. */
	}

	if (mailstat & 0x0000ff00) {	/* mask other bits off.. */

		if (mailstat & 0x00007f00) {	/* mask busy and bad bits */
			err_code = ((mailstat & 0x7F00) >> 8);
			if (err_code < (sizeof(pmerr1) / sizeof(char *)))
				printf("\nPM stage 1 error code: %s\n",
				pmerr1[err_code]);
			else
				printf("\nPM stage 1 error:  Unknown error code.\n");
			emulate = 0;
			return(1);	/* this board failed. */
		}
	}
	emulate = 0;	/* restore bus error handler.. */
	return(0);
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
test2cpu(slot) /* do phase 2 tests for a single cpu. */
int slot;
{
	int i, i1;
	int err_code;

	cssmap(MAP05, (uchar)slot, (uchar)0xf);

	tsterrs = 0;		/* enable reporting of ack's.. */
	cpuack = 1;		/* show we ARE expecting this. */

	if (ipccsend(slot,IPCC_SM_SLOT,(int)myslot))	/* Send SPM slot. */
		return(1);		

	if (ipccsend(slot,IPCC_MM_SLOT,(int)ram_sl))	/* Send MEM slot. */
		return(1);

	if (ipccsend(slot,IPCC_PM_PUTR,(int)2))		/* Start phase 2 test */
		return(1);

	ignore_it = emulate = tsterrs = 1;	/* disable all bus errors..*/
	cpuack = got_berr = 0;			/* clear these. */

	for (i = 0; i < 0x400; i++) {		/* while waiting.. */
		if (readmail()) {
			printf("\nRead CPU in slot %x mail failed\n",slot);
			ignore_it = emulate = tsterrs = 0; /* enable errors..*/
			return(1);		/* failed, so it's bad. */
		}

		if (!(mailstat & 0x00008000))	/* check busy bit */
			break;		

		for (i1 = 0; i1 < 3000; i1++);	/* pause for a moment */

		if (ifesc()) 
			return(0);	/* allow exiting for next pm. */
	}

	emulate = tsterrs = ignore_it = 0;	/* enable normal bus errors..*/
	if (mailstat & 0x00007f00) {		/* mask busy bit off.. */
		err_code = ((mailstat & 0x7F00) >> 8);
		if (err_code < (sizeof(pmerr1) / sizeof(char *)))
			printf("\nPM stage 2 error code: %s\n",
			pmerr1[err_code]);
		else
			printf("\nPM stage 2 error:  Unknown error code.\n");
		emulate = 0;
		return(1);	/* this board failed. */
	}

	return(0);
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
test3cpu(slot) /* do phase 3 tests for a single cpu. */
int slot;
{
	int i, i1=0x2fff;
	int err_code;

	tsterrs = 0;			/* enable reporting of ack's.. */
	cpuack = 1;			/* show we ARE expecting this. */
	ipcctest = 1;			/* Use a different INT handler. */

	cssmap(MAP05, (uchar)slot, (uchar)0xf);

	if (ipccsend(slot,IPCC_SM_SLOT,(int)myslot))	/* Send SPM slot. */
		return(1);

	if (ipccsend(slot,IPCC_MM_SLOT,(int)ram_sl))	/* Send MEM slot. */
		return(1);

	if (ipccsend(slot,IPCC_PM_PUTR,(int)3))		/* Start phase 3 test */
		return(1);

	emulate = tsterrs = ignore_it = 1;		/* disable bus errors */
	cpuack = got_berr = 0;				/* clear these. */

	while (i1--) {

		for (i = 0; i < 5000; i++);
		if (readmail()) {	/* read in the mail from array. */
			emulate = tsterrs = ignore_it = 0; /* enable errors..*/
			printf("\nFailed while reading mailbox register.\n");
			return(1);	/* failed id read, so it's bad. */
		}

		if (ifesc()) 
			break;

		if (!(mailstat & 0x00008000))	/* check busy bit */
			break;	

		if (ifesc()) 
			return(0);		/* allow exiting for next pm. */
	}
	emulate = tsterrs = ignore_it = 0;	/* enable normal bus errors..*/

	if ((!i1) || (i1<0)) {
		printf("\nTimed out on stage 3:\n");
		printf("Mail status is %x.\n",mailstat);
		return(1);
	}

	if (mailstat & 0x7f00) 	{	/* mask busy & error bits off.. */
		err_code = ((mailstat & 0x7F00) >> 8);
		if (err_code < (sizeof(pmerr1) / sizeof(char *)))
			printf("\nPM stage 3 error code: %s\n",
			pmerr1[err_code]);
		else
			printf("\nPM stage 3 error:  Unknown error code.\n");
		emulate = 0;
		return(1);	/* this board failed. */
	}

	ipcctest = 0;		/* reset this */
	return(0);
}


pm20_test()
{
	printf("\rTesting the PM (68020) boards.     \n");

	/* set memory board that is going to be used */
	if ((ram_sl = findmem(1)) == 18) {	/* find first memory board */
		printf("\nNo MM to conduct PM test\n");
		return(1);
	}

	printf("\rStage 1 CPU powerup.          ");
	if (cputest(1)) { 
		cpu_idle(0,0);		/* if failed 1st stage test.. */
		return(1); 
	}	

	IF_ESC1

	printf("\rStage 2 CPU powerup.          ");
	if (cputest(2)) { 
		cpu_idle(0,0);		/* if failed 2nd stage test.. */
		return(1);	
	}	

	IF_ESC1

	printf("\rStage 3 CPU powerup.          ");
	if (cputest(3)) {	
		ipcctest = 0;		/* failed third stage tests.. */
		return(1);
	}

	return(0);
}
