/* periph.c
 *	program to init the ascc  (Zilog 8031)             
 *	and the cio   (Zilog 8036)
 */


#include "types.h"
#include "spm.h"
#include "ascc.h"
#include "rwi.h"
#include "rwicio.h"
#include "misc.h"
#include "globl.h"
#include "novram.h"

extern	struct	novram	*novram;

extern  uint  long_throw;

struct baud baudtab[] = {
	38400,0x00, 0x01,
	19200,0x00, 0x04,
	9600, 0x00, 0x0a,
	4800 ,0x00, 0x16,
	2400, 0x00, 0x2e,
	1200, 0x00, 0x5e,
	300,  0x01, 0x7e,
	0,    0x00, 0x5e	/* 1200 is default */
};

uchar	modem_baud_num;
uchar	console_baud_num;
uchar	printer_baud_num;
uchar	ups_baud_num;

initscc()
{
	register struct ascc *CONSOLE = AUXASCC0A;	/* port 0 */
	register struct ascc *MODEM = AUXASCC0B;	/* port 1 */
	register struct ascc *PRINTER = AUXASCC1A;	/* port 0 */
	register struct ascc *UPS = AUXASCC1B;	/* port 1 */
	uint	count; 				/*  loop counter */

	CONSOLE->reg[9].reg = WR9_HRST; /* hard reset first. */
	
	CONSOLE -> reg[0].reg = WR0_SHL;
	
	CONSOLE -> reg[4].reg = WR4_1STOP | WR4_16CLOCK;
	MODEM -> reg[4].reg = WR4_1STOP | WR4_16CLOCK;

	CONSOLE -> reg[1].reg = 0; /* */
	MODEM -> reg[1].reg = WR1_EXTEN;
	
	CONSOLE -> reg[2].reg = SCC0_VECT;

	CONSOLE -> reg[3].reg = WR3_RX8;
	MODEM -> reg[3].reg = WR3_RX8;
	
	CONSOLE -> reg[5].reg = WR5_DTR | WR5_TX8 | WR5_RTS;
	MODEM -> reg[5].reg = WR5_DTR | WR5_TX8 | WR5_RTS;
	
	CONSOLE -> reg[11].reg = WR11_RCGO | WR11_TCGO;
	MODEM -> reg[11].reg = WR11_RCGO | WR11_TCGO;
	
	for (count = 0; baudtab[count].bdrate; count++) {
		if (novram->modem_baud_rate == baudtab[count].bdrate) {
			if (baudtab[count].bdrate) {
				modem_baud_num = count;
			}
			else {
				modem_baud_num = 5;
				novram->modem_baud_rate = baudtab[5].bdrate;
				novram->shared_crc = nov_chk_sum(2);
			}
			break;
		}
	}
	MODEM -> reg[12].reg = baudtab[count].bdlsb;
	MODEM -> reg[13].reg = baudtab[count].bdmsb;

	for (count = 0; baudtab[count].bdrate; count++) {
		if (novram->console_baud_rate == baudtab[count].bdrate) {
			if (baudtab[count].bdrate) {
				console_baud_num = count;
			}
			else {
				console_baud_num = 5;
				novram->console_baud_rate = baudtab[5].bdrate;
				novram->shared_crc = nov_chk_sum(2);
			}
			break;
		}
	}
	CONSOLE -> reg[12].reg = baudtab[count].bdlsb;
	CONSOLE -> reg[13].reg = baudtab[count].bdmsb;
	
	CONSOLE -> reg[14].reg = WR14_PCLK; /* enable source only. */
	MODEM -> reg[14].reg = WR14_PCLK; /* enable source only. */
	
	CONSOLE -> reg[3].reg = WR3_RX8 | WR3_RXEN;
	MODEM -> reg[3].reg = WR3_RX8 | WR3_RXEN;
	
	CONSOLE -> reg[5].reg = WR5_DTR | WR5_TX8 | WR5_TXEN | WR5_RTS;
	MODEM -> reg[5].reg = WR5_DTR | WR5_TX8 | WR5_TXEN | WR5_RTS;

	CONSOLE -> reg[0].reg = WR0_RXCRC; /* */
	MODEM -> reg[0].reg = WR0_RXCRC; /* */

	CONSOLE -> reg[14].reg = WR14_ENABD | WR14_PCLK; /* enable bd gen */
	MODEM -> reg[14].reg = WR14_ENABD | WR14_PCLK; /* enable bd gen */
	
	CONSOLE -> reg[15].reg = 0;
	MODEM -> reg[15].reg = WR15_DCDIE | WR15_BRKIE;
	
	CONSOLE->reg[0].reg = 0; /* clear the reset. */
	MODEM->reg[0].reg = WR0_EXINT; /* clear the reset. */
	CONSOLE -> reg[9].reg = WR9_MIE | WR9_VIS; 

	if (ACRW_HERE)
		return;

	PRINTER->reg[9].reg = WR9_HRST; /* hard reset first. */
	
	PRINTER -> reg[0].reg = WR0_SHL;
	
	PRINTER -> reg[4].reg = WR4_1STOP | WR4_16CLOCK;
	UPS -> reg[4].reg = WR4_1STOP | WR4_16CLOCK;

	PRINTER -> reg[1].reg = 0; /* */
	UPS -> reg[1].reg = 0;
	
	PRINTER -> reg[2].reg = SCC1_VECT;

	PRINTER -> reg[3].reg = WR3_RX8;
	UPS -> reg[3].reg = WR3_RX8;
	
	PRINTER -> reg[5].reg = WR5_DTR | WR5_TX8 | WR5_RTS;
	UPS -> reg[5].reg = WR5_DTR | WR5_TX8 | WR5_RTS;
	
	PRINTER -> reg[11].reg = WR11_RCGO | WR11_TCGO;
	UPS -> reg[11].reg = WR11_RCGO | WR11_TCGO;
	
	for (count = 0; baudtab[count].bdrate; count++) {
		if (novram->printer_baud_rate == baudtab[count].bdrate) {
			if (baudtab[count].bdrate) {
				printer_baud_num = count;
			}
			else {
				printer_baud_num = 5;
				novram->printer_baud_rate = baudtab[5].bdrate;
				novram->shared_crc = nov_chk_sum(2);
			}
			break;
		}
	}
	PRINTER -> reg[12].reg = baudtab[count].bdlsb;
	PRINTER -> reg[13].reg = baudtab[count].bdmsb;

	for (count = 0; baudtab[count].bdrate; count++) {
		if (novram->ups_baud_rate == baudtab[count].bdrate) {
			if (baudtab[count].bdrate) {
				ups_baud_num = count;
			}
			else {
				ups_baud_num = 5;
				novram->ups_baud_rate = baudtab[5].bdrate;
				novram->shared_crc = nov_chk_sum(2);
			}
			break;
		}
	}
	UPS -> reg[12].reg = baudtab[count].bdlsb;
	UPS -> reg[13].reg = baudtab[count].bdmsb;
	
	PRINTER -> reg[14].reg = WR14_PCLK; /* enable source only. */
	UPS -> reg[14].reg = WR14_PCLK; /* enable source only. */
	
	PRINTER -> reg[3].reg = WR3_RX8 | WR3_RXEN;
	UPS -> reg[3].reg = WR3_RX8 | WR3_RXEN;
	
	PRINTER -> reg[5].reg = WR5_DTR | WR5_TX8 | WR5_TXEN | WR5_RTS;
	UPS -> reg[5].reg = WR5_DTR | WR5_TX8 | WR5_TXEN | WR5_RTS;

	PRINTER -> reg[0].reg = WR0_RXCRC; /* */
	UPS -> reg[0].reg = WR0_RXCRC; /* */

	PRINTER -> reg[14].reg = WR14_ENABD | WR14_PCLK; /* enable bd gen */
	UPS -> reg[14].reg = WR14_ENABD | WR14_PCLK; /* enable bd gen */
	
	PRINTER -> reg[15].reg = 0;
	UPS -> reg[15].reg = 0;  
	
	PRINTER->reg[0].reg = 0; /* clear the reset. */
	UPS->reg[0].reg = 0; /* clear the reset. */
	PRINTER -> reg[9].reg = WR9_MIE | WR9_VIS; 

}

	
initcio()
{
	register struct cio *cioptr = LOCCIO;
	register unsigned addr;

	*WRCNTL1 &= ~WR1_RRDY;	 /* */
/*
We have found a hardware problem that causes (sometimes) a garbage
grant onto the css bus. In order to not add 5 wires and 2 cuts to the
hardware board, we have to hold the css reset while we reset the cio.
what a bunch of junk.  Causes a lot of problems in other software, but
they say it's easier for me to screw up clean code than to fix hardware.
*/

	*WRCNTL1 &= ~WR1_CSSRST;	


	cioptr -> mic = C_RESET;		/* software reset */	
	cioptr -> mic = 0;			/* take away the reset */
	cioptr -> mic = C_CTVIS;		/* vector includes status*/
	cioptr -> ctmode[0].reg = CT_CONT;	/* continuous single cycle */
	cioptr -> ctcs[0].reg = ICW_CPUS;	/* clear int pend & serv */
	cioptr -> ctcs[0].reg = ICW_SIE;	/* interrupt enable */
	cioptr -> cttc[0].tcmsb = 0xc3;		/* current count msb */
	cioptr -> cttc[0].tclsb = 0x50;		/* current count lsb */
	cioptr -> ctivect = 0x40; 

	cioptr -> ctmode[2].reg = CT_EOE | CT_ETE | CT_PULSE | CT_REB | CT_EGE;
	cioptr -> ctcs[2].reg = ICW_CPUS;
	cioptr -> ctcs[2].reg = ICW_CIE | CT_GCB;
	cioptr -> cttc[2].tcmsb = 0x02;		/* tc/2.5MHz = 250us */
	cioptr -> cttc[2].tclsb = 0x71;		/* timeout=250us */
	cioptr -> pcdpp = 0x0f;			/* inverting */
	cioptr -> pcdd = 0x0e;

/* see above comment about junk.  Do not remove unless hardware is fixed!! */

	*WRCNTL1 |= WR1_CSSRST;


	/* start out system clock */
	cioptr -> mcc = C_CT1E | C_PCCT3E;		/* timer 1,3 enable */
	cioptr -> ctcs[0].reg =ICW_SIE | CT_GCB | CT_TCB; /*  start timer 1 */
/*	cioptr -> mic = C_MIE | C_CTVIS;  		/*  enable CIO ints */

/*
**	SMALL TIME KLUDGE.......
**	
**	If this is removed, a CSS Bus Error occurs when the sequence
**	pwroff - pwron is done.  All this does is read
**	WRCNTL0. WRCNTL1, WRCNTL2, STAT REG, CSSCMD, DISP ERR REG, CSS ERR REG
**	8 times each.
**
*/
	for (addr = 0x07000000; addr != 0x07000100; addr += 4)
		long_throw = *(unsigned *)addr;


	if(powmain() && !(*STATUSREG &0x20000000)) {  /* power on, css_clock */
		init_css(); /* make sure this got setup. */
		*WRCNTL1 |= WR1_RRDY; /* */
		iready();
	}
}

