
/*------------------------------------------------------------------------------
	nov_init.c
------------------------------------------------------------------------------*/
#include "spm.h"
#include "types.h"
#include "novram.h"
#include "disp.h"
#include "ioa0.h"
#include "icb.h"
#include "icb_config.h"
#include "rwi.h"
#include "globl.h"
#include "global.h"
#include "rwi.h"
#include "rwicio.h"
#include "rwiad.h"
#include "dev.h"

/*
**	Updated to allow structure changes for iosba
**	2 or less 1.8.7 and no IOSBA; 3 or greater 2.x IOSBA supported
*/
#define NOVRAM_VER	3
#define OLD_NOVRAM_VER	2

extern uchar bdhere[];
extern struct icb_config	io_conf[][MAXSLOTS];
extern struct iosb_config	ios_conf[][MAX_CSS_SLOT];
extern char comm_args[][MAXARGSIZE];
extern uchar *buff;
extern uint ps_num;			/* Power supply pointer. */
extern char	validmap;

extern struct novram *novram;		/* Points to Base of NVRAM. */
extern struct new_novram *new_novram;	/* Points to Base of NVRAM */
extern uchar	myslot;

/*------------------------------------------------------------------------------
	nvinit() : Nvram intializition.
------------------------------------------------------------------------------*/
nvinit(comstr, argcnt)
char *comstr;
int argcnt;
{
	char x;

	if (!validmap) {
		printf ("Configuration Table not valid, execute cl css.\n");
		return(1);
	}

	if(!argcnt) {
		nov_reconfig(1);
		return(0);
	}
	else {
		if(((x = (char)atoi(comm_args[1])) < 0) || (x > 2)) {
			invld();
			return(1);
		}
		nov_reconfig(x);
	}
	return(0);
}
/*------------------------------------------------------------------------------
	nov_reconfig(crcbad) :	Reconfigure the novram.
				crcbad = Level of reconfiguration.
------------------------------------------------------------------------------*/
nov_reconfig(crcbad)
int crcbad;	/* if set, then it's a bad crc; assume never initilized. */
{
	int c;

	if(!crcbad) {		/* just a configuration error. */
		printf("\nWarning: NV RAM configuration needs updating. (y/n)");
		c = getchar();	/* get one character in, no macro buffer. */
		printf("%c\n",(char)c);	/* show character input. */
		if(c != 'y')		/* if didn't say yes.. */
			return;		/* skip reconfigure. */

		nov_def_path();		/* Initialize the boot pathname. */
	}

	if(crcbad==1) {
		printf("\nNV RAM: System and RWI configurations being initialized.\n");
		init_novram(1);		/* go init it. */
		nov_def_path();		/* Initialize the boot pathname. */
	}

	if(crcbad==2) {
		printf("\nNon-volatile RAM is being completely re-configured.\n");
		init_novram(2);		/* go init it. */
		update_boot_path (3);
	}

	init_novram_config();	/* init the novram now, since it's bad. */
	novram->prom_crc = nov_chk_sum(0);
	novram->shared_crc = nov_chk_sum(2);
}


/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
init_novram(level)
char level;
{
	register unsigned char *ptr;
	struct	novram	*nov_save;
	int	cnt;

	ps_num=0;

	nov_cpy (novram, buff);	/* save original novram, for recovery */
	nov_save = (struct novram *)buff;

	/* Clear the novram from css_slot location to start of software area. */
	if(level==1) {
		for(ptr = (uchar *)&novram->css_slot[0];
				ptr < (uchar *)&novram->main_pwr[0]; ptr++) 
			*ptr = 0xFF; 

		for(ptr = (uchar *)&novram->main_pwr[0];
				ptr < (uchar *)&novram->runtime_crc; ptr++) 
			*ptr = 0x00; 

		novram->autoboot = 1;			/* autobooting on. */
		novram->diag_fly_by = 0;		/* do the diag. */
		novram->boot_dev = 0;			/* default to H/D. */
	}

	if(level==2) {
		for(ptr = (unchar *)NOVRAM; 
				ptr < (unchar *)&novram->css_slot[0]; ptr++)
			*ptr = 0x00; 

		for(ptr = (uchar *)&novram->css_slot[0];
				ptr < (uchar *)&novram->main_pwr[0]; ptr++) 
			*ptr = 0xFF; 

		for(ptr = (uchar *)&novram->main_pwr[0];
				ptr < (unchar *)&novram->shared_crc; ptr++) 
			*ptr = 0x00; 

		novram->autoboot = 1;			/* autobooting on. */
		novram->diag_fly_by = 0;		/* do the diag. */
		novram->boot_dev = 0;			/* default to H/D. */
	}

	if(level==3) {
		for(ptr = (unchar *)&novram->inlet_air_low_warning;
			      ptr < (unchar *)&novram->console_baud_rate; ptr++)
			*ptr = 0x00; 
	}

	find_systype();				/* go get sys type */
	if(novram->sys_type & SYS_25){		/* if this is a 25 */
		novram->fan_stat = ENABLE_FAN_ALRM;
	}
	else{
		novram->fan_stat = DISABLE_FAN_ALRM;
	}

	/* Restore some values from the saved copy */
	novram->novram_ver = nov_save->novram_ver; /* restore val */
	novram->keywas=nov_save->keywas;	/* Restore key value. */
	novram->cmdwas=nov_save->cmdwas;	/* Restore command value. */
	novram->pwrstat=nov_save->pwrstat;	/* Restore power stat value. */
	novram->newpwr=nov_save->newpwr;	/* Restore new pwr indicator */
	novram->modem_baud_rate = nov_save->modem_baud_rate;
	novram->console_baud_rate = nov_save->console_baud_rate;
	novram->printer_baud_rate = nov_save->printer_baud_rate;
	novram->ups_baud_rate = nov_save->ups_baud_rate;
	novram->modem_active = nov_save->modem_active;
	novram->printer_active = nov_save->printer_active;
	for (cnt = 0; cnt != PASSWORD_LENGTH; cnt++)
		novram->password[cnt] = nov_save->password[cnt];
	for (cnt = 0; cnt != PATH_LENGTH; cnt++)
		novram->spm_boot_disk[cnt] = nov_save->spm_boot_disk[cnt];
	for (cnt = 0; cnt != PATH_LENGTH; cnt++)
		novram->diag_boot[cnt] = nov_save->diag_boot[cnt];

	novram->inlet_air_low_warning = adc_conv(INLET_AIR,5,0);
	novram->inlet_air_high_warning = adc_conv(INLET_AIR,40,0);
	novram->inlet_air_low_shutdown = adc_conv(INLET_AIR,0,0);
	novram->inlet_air_high_shutdown = adc_conv(INLET_AIR,55,0);

	novram->exhaust_air_low_warning = adc_conv(EXHAUST_AIR,5,0);
	novram->exhaust_air_high_warning = adc_conv(EXHAUST_AIR,48,0);
	novram->exhaust_air_low_shutdown = adc_conv(EXHAUST_AIR,0,0);
	novram->exhaust_air_high_shutdown = adc_conv(EXHAUST_AIR,60,0);

	novram->main_ps_temp_low_warning = adc_conv(PS_TEMP,5,0);
	novram->main_ps_temp_high_warning = adc_conv(PS_TEMP,45,0);
	novram->main_ps_temp_low_shutdown = adc_conv(PS_TEMP,0,0);
	novram->main_ps_temp_high_shutdown = adc_conv(PS_TEMP,60,0);

	novram->five_volt_low_warning = adc_conv(MAIN_FIVE_VOLT,4,7);
	novram->five_volt_high_warning = adc_conv(MAIN_FIVE_VOLT,5,3);
	novram->five_volt_low_shutdown = adc_conv(MAIN_FIVE_VOLT,4,5);
	novram->five_volt_high_shutdown = adc_conv(MAIN_FIVE_VOLT,5,7);

	novram->twelve_volt_low_warning = adc_conv(MAIN_TWELVE_VOLT,11,4);
	novram->twelve_volt_high_warning = adc_conv(MAIN_TWELVE_VOLT,12,6);
	novram->twelve_volt_low_shutdown = adc_conv(MAIN_TWELVE_VOLT,11,0);
	novram->twelve_volt_high_shutdown = adc_conv(MAIN_TWELVE_VOLT,13,0);

	novram->neg_twelve_volt_low_warning = 
					adc_conv(MAIN_NEG_TWELVE_VOLT,11,4);
	novram->neg_twelve_volt_high_warning = 
					adc_conv(MAIN_NEG_TWELVE_VOLT,12,6);
	novram->neg_twelve_volt_low_shutdown = 
					adc_conv(MAIN_NEG_TWELVE_VOLT,11,0);
	novram->neg_twelve_volt_high_shutdown = 
					adc_conv(MAIN_NEG_TWELVE_VOLT,13,0);

	novram->five_volt_current_warning = 
					adc_conv(MAIN_FIVE_VOLT_CURRENT,235,0);
	novram->five_volt_current_shutdown = 
					adc_conv(MAIN_FIVE_VOLT_CURRENT,281,0);

	novram->cage_air_low_warning = adc_conv(CAGE_AIR,5,0);
	novram->cage_air_high_warning = adc_conv(CAGE_AIR,42,0);
	novram->cage_air_low_shutdown = adc_conv(CAGE_AIR,0,0);
	novram->cage_air_high_shutdown = adc_conv(CAGE_AIR,60,0);

	novram->cage_air_delta = adc_conv(CAGE_AIR,15,0);
	novram->rshutdown = 0;
	novram->rwi_val_crc = nov_chk_sum(1);
}


/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
init_novram_config()
{
	register unsigned sbus;
	register int chan, mux, i;

	if (!validmap) {
		printf ("Configuration Table not valid, execute cl css.\n");
		return;
	}

	novram->main_pwr[0].ps_id = SWITCHING_POWER;	/* Default. */
	novram->main_pwr[0].scale_factor = SW_VOLTS_PER_AMP; /* 160	 */
	novram->main_pwr[0].five_volt = 1;		/* Enable Sensor. */
	novram->main_pwr[0].twelve_volt = 1;		/* Enable Sensor. */
	novram->main_pwr[0].neg_twelve_volt = 1;	/* Enable Sensor. */
	novram->main_pwr[0].five_volt_current = 1;	/* Enable Sensor. */
	novram->main_pwr[0].temp = 1;			/* Enable Sensor. */

	novram->cab_present[0].present = 1;		/* At least One. */
	if (ACRW_HERE) {
		novram->cab_present[0].inlet_air = 0;	/* Disable sensor. */
		novram->cab_present[0].exhaust_air = 0;	/* Disable sensor. */
	}
	else {
		novram->cab_present[0].inlet_air = 1;	/* Enable sensor. */
		novram->cab_present[0].exhaust_air = 1;	/* Enable sensor. */
	}

	for(i = 1, mux=0x20, chan=0; i < 7; i++, mux+= 0x20) {

		if(mux > 0x70) {		/* past last one here.. */
			mux = 0;
			chan+=2;		/* next channel number. */
		}

		if(readsensor(mux,chan)) { 
			novram->cab_present[i].present = 1; /* Cabinet here. */
			novram->cab_present[i].inlet_air = 1; /* Enable. */
			novram->cab_present[i].exhaust_air = 1;	/* Enable. */
		}
		else {
			novram->cab_present[i].present = 0;	/* no cabinet */
			novram->cab_present[i].inlet_air = 0;	/* Disable. */
			novram->cab_present[i].exhaust_air = 0;	/* Disable. */
		}
	}

	for(i = 1, mux=0x10, chan=3; i < 5; i++, mux+= 0x10)
		if(readsensor(mux,chan)) {		/* read cabinet temps */
			novram->main_pwr[i].ps_id = SWITCHING_POWER;
			novram->main_pwr[i].scale_factor = SW_VOLTS_PER_AMP; 
			novram->main_pwr[i].five_volt = 1;
			novram->main_pwr[i].twelve_volt = 1;	
			novram->main_pwr[i].neg_twelve_volt = 1;
			novram->main_pwr[i].five_volt_current = 1;
			novram->main_pwr[i].temp = 1;	
		}
		else {
			novram->main_pwr[i].ps_id = 0xff;  /* else, not here. */
			novram->main_pwr[i].scale_factor = 0;
			novram->main_pwr[i].five_volt = 0;
			novram->main_pwr[i].twelve_volt = 0;
			novram->main_pwr[i].neg_twelve_volt = 0;
			novram->main_pwr[i].five_volt_current = 0;
			novram->main_pwr[i].temp = 0;		
		}
	for(sbus = 0; sbus < Sbus_Num_Slot; sbus++) {
		novram->css_slot[sbus] = bdhere[sbus];
	}
	novram_io();
}


/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
novram_io()	/* Store the io configuration NOVRAM.*/
{
	uchar	iom_num;
	uchar	iosba_here = 0;

	for(iom_num = 0; iom_num < IOM_PER_SYS; iom_num++) { /* iosba here?? */
		if (ios_conf[iom_num][0].iomslot != NOBOARD) {
			iosba_here = 1;
			break;
		}
	}

	if (iosba_here) {
		novram_iosba();
		novram->novram_ver = NOVRAM_VER;
	}
	else {
		novram_ioa();
		novram->novram_ver = OLD_NOVRAM_VER;
	}

	return(0);
}


novram_iosba()
{
	uint	slot;
	uint	sub;
	uchar	iom_num;

	iom_num = 0;
	for(iom_num = 0; iom_num != IOM_PER_SYS; iom_num++) {  /* clear them */
		new_novram->new_iom_slot[iom_num].iom_slot = NOBOARD;
		new_novram->new_iom_slot[iom_num].ext_bd_type = NOBOARD;
		for(sub = 0; sub <= MAX_IO_SLOT; sub++)
			new_novram->new_iom_slot[iom_num].io_bds.icb_slot[sub] =
				NOBOARD;
			/*  This is taking advantage of the fact the union
			**  will have constant size.  This loop initializes 
			**  19 locations, however, the ios portion has only 
			**  16 elements.
			*/
	}

	iom_num = 0;
	for(slot = 0; slot != Sbus_Num_Slot; slot++) {	/* find IOM */
	
		if((bdhere[slot] & BDTYPEMASK) == IOMTYPE) {

			new_novram->new_iom_slot[iom_num].iom_slot = slot;


			if (io_conf[iom_num][0].iomslot == slot) {
				new_novram->new_iom_slot[iom_num].ext_bd_type = IOA_HERE;
				for(sub = 0; sub < MAX_IO_SLOT; sub++) {  
					/* put id into nvram */		
					new_novram->new_iom_slot[iom_num].io_bds.icb_slot[sub] = io_conf[iom_num][sub].icb_slot_id;
				}
			}

			if (ios_conf[iom_num][0].iomslot == slot) {
				new_novram->new_iom_slot[iom_num].ext_bd_type = IOSBA_HERE;
				for(sub = 0; sub < MAX_CSS_SLOT; sub++) {  
					/* put id into nvram */		
					new_novram->new_iom_slot[iom_num].io_bds.ios_slot[sub] = ios_conf[iom_num][sub].slot_id;
				}
			}
			iom_num++;
		}
	}
}


novram_ioa()
{
	uint	slot;
	uint	sub;
	uchar	iom_num;

	iom_num = 0;
	for(iom_num = 0; iom_num != IOM_PER_SYS; iom_num++) {  /* clear them */
		novram->iom_slot[iom_num].iom_slot = NOBOARD;
		for(sub = 0; sub <= MAX_IO_SLOT; sub++)
			novram->iom_slot[iom_num].icb_slot[sub] = NOBOARD;
	}

	iom_num = 0;
	for(slot = 0; slot != Sbus_Num_Slot; slot++) {	/* find IOM */
	
		if((bdhere[slot] & BDTYPEMASK) == IOMTYPE) {

			novram->iom_slot[iom_num].iom_slot = slot;

			for(sub = 0; sub < MAX_IO_SLOT; sub++) {  
				/* put id into nvram */		
				novram->iom_slot[iom_num].icb_slot[sub] = 
					io_conf[iom_num][sub].icb_slot_id;
			}
			iom_num++;
		}
	}
}

find_systype()
{
	novram->sys_type = SYS_UNKNOWN;
	if(ACRW_HERE){
		switch(myslot){
			case 0:
				printf("System90/25 sensed\n");
				novram->sys_type = SYS_25;
				break;
			case 3:
				printf("System90/15 sensed\n");
				novram->sys_type = SYS_15;
				break;
			default:
				printf("Unknown system type\n");
		}
	}
	else{
		printf("System90/45(85)sensed\n");
		novram->sys_type = SYS_45;
	}
}
