
/*------------------------------------------------------------------------------
	nov_chk.c
------------------------------------------------------------------------------*/
#include "spm.h"
#include "types.h"
#include "novram.h"
#include "disp.h"
#include "ioa0.h"
#include "icb.h"
#include "icb_config.h"
#include "rwi.h"
#include "globl.h"
#include "global.h"
#include "rwi.h"
#include "rwicio.h"
#include "rwiad.h"
#include "dev.h"

/*
**	Updated to allow structure changes for iosba
**	2 or less 1.8.7 and no IOSBA; 3 or greater 2.x IOSBA supported
*/
#define NOVRAM_VER	3
#define OLD_NOVRAM_VER	2

extern uchar bdhere[];
extern struct icb_config	io_conf[][MAXSLOTS];
extern struct iosb_config	ios_conf[][MAX_CSS_SLOT];
extern char validmap;

extern struct novram *novram; 		/* Points to Base of NVRAM. */
extern struct new_novram *new_novram;   /* Points to Base of NVRAM */


/*------------------------------------------------------------------------------
	novchk() :	Check and see if the nov ram is set up..
			If not, set it up.
------------------------------------------------------------------------------*/
novchk()
{
	register unsigned slot;
	short	i,j;
	char needupdate = 0;
	unsigned char	id,iom_num;
	struct		icb_config	*icbp;

	if (!validmap) {
		printf ("Configuration Table not valid, execute cl css.\n");
		return;
	}

	/*  check the configuration checksums  */
	if(novram->prom_crc != nov_chk_sum(0))
		nov_reconfig(1);

	if(novram->rwi_val_crc != nov_chk_sum(1))
		nov_reconfig(3);

	/*  check the CSS bus slots  */
	for(slot = 0; slot != Sbus_Num_Slot; slot++) {
	 	if(novram->css_slot[slot] != bdhere[slot]) {
			needupdate = 1;
			break;
		}
	}

	/*  check the I/O bus slots  */
	switch (novram->novram_ver) { 
		case NOVRAM_VER:
			needupdate += chk_nov_iosba();
			break;
		case OLD_NOVRAM_VER:
			needupdate += chk_nov_ioa();
			break;
		default:
			needupdate = 1;
			break;
	}

	if(needupdate) {
		printf("\n");
		printf("WARNING: Polled and Stored CONFIGURATION mismatch.\n");
		nov_reconfig(0);		/* reconfigure novram. */
	}
}


int
chk_nov_iosba()
{
	uint	iom_num = 0;
	uint	slot;
	uint	sub;

	for(slot = 0; slot != Sbus_Num_Slot; slot++) {	/* find IO module */
		if((bdhere[slot] & BDTYPEMASK) == IOMTYPE) { /* found one */
			if(new_novram->new_iom_slot[iom_num].iom_slot != slot) { 
				return(1);
			}

			if (new_novram->new_iom_slot[iom_num].ext_bd_type == IOSBA_HERE) {
				for(sub = 0; sub < MAX_CSS_SLOT; sub++)
					if(new_novram->new_iom_slot[iom_num].io_bds.ios_slot[sub] != ios_conf[iom_num][sub].slot_id)
						return(1);
			}
			else {
				for(sub = 0; sub < MAX_IO_SLOT; sub++)
					if(new_novram->new_iom_slot[iom_num].io_bds.icb_slot[sub] != io_conf[iom_num][sub].icb_slot_id)
						return(1);
			}
			iom_num++;
		}
	}
	return(0);
}


int
chk_nov_ioa()
{
	uint	iom_num = 0;
	uint	slot;
	uint	sub;

	for(slot = 0; slot != Sbus_Num_Slot; slot++) {	/* find IO module */
		if((bdhere[slot] & BDTYPEMASK) == IOMTYPE) { /* found one */
			if(novram->iom_slot[iom_num].iom_slot != slot)
				return(1);

			for(sub = 0; sub < MAX_CSS_SLOT; sub++)
				if(novram->iom_slot[iom_num].icb_slot[sub] != 
					io_conf[iom_num][sub].icb_slot_id)
					return(1);
			iom_num++;
		}
	}
	return(0);
}

