/*
 * monitor.c
 *
 */

#include "types.h"
#include "menu.h"
#include "global.h"
#include "routines.h"

extern	char	tmp_size;
extern	uchar	cur_col;

#define	NUM_CMD_BUF	8
#define	CMD_BUF_SIZE	64

char cmd_buf [NUM_CMD_BUF][CMD_BUF_SIZE];
uint current_buf;
#define	RELATIVE_BUF(buf_num) (buf_num % NUM_CMD_BUF)

monitor()
{
	/* Command buffer */
	char *cp;
	int i;
	char *getsss();

	/* Eternal loop */
	while (1) {
		printf("%s: ",menu_stack[menu_ptr].name);/* Print prompt */
		if ((cp = getsss ((CMD_BUF_SIZE - 1))) != (char *)-1) {
			/* Parse for global commands */
			global = 1;
			menu_ptr++;
			menu_stack[menu_ptr].m_ptr = global_comm;
			i = parse (cp, 0);
			menu_ptr--;
			global = 0;
			if (i == -1) 
				parse (cp, 1);	/* Parse for local commands */

		} /* Check for escape to previous menu */
		else {
			if (cp == (char *)-1) {
				if (menu_ptr > 0) {
					menu_ptr--;
				}
			}
		}
	}
}

/*
**	init_monitor - 	initialize global variables associated with
**			the monitor above
*/

init_monitor()
{
	uint	cnt;

	tmp_size = 'l';
	mref_siz = 'l';

	pagsize = 20;
	loopstat = 1; 	/* Enable continuous loops */
	lastchar = 0;
	current_buf = 0;
#ifdef	BUF_DEBUG
printf ("init monitor c_b:  %d.\n", current_buf);
#endif
	for (cnt = 0; cnt != NUM_CMD_BUF; cnt++)
		cmd_buf[cnt][0] = '\0'; /* make the initial string empty. */

	/* Set up menu pointer stack */
	menu_ptr = 0;
  	menu_stack[menu_ptr].m_ptr = boot_level;
#ifdef	SPM_PROM
	menu_stack[menu_ptr].name = "PROM Level Menu";
#endif

#ifdef	SPM_CONFIG
	menu_stack[menu_ptr].name = "DIAG Level Menu";
#endif
}


char *
getsss(limit)
register uint limit;
{
	register char *lp;
	register uchar  c;
	register uint  count = 0;
	register uint  count1 = 0;
	register uint  cnt;

	current_buf++;
#ifdef	BUF_DEBUG
printf ("In getsss, c_b:  %d.\n", current_buf);
#endif
	lp = cmd_buf[RELATIVE_BUF(current_buf)];
	cur_col = 0;

	while(count < limit) {
		c = Getchar () & 0177;	/* only take 7 bits */

		if((c >= 0x20) || (c == '\b') || (c == '\n') || (c == '\r'))
			putchar (c);	/* Echo char */

		switch(c) {
			case 18:	/* will be control R. */
				if(count1)	/* if already typed letters. */
					continue;	/* skip it. */

				/* show previous command */
				move_command (limit, (current_buf - 1));

				buf_edit (limit, (current_buf - 1));
#ifdef	BUF_DEBUG
printf ("after buf_edit c_b: %d.\n", current_buf);
printf ("getss ret:  %x.\n", cmd_buf[(current_buf % NUM_CMD_BUF)]);
#endif
				return(cmd_buf[RELATIVE_BUF(current_buf)]);
			case '\n':
			case '\r':
				if (c == '\r')
					putchar ('\n');
				*lp = '\0';
#ifdef	BUF_DEBUG
printf ("getss ret:  %x.\n", cmd_buf[RELATIVE_BUF(current_buf)]);
#endif
				return(cmd_buf[RELATIVE_BUF(current_buf)]);
			case '\b':	/* Backspace */
				if (lp <= cmd_buf[RELATIVE_BUF(current_buf)])
				      lp = cmd_buf[RELATIVE_BUF(current_buf)];
				else {
					putchar (' ');
					putchar ('\b');
					count--;
					lp--;
				}
				continue;
	    		case '@':	/* kill input line */
				for (cnt = 0; cnt != count; cnt++) /* backup */
					putchar('\b');
				for (cnt = 0; cnt != count; cnt++) /* blanks */
					putchar(' ');
				for (cnt = 0; cnt != count; cnt++) /* backup */
					putchar('\b');
				count = 0;
				lp = cmd_buf[RELATIVE_BUF(current_buf)];
				continue;
	    		case '\033':		/* escape char? */
				lp = cmd_buf[RELATIVE_BUF(current_buf)];
				*lp = '\0';
				putchar ('\n');
				return ((char *)-1);
	    		case '\032':		/* ^Z */
				if((Getchar() & 0177) == '\032')  /* TWICE */
					promstart ();
				break;
	    		default:
				count1=1;	/* show here. */
				count++;
				*lp++ = c;
				break;
		}
	}
	cmd_buf[RELATIVE_BUF(current_buf)][limit - 1] = '\0';
#ifdef	BUF_DEBUG
printf ("getss ret:  %x.\n", cmd_buf[RELATIVE_BUF(current_buf)]);
#endif
	return (cmd_buf[RELATIVE_BUF(current_buf)]);
}

