/*  menu.c
 *
 *	print_menu (ptr) - Print current local menu
 *
 *	struct menu {
 *		char *comm_text;
 *		char *comm_opt;
 *		char *comm_desc;
 *		char comm_type;
 *		unsigned char lo_limit;
 *		unsigned char hi_limit;
 *		union {
 *			PFI procedure;
 *			struct menu *menu_p;
 *		} command;
 *		char *help;
 *	};
 *
 *	Menu.comm_text is the full text for the command name, such as 'l(ist)'.
 *	Menu.comm_opt is the description of the options for the command.
 *	Menu.comm_desc is the description for the command.
 *	Menu.comm_type is one of 'c' or 'm', defining the command to be
 *		a straight command or a pointer to another menu, respectively.
 *	Menu.lo_limit is the low limit of the number of arguments allowed for
 *		the command.
 *	Menu.hi_limit is the high limit of the number of arguments allowed for
 *		the command.
 *	Menu.command is a union containing either a pointer to a procedure or
 *		a pointer to another menu.
 *	Menu.command.procedure points to the related procedure.
 *	Menu.command.menu_p points to the related sub-menu.
 *	Menu.help is a text description for this command.
 *	Menus are terminated with a null string in the menu.comm_text field.
 */
#include "types.h"
#include "menu.h"
#include "routines.h"
#include "globl.h"
#include "global.h"
#include "misc.h"

print_menu ()
{
    struct menu *mp;
    register uchar	linec = 0;
    register char	ch;

    mp = menu_stack[menu_ptr - 1].m_ptr;

    while (*mp->comm_text != '\0')
	{
		printf ("%25s  %50s  ", mp->comm_text, mp->comm_desc);
#ifdef	REMOVE
		if (mp->comm_type == 'm')
			printf (" %s", "Menu");
#endif
		putchar ('\n');
		mp++;
		linec++;

		if (linec < 23)
			continue;
		else
		{
			linec = 0;
			printf("==> <ESC> to quit; <Other Key> to continue: ");
			ch = getchar();
			printf("\r                                               \r");
			if ((ch & 0177) == ESCAPE)
				return(0);
		}
    }
    return (0);
}


print_help(comm_str, arg_cnt)
char *comm_str;
int	arg_cnt;
{
	int	i;
	char	*cp;
	char combuf[256];

	if(arg_cnt < 1)  /* if there are no arguments. */
	{
		combuf[0]=0; /* make it so. */
		printf("Which command? : ");
		if(!((cp = gets(combuf,255)) == combuf))
			return(0); /* didn't type a command. */
	}
	else
	{
		i = 0;
		while(combuf[i] = comm_args[1][i])
			i++;
		cp = combuf;	/* set pointer. */
	}
	if (argsplit(cp) == -1)
		return(0);	/* if no args to copy.. */
	if((i=com_search(comm_args[0],0, 1, 1)) != -1 && i) /* if found it */ 
		printf ("Command not found\n");
	return(0);	/* return anyway we want to. */
}
/*
 * Global menu
 *
 * These are the global commands.
 *
 */

struct init_menu i_global_comm[] = {
	"h(elp)", "", "", 'c', 0, 1, print_help, (char *)0,
#ifdef	REMOVE
	"?", "", "", 'c', 0, 0, help, (char *)0,
#endif
	"l(ist)", "", "", 'c', 0, 0, print_menu, (char *)0,
	"ls", "", "", 'c', 0, 2, print_menu, (char *)0,
	"", "", "", '\0', 0, 0, 0, (char *)0,
};

/* Note: Maximum arguments is normally MAXARGS; by specifing one more, it will
   truncate to MAXARGS when it comes back from splitargs();  so, if you specify
   more than will ever come back, it won't give you an argument error.
   At least, this is the theory I came up with.. 
*/

struct menu *global_comm = (struct menu *)i_global_comm;

    /* Make the menu stack one larger so we can do the global stuff */
struct mstack menu_stack [MENUSTACKSIZE + 1];
int menu_ptr;

