/*----------------------------------------------------------------------------
	memtest.c

	only used in SPM_CONFIG product, for MM diagnostic purposes

sizes main ram, and divides it into chunks.  Then, builds
tables in main memory (1st meg of ram) for all valid cpu's to test.  

table is a struct mem setup in main memory;  filled out in each of the
64k segments assigned to a single cpu.

The first meg of ram is divided into 16 slices of 64kbytes; one for each
of the possible processors.  In each of the slices available for the
cpu's, build a table.   When all tables have been built, go and issue
the start command to each of the cpu's.
-----------------------------------------------------------------------------*/

#include "types.h"
#include "spm.h"
#include "disp.h"
#include "novram.h"
#include "globl.h"

#define		TEST_INCR	0x04030201
#define		FIRSTMEGTST	4
#define		ONEMEG		(1024 * 1024)

/*
	update this variable if the size of tst_pat changes
*/
#define		TST_PAT_SIZ	32

extern uint	tst_pat[];
extern uchar	bdhere[];
extern struct	slotst	sf;

extern void	fill32();
extern int	check32();


firstram()	/* find and test first meg of ram. */
{
	int mm_slt;

	printf("\rTesting 1st Megabyte Memory.    \n");

	if ((mm_slt = findmem(mm_slt)) == 18) { 	/* first MM board */
		printf("\nNo MM board for memory test\n");
		return(-1);		/* bad. */
	}

	if (test1meg(mm_slt)) {		/* failed test */
		printf("\nMM in slot %d failed first ram test\n", mm_slt);
		bdhere[mm_slt] = NOBOARD;
		sf.on[mm_slt] = 0;
		return(-1); 		/* failed. */
	}

	return(0);			/* say ok to continue. */
}

test1meg(slot) /* test 1 megabyte of ram to be valid data. */
int slot;
{
	register uint tstpat;
	register uint i;
	register uint addr, addr1, addr2, readback;
	uchar x2;
	

	x2  = (uchar)CSSADD(0);
	cssmap(MAP00,slot,x2);	/* convert to nibblized address and slot */
	addr = CSSMAP(0); /* convert address to be 0x8xxxxxxx */
	addr1 = addr;	/* save it..*/
	addr2 = addr + ONEMEG; /* save ending byte, for speed. */


	/* ripple a one bit in first location */
	for (tstpat=0x00000001; tstpat; tstpat = tstpat << 1) {
		*((uint *)addr) = tstpat;
		readback = *((uint *)addr);
		if(readback != tstpat)
			return(1); /* failed.. sigh. */
	}

	/* ripple a zero bit through first location */
	for (tstpat=0xfffffffe; tstpat != (uint)0xffffffff; 
				tstpat = (tstpat << 1) | 0x00000001) {
		*((uint *)addr) = tstpat;
		readback = *((uint *)addr);
		if(readback != tstpat)
			return(1); /* failed.. sigh. */
	}

	for (i = 0; i != FIRSTMEGTST; i++) {
		fill32((uint *)addr1, (uint *)addr2, tst_pat[i], TEST_INCR);
		if (check32((uint *)addr1, (uint *)addr2, tst_pat[i],TEST_INCR))
			return (1);
	}
	return(0);
}

