
#include "types.h"
#include "misc.h"
#include "rwi.h"
#include "rwicio.h"
#include "globl.h"
#include "spm.h"
#include "novram.h"
#include "version.h"		/* This holds the prom version number. */
#include "flp.h"

extern uchar	MemSimFlag;
extern char	int_head;	/* global pointer into ringer */
extern char	int_tail;	/* global pointer into ringer */
extern char	int_flag;	/* global int counter. */
extern uchar	dtcintp;
extern char	escflag;	/* stupid old arbiter board.. */
extern char	got_berr;	/* added by YVC at 2/1/88 for testing IOM */
extern char	berr_cnt;	/* added by YVC at 2/1/88 for testing IOM */
extern char	emulate;	/* added by YVC at 2/1/88 for testing IOM */
extern char	validmap;	/* flag indicates pollslot has been done */
extern char	ignore_it;	/* If set, ignore CSS bus errors. */
extern char	booting;	/* if set, we ignore int's.. */
extern uint	ps_num;		/* tgm added 10/7/88 for rwi ADC stuff. */
extern char	lastblk;	/* if set, don't issue fmk error from tape. */
extern char	diskflg;	/* set this when reading from disk. */
extern char	ioinit;		/* added by YVC at 2/1/88 for testing IOM */
extern int	ioa_tchd;
extern uchar	modem_on;
extern uchar	printer_on;

#ifdef	SPM_PROM
extern int	rwi_test;
extern uchar	spinning; 	/* floppy motor on? */
extern uchar	current_cyl; 	/* current floppy cylinder */
#endif

#ifdef	SPM_CONFIG
extern uchar	i_cnt;		/* global int counter. */
extern char	dummiebd;	/* stupid old arbiter board.. */
extern char	cpuack;
extern char	ipcctest;
extern char	tstdisp;	/* dispatcher testing. */
extern char	overflow;	/* dispatcher test mode. */
extern uchar	t_4_rd;		/* added by YVC at 2/1/88 for testing IOM */
extern uchar	rd_2;		/* added by YVC at 2/1/88 for testing IOM */
extern char	iom_tst_flag;	/* added by YVC at 2/1/88 for testing IOM */
extern char	resp_ov_test;	/* added by YVC at 2/1/88 for testing IOM */
extern char	no_resp;	/* added by YVC at 2/1/88 for testing IOM */
extern char	mis;		/* added by YVC at 2/1/88 for testing IOM */

#ifdef REMOVE
extern uint	mactime;	/* Macro buffer loop timer */
extern char	all_flag;	/* this is set to zero when we want to. */
extern uchar 	pwr_test;
#endif

extern char	tsterrs;	/* this is set to zero when we want to. */
extern uchar	io_int_test;	/* this is set to zero when we want to. */
extern char	iom_addr_flag;	/* this is set to zero when we want to. */
extern char	cputest2;	/* if set, we ignore int's.. */
extern char	disptest;	/* show a poll slots has been done. */
extern char	to_css;	/* if set to a value, used for clock switching status */
extern ulong	seconds, timer_int_cntr;
extern ulong	clock_sec, timer_cntr;
extern uchar	myslot;
extern uchar	pwrcmd;
#endif

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
main()
{
	register  uint	i, z;

/* common variables to SPM_PROM and SPM_CONFIG */

	z = 0;

	Verbose		= 1;
	MemSimFlag	= FALSE;	/* its off for normal usage. */
	AbortFlag	= FALSE; 
	IntCounter	= z;
	ioa_tchd	= z;
	int_head	= z;	/* global pointer into ringer */
	int_tail	= z;	/* global pointer into ringer */
	int_flag	= z;	/* global int counter. */
	dtcintp		= z;	/* global int counter. */
	Seconds 	= z; 
	SpurCount 	= z;
	HndlBerr 	= z; 
	HndlInt 	= z; 
	escflag 	= z;
	got_berr 	= z;	/* added by YVC */
	berr_cnt 	= z;	/* added by JPW */
	emulate 	= z;	/* added by YVC */
	ioinit 		= z;	/* added by YVC */
	ignore_it 	= z;	/* if set, ignore CSS bus errors. */
	booting		= z;
	IntToMon 	= TRUE;
	ps_num 		= z;	/* tgm added 10/7/88 for rwi ADC stuff. */
	validmap 	= z;	/* clear pollslot flag */
	diskflg 	= z;
	lastblk 	= z;	/* if set, don't issue fmk error from tape. */

#ifdef	SPM_PROM
	rwi_test 	= z;	/* tgm added 10/7/88 for rwi ADC stuff. */
	*WRCNTL2 	&= ~WR2_GRNLED;	/* tgm green led */
	printer_on 	= (uchar)NOVRAM->printer_active;
	modem_on 	= (uchar)NOVRAM->modem_active;
				/* Floppy device initialization */
	for (i = 0; i != 0x20000; i++); 
	migrate();
	spinning 	= z;
	current_cyl 	= NEED_RECAL;
#endif

#ifdef	SPM_CONFIG
	i_cnt		= z;	/* global int counter. */
	dummiebd 	= z;
	cpuack 		= z;
	overflow 	= z;
	resp_ov_test 	= z;
	no_resp 	= z;
	mis 		= z;
	tstdisp		= z;	/* dispatcher testing. */
	t_4_rd 		= z;	/* added by YVC */
	rd_2 		= z;	/* added by YVC */
	iom_tst_flag 	= z;	/* added by YVC */
	disptest 	= z;	/* show a poll slots has been done. */
#ifdef REMOVE
	mactime 	= z;	/* clear timer. */
	all_flag 	= z;	/* this is set to zero when we want to. */
	pwr_test 	= z;
#endif
	tsterrs 	= z;	/* this is set to zero when we want to. */
	to_css 		= z;	/* make sure it's cleared out. */
	io_int_test 	= z;	/* this is set to zero when we want to. */
	iom_addr_flag 	= z;	/* this is set to zero when we want to. */
	ipcctest	= z;
	cputest2	= z;
	seconds		= z;
	timer_int_cntr	= z;
	myslot 		= (uchar)(((*STATUSREG & STAT_SLOTMASK)>>24) & 0x0f);
	pwrcmd 		= z;
#endif

	chgint(0); 		/* ready for interrupts */
	n_ps_m();		/* Normalize the Power Supply Margins */
	Clock((char *)0, 0);	/* just print it out. */
	return(0);
}


version()	/* print what version number this is. */
{
#ifdef	SPM_PROM
	printf("\nSPM PROM Version %d.%d.%d\n\n", 
		RELEASE, VERSION, PRE_REL);
#endif

#ifdef	SPM_CONFIG
	printf("\nSPM DIAG Image Version %d.%d.%d\n\n", 
		RELEASE, VERSION, PRE_REL);
#endif
}


/*
**	Initialization of variables to be done ONCE and ONLY ONCE,
**	this is executed during the cold power phase
**
**	defined in both PROM and CONFIG products (called from 'startup.s'),
**	but in the case of CONFIG, this routine should never be called.
*/
cold_pwr_init()
{
#ifdef	SPM_PROM
	modem_on = 0;
	NOVRAM->modem_active = 0;
	printer_on = 0;
	NOVRAM->printer_active = 0;
	NOVRAM->shared_crc = nov_chk_sum(2);
#endif
}



#ifdef	SPM_CONFIG
/*
**	A little kludge which makes use of a name change......
**	
**	init_stuff is used in the PROMS to initialize the SCC and
**	local CIO.  These are not initialized by the configuration
**	image, however, these variables need to be set up at this
**	time.......hence this little kludge.
*/

init_stuff()
{
	
	modem_on = NOVRAM->modem_active;
	printer_on = NOVRAM->printer_active;
}
#endif

