
#include "types.h"
#include "spm.h"
#include "ipcc.h"
#include "memerr.h"

extern	char	got_berr;
extern	char	emulate;
extern	uchar	myslot;		/* This is where I am. */

/* if we compile the PROM product, only the 'ipccsend' routine is concerned */
/* (last routine of this file). Else, we add all the other routines */

#ifdef	SPM_CONFIG		/* the "#endif" is way down there */
extern	char	ipcctest;
extern	char	cpuacked;

static	struct	mtest	mtarray[MAXSLOT];
static	struct	ipcc *ipp;	/* Should point to the slot structure. */
static	uchar	ipcc_xfer;	/* Enable data transfer. */
static	int	out = 0;


/*------------------------------------------------------------------------------
	ipccint(): Handles the an ipcc command interrupt request.
------------------------------------------------------------------------------*/
ipccint()
{
	register int cpuslot, cmd; 
	register long data, err;
	register ulong i, *jdata, *ptr;
	register struct rcd	*rcdp;		/* remote cmd descriptor ptr */
	ulong oldiomap, *iomapaddr;
	uchar *cp, *cptr;
	ushort *wptr;
	char addr;

	cmd = (*STATUSREG >> 8) & 0xff;
	cpuslot = (uchar)(((*(ulong *)STATUSREG & SRC_MASK)>>16) & 0x0f);

	data = *CSSCMD;			/* Get the data form the bus. */
	err = *CSSERROR;		/* Get the error code if any. */
	ipp = &cpustruct[cpuslot];	/* current ipcc slot ptr */
	ipcctest = 1;
#ifdef DEBUG
	printf("IPCC: cmd = %x\n",cmd);
#endif
	switch (cmd) {			/* Handle the command. */
		case IPCC_NOP: 
			break;
		case IPCC_ACK: 
			ipp->acck = 1; 
			break;
		case IPCC_NACK: 
			ipp->nack = 1; 
			break;
		case IPCC_ERROR: 
			ipp->error = 1; 
			break;
		case IPCC_CANCEL: 
			ipp->cancel = 1; 
			break;
		case IPCC_SLOT: 
			ipp->slot = (uchar)data; 
			break;
		case IPCC_ADDR: 
			ipp->addr = data; 
			break;
		case IPCC_DATA: 
			ipp->data = data; 
			break;
		case IPCC_SIZE: 
			ipp->size = data; 
			break;
		case IPCC_PACKET:
			/* send a NACK */
			if (!ipcc_xfer) { 
				nackit(cpuslot); 
				break; 
			}
			*(ulong *)ipp->addr = data;
			ipp->addr += 4;
			break;
		case IPCC_FDATA: 
			ipp->data = data; 
			break;
		case IPCC_COUNT: 
			ipp->count = data; 
			break;
		case IPCC_WRITE:
			switch (ipp->size) {
		 		case 1: 
					*(uchar *)data = (uchar)ipp->data; 
					break;
				case 2: 
					*(ushort *)data = (ushort)ipp->data; 
					break;
				case 4: 
					*(ulong *)data = (ulong)ipp->data; 
					break;
				default:
					printf("IPCC_WRITE bogus size 0x%x.\n",
						ipp->size);
					/* send a NACK */
					nackit(cpuslot);	
					break;
			}
			break;
		case IPCC_READ:
			switch(ipp->size) {
				case 1: 
					ipp->data = (ulong)(*(uchar *)data); 
					break;
				case 2: 
					ipp->data = (ulong)(*(ushort *)data); 
					break;
				case 4: 
					ipp->data = *(ulong *)data; 
					break;
				default:
					printf ("IPCC_READ bogus size 0x%x.\n",
						ipp->size);
					/* send a NACK */
					nackit(cpuslot);
					break;
			}
			break;
		case IPCC_XTO_START: 
			ipp->addr = data; 
			ipcc_xfer = 1; 
			break;
		case IPCC_XFROM_START:	/* Data=start address, ipp->data=count*/
			jdata = (ulong *)data;
			for (i = ipp->count; i > 0; i--) { /* Send data as ack*/
				if (ipsendwt(cpuslot, IPCC_FDATA, *jdata++)) {
					printf ("IPCC_XFROM Failed\n");
					/* indicate a failure */
					nackit(cpuslot);
				}
			}
			break;
		case IPCC_XEND: 
			ipcc_xfer = 0; 
			break;
		case IPCC_DSEND:
			/* send the data */
	    		if (ipsendwt(cpuslot, IPCC_DATA, ipp->data)) { 
				printf ("IPCC_DSEND Failed\n");
				nackit(cpuslot);
				break;
	    		}
			break;
		case IPCC_STDOUT_ENA: 
			ipp->stdout = 1; 
			break;
		case IPCC_STDOUT_DIS: 
			ipp->stdout = 0; 
			break;
		case IPCC_MM_SLOT:
#ifdef DEBUG
	printf("MM_SLOT: data=%x\n",data);
#endif
			if ((uchar)data >= 0x10) { 
				nackit(cpuslot); 
				break; 
			}
			ipp->MMslot = (uchar)data;
			break;
		case IPCC_MM_OFFSET: 
			ipp->MMaddr = data; 
			break;
		case IPCC_MM_FILL:	/* Memory fill/verify requests */
		case IPCC_MM_VERIFY:
#ifdef DEBUG
	printf("cmd=%x start=%x MM_SLOT=%x count=%x size=%x pattern=%x\n",
	cmd,ipp->MMaddr,ipp->MMslot,ipp->count,ipp->size,data);
#endif
			addr = (uchar)CSSADD(ipp->MMaddr & 0xfffff);
			cssmap(MAP00, (uchar)ipp->MMslot, addr);
			ipp->cancel = 0;
			ptr = (ulong *)CSSMAP(ipp->MMaddr & 0xfffff);
			wptr = (ushort *)ptr;
			cptr = (uchar *)ptr;
			/* Loop until ipp->count. */
			for (i = 0; i < ipp->count; i++) { 
				switch (cmd) {
					case IPCC_MM_FILL: /* Memory fill. */
						switch (ipp->size) {
							case 1: 
								*cptr++ = (uchar)data; 
								break;
							case 2: 
								*wptr++ = (ushort)data; 
								break;
							case 4: 
								*ptr++ = data; 
								break;
							default:
								printf("IPCC_MM_FILL bogus size.\n");
								nackit(cpuslot);
								break;
						}
						break;
					case IPCC_MM_VERIFY:	/* Memory verify request */
						switch (ipp->size) {
			    			case 1:
							if((uchar)ipp->data != (*cptr++)) {
								nackit(cpuslot);
								out=2;
							}
							break;
			    			case 2:
							if((ushort)ipp->data != (*wptr++)) {
								nackit(cpuslot);
								out=2;
							}
							break;
			    			case 4:
							if(ipp->data != *ptr++) {
								nackit(cpuslot);
								out=2;
							}
							break;
			    			default:
							nackit(cpuslot);
							out=2;
							break;
						}
						break;
					}
					if ((out==2) || ipp->cancel) 
						break;
    			}
	    		break;
		case IPCC_MM_ERRA:	/* report error MM address */
			mtarray[cpuslot].err_addr = data;
			break;
		case IPCC_MM_ERRD:	/* report error read data */
			mtarray[cpuslot].err_rdata = data;
			break;
		case IPCC_MM_ERRXD:	/* report expected data */
			mtarray[cpuslot].err_xdata = data;
			break;
		case IPCC_MM_ERRS:	/* report error MM slot */
			mtarray[cpuslot].err_mslot = (uchar)data;
			break;
		case IPCC_MM_ERRC:	/* report MM error code */
			mtarray[cpuslot].err_code = (uchar)data;
			mtarray[cpuslot].err_valid = 1;
			break;
		case IPCC_MM_LPC:	/* increment MM loop count */
			mtarray[cpuslot].ccnt = data;
			break;
		default:		/* For rest of undefined commands */
			cmd = IPCC_ACK;	/* This is so we don't send an ACK */
	    	break;
    	}

	if((cpuslot!=myslot) && (cmd!=IPCC_ACK) && (!out) &&
			(cmd!=IPCC_NACK) && (cmd != IPCC_ERROR))
		ipccsend(cpuslot, IPCC_ACK, 0x12345678);
}
/****************************[ end of main routine ]***************************/

/*------------------------------------------------------------------------------
	nackit() : Send a NACK to the PM.
------------------------------------------------------------------------------*/
nackit(s) 
uchar s;
{ 
	ipccsend(s,IPCC_NACK, 1); 
	out = 2; 
}

/*------------------------------------------------------------------------------
	ipsendwt: Send a command and data to the specified slot and wait.
------------------------------------------------------------------------------*/
ipsendwt(cpuslot, cmd, data)
register uchar cpuslot, cmd;
register ulong data;
{
	int i;

	ipccsend(cpuslot, cmd, data);	/* Send the command */
	for (i = 0; (i < 246000) && (!cpuacked); i++); /* Deadman's loop. */
	if (i >= 246000) {		/* If no then ERROR!!!... */
		printf("\nACK Not found on :%08X:%08X:\n", cmd, data);
		return(1);
		}
	return(0);			/* Return no error */
}
#endif

/*------------------------------------------------------------------------------
	ipccsend: Set up MAP07 then send a command using the ipcc structure.
------------------------------------------------------------------------------*/
ipccsend(cpuslot, cmd, data)			/* Uses MAP07 for targeting. */
int cpuslot, cmd;
ulong data;
{
	register uint ipcmd;
	char	emulate_save = emulate;

	int	i;

#ifdef	SPM_CONFIG
	cpuacked = 0;
#endif
	got_berr = 0;			/* Get ready for any errors. */
	emulate = 1;			/* Set this. */

	cssmap(MAP01,cpuslot,myslot);		/* Setup the MAP before using */
	ipcmd = 0x90000000 | ((int)cmd<<8); 	/* Setup MAP1 in the BUS Ok */
	*((uint *)ipcmd) = (int)data;	/* Now send the command */
	if(got_berr) {				/* Failed command send. */
		printf("Bus error on send command : cpu=%x cmd=%x data=%x.\n",
		cpuslot,cmd,data);
		emulate = emulate_save;
		got_berr = 0;
		return(1);
	}
	for (i = 0; i < 7000; i++);
	emulate = emulate_save;
	got_berr = 0;			/* Clear the errors. */
	return(0);
}
