/*
 * types.h
 */

typedef int (*PFI)();
typedef unsigned long ulong;
typedef unsigned short ushort;
typedef unsigned char uchar;
typedef unsigned char unchar;
typedef unsigned int uint;

#define MAP00		00		/* map ram 0 */
#define MAP01		01		/* map ram 1 */
#define MAP02		02		/* map ram 2 */
#define MAP03		03		/* map ram 3 */
#define MAP07		07		/* map ram 7 */

#define CSSMAP(addr)    ((addr & 0x0fffffff) | 0x80000000)   /* CSS map addr */
#define CSSADD(addr)    ((addr & 0xf0000000) >> 28)

	/* Defines for memory board registers */
#define TEST2MOD 0x78 			/* EDAC and int enabled. */
#define	EDAC_ERR_INFO_REG 	((unsigned int *)0x9fffffec)
#define	EDAC_ERR_ADDR_REG 	((unsigned int *)0x9ffffff4)
#define	EDAC_INT_INFO_REG 	((unsigned int *)0x9fffffc4)
#define	EDAC_STAT_REG 		((unsigned int *)0x9ffffffc)
#define	EDAC_CHKBIT_REG 	((unsigned char *)0x9fffffe7)
#define	EDAC_CTL_REG 		((unsigned char *)0x9fffffe4)

#define	isdigit(c)		((c>='0')&&(c<='9'))
#define CSS_CAGE 0x0f
