#ident	"%Z%stand/cmd/spm/head:%M%	%I%"

#ifndef SYS_SBUS_MM_H
#define SYS_SBUS_MM_H


/*
 * mm.h
 *
 *	Defines for the S3000 Memory Module
 */


#define MM_STATUS_REG		(unsigned *)0xfffffffc

/*
 * MM_STATUS_REG fields:
 */

#define MM_BOARD_ID_MASK	0xff

/* set if board is stuffed with 4Mbit rams */

#define MM_4MBIT_RAM		0x400

/* 3 bits which specify how many quadrants of the board are stuffed */

#define MM_STUFFING_MASK	0xb00

/* last check bits written to either array (n/a on a partial write) */

#define MM_LCBW_MASK		0x7f0000


/*
 * unshifted values for interpreting the MM_STUFFING_MASK
 */

#define MM_FULLY_STUFFED	0xb00
#define MM_HALF_STUFFED		0xa00
#define MM_QUARTER_STUFFED	0x900
#define MM_EIGTH_STUFFED	0x800
#define MM_SIXTEENTH_STUFFED	0x000

/* number of bytes for different stuffing options, stuffed with 1Mbit chips */

#define MM_FULL_COUNT		0x2000000
#define MM_HALF_COUNT		0x1000000
#define MM_QUARTER_COUNT	0x0800000
#define MM_EIGTH_COUNT		0x0400000
#define MM_SIXTEENTH_COUNT	0x0200000



/*
 * A long word read from this register will show the address at which
 * the last EDAC error occurred which has not yet had its interrupt
 * reset. (single or multiple bit errors).
 */

#define MM_ERR_ADDR_REG		(unsigned *)0xfffffff4

/*
 * the top nibble of an MM address is insignificant.  all
 * combinations of the 4 bits map to the same location.  the
 * error address register places an 0xf in the top nibble.
 * we mask it out here.
 */

#define GET_MM_ERR_ADDR(n)	(unsigned)(n & 0x0fffffff)

/*
 * memory module error information register contains information
 * for the first error that occurred since the register was
 * last read.  reading this register renables both it and the
 * error address register.
 *
 * so the error address information must be read first.
 */

#define MM_ERR_INFO_REG		(unsigned *)0xffffffec

/*
 * MM_ERR_INFO_REG fields:
 */


/* single bit error (correctable) on array 0 */
#define MM_A0_SB_ERR		0x80000000		/* ACTIVE LOW */

/* mask syndrome for error on array 0 */
#define MM_A0_SYN_MASK		0x7f000000		/* ACTIVE LOW */

/* multiple bit error (uncorrectable) on array 0 */
#define MM_A0_MB_ERR		0x00800000		/* ACTIVE LOW */

/* error information for array 0 */
#define MM_A0_ERR_INFO_MASK	0x007f0000		/* ACTIVE LOW */


/* single bit error (correctable) on array 1 */
#define MM_A1_SB_ERR		0x00008000		/* ACTIVE LOW */

/* mask syndrome for error on array 1 */
#define MM_A1_SYN_MASK		0x00007f00		/* ACTIVE LOW */

/* multiple bit error (uncorrectable) on array 1 */
#define MM_A1_MB_ERR		0x00000080		/* ACTIVE LOW */

/* error information for array 1 */
#define MM_A1_ERR_INFO_MASK	0x0000007f		/* ACTIVE LOW */

/*
 * defines for dealing with the error information:
 */

#define MM_A0_SYN_SHIFT		24
#define MM_A1_SYN_SHIFT		8
#define MM_A0_ERR_INFO_SHIFT	16
#define MM_A1_ERR_INFO_SHIFT	0
/* picking active low bits out of right shifted error information */
#define MM_READ_ERROR		0x40
#define MM_READ_16_ERROR	0x20
#define MM_READ_32_ERROR	0x10

/* for use with these active low bits */
#define MM_ERROR		0

/* given the value from the mm_err_info_reg, pick out the syndrome */
#define GET_A0_SYNDROME(n)	((n & MM_A0_SYN_MASK) >> MM_A0_SYN_SHIFT)
#define GET_A1_SYNDROME(n)	((n & MM_A1_SYN_MASK) >> MM_A1_SYN_SHIFT)

#define GET_A0_ERR_INFO(n)	((n&MM_A0_ERR_INFO_MASK)>>MM_A0_ERR_INFO_SHIFT)
#define GET_A1_ERR_INFO(n)	((n&MM_A1_ERR_INFO_MASK)>>MM_A1_ERR_INFO_SHIFT)

/* return the slot from right shifted error information word */
#define GET_SLOT_FROM_ERR_INFO(n)	(n & 0xf)


/*
 * the MM control register is readable only as a long word.
 *
 * it is BYTE WRITABLE ONLY.
 *
 */
#define MM_CONTROL_REG		(unsigned char *)0xffffffe4

/*
 * MM_CONTROL_REG fields:
 */

#define MM_RED_LED_OFF		0x40
#define MM_GREEN_LED_ON 	0x20
#define MM_GREEN_LED_OFF	0x00
#define MM_ERR_INT_ENABLE	0x10
#define MM_EDAC_ENABLE		0x08
/* force parity errors */
#define MM_PARITY_ENABLE	0x04
/* enable check bit as data mode */
#define MM_CB_AS_DATA_ENABLE	0x02
/* enable diagnostic mode */
#define MM_DIAG_MODE_ENABLE	0x01


#define MM_INT_INFO_REG		(unsigned *)0xffffffc4

/*
 * MM_INT_INFO_REG fields:
 */


#define MM_INT_VECTOR_MASK	0xff000000
#define MM_INT_PRI_MASK		0x007f0000

/*
 * MM bug here:
 *
 *	The four bits of slot information are used to tell the MM where
 *	the interrupt dispatcher is.  On directed interrupts this will
 *	also be the ultimate destination, thus if the MM is to send directed
 *	error interrupts, they may only be sent to the SPM.
 */

#define MM_INT_SLOT_MASK	0x0000f000

/*
 * low order 12 bits of address the MM will sent its interrupt to.
 * 31-12 are tied high, 35-32 are the dest slot.
 */

#define MM_INT_ADDR_MASK	0x00000fff


/* number of bits to shift a slot id to place it into the int_info_reg */
#define MM_INT_ID_SHIFT		12

/* shift to place a value in the vector byte of the int_info_reg */
#define MM_INT_VEC_SHIFT	24

#endif /* SYS_SBUS_MM_H */


