/* sa_dir.h */

#define MAX_DIR_ENTRY	31
#define MAX_DIR_NAME	15
#define DIR_BLK_NUM	0x100
#define BLK_SIZE	0x400

struct sa_dir {
	unsigned short	magic_num;		/* magic number for ldsa */
	unsigned char	major_version;		/* bootimage major version # */
	unsigned char	minor_version;		/* bootimage minor version # */
	unsigned int	next_dir_block;		/* next directory block
					   	   0 means this is the last */
	unsigned int	block_size;		/* block size of data */
	unsigned int	bootimage_size;		/* entire bootimage size */
	unsigned char	pad[16];		/* byte pad */
	struct {
		unsigned char	name[MAX_DIR_NAME];/* program name */
		unsigned char	major_version;	/* program major version # */
		unsigned char	minor_version;	/* program minor version # */
		unsigned int	start_block_num;/* program start block */
		unsigned int	byte_count;	/* program byte count */
		unsigned char	spm_exec;	/* set if spm local execution */
		unsigned char	pad[5];		/* byte pad */
	} entry[MAX_DIR_ENTRY];
};	


struct osa_dir {
	unsigned char	name[MAX_DIR_NAME];
	unsigned char	major_version;
	unsigned char	minor_version;
	unsigned	start_block_num;
	unsigned	last_block_num;
	unsigned	byte_count;
	unsigned short	pad;
};	

